/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.message.CodeBuffer;
import org.apache.kafka.message.HeaderGenerator;
import org.apache.kafka.message.MessageGenerator;
import org.apache.kafka.message.MessageSpec;

public final class ApiMessageTypeGenerator {
    private final HeaderGenerator headerGenerator = new HeaderGenerator();
    private final CodeBuffer buffer;
    private final TreeMap<Short, ApiData> apis = new TreeMap();

    public ApiMessageTypeGenerator() {
        this.buffer = new CodeBuffer();
    }

    public void registerMessageType(MessageSpec spec) {
        switch (spec.type()) {
            case REQUEST: {
                short apiKey = spec.apiKey().get();
                ApiData data = this.apis.get(apiKey);
                if (!this.apis.containsKey(apiKey)) {
                    data = new ApiData(apiKey);
                    this.apis.put(apiKey, data);
                }
                if (data.requestSpec != null) {
                    throw new RuntimeException("Found more than one request with API key " + spec.apiKey().get());
                }
                data.requestSpec = spec;
                break;
            }
            case RESPONSE: {
                short apiKey = spec.apiKey().get();
                ApiData data = this.apis.get(apiKey);
                if (!this.apis.containsKey(apiKey)) {
                    data = new ApiData(apiKey);
                    this.apis.put(apiKey, data);
                }
                if (data.responseSpec != null) {
                    throw new RuntimeException("Found more than one response with API key " + spec.apiKey().get());
                }
                data.responseSpec = spec;
                break;
            }
        }
    }

    public void generate() {
        this.buffer.printf("public enum ApiMessageType {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.generateEnumValues();
        this.buffer.printf("%n", new Object[0]);
        this.generateInstanceVariables();
        this.buffer.printf("%n", new Object[0]);
        this.generateEnumConstructor();
        this.buffer.printf("%n", new Object[0]);
        this.generateFromApiKey();
        this.buffer.printf("%n", new Object[0]);
        this.generateNewApiMessageMethod("request");
        this.buffer.printf("%n", new Object[0]);
        this.generateNewApiMessageMethod("response");
        this.buffer.printf("%n", new Object[0]);
        this.generateAccessor("apiKey", "short");
        this.buffer.printf("%n", new Object[0]);
        this.generateAccessor("requestSchemas", "Schema[]");
        this.buffer.printf("%n", new Object[0]);
        this.generateAccessor("responseSchemas", "Schema[]");
        this.buffer.printf("%n", new Object[0]);
        this.generateToString();
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.headerGenerator.generate();
    }

    private void generateEnumValues() {
        int numProcessed = 0;
        for (Map.Entry<Short, ApiData> entry : this.apis.entrySet()) {
            ApiData apiData = entry.getValue();
            String name = apiData.name();
            this.buffer.printf("%s(\"%s\", (short) %d, %s, %s)%s%n", MessageGenerator.toSnakeCase(name).toUpperCase(Locale.ROOT), MessageGenerator.capitalizeFirst(name), entry.getKey(), apiData.requestSchema(), apiData.responseSchema(), ++numProcessed == this.apis.size() ? ";" : ",");
        }
    }

    private void generateInstanceVariables() {
        this.buffer.printf("private final String name;%n", new Object[0]);
        this.buffer.printf("private final short apiKey;%n", new Object[0]);
        this.buffer.printf("private final Schema[] requestSchemas;%n", new Object[0]);
        this.buffer.printf("private final Schema[] responseSchemas;%n", new Object[0]);
        this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.Schema");
    }

    private void generateEnumConstructor() {
        this.buffer.printf("ApiMessageType(String name, short apiKey, Schema[] requestSchemas, Schema[] responseSchemas) {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.buffer.printf("this.name = name;%n", new Object[0]);
        this.buffer.printf("this.apiKey = apiKey;%n", new Object[0]);
        this.buffer.printf("this.requestSchemas = requestSchemas;%n", new Object[0]);
        this.buffer.printf("this.responseSchemas = responseSchemas;%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateFromApiKey() {
        this.buffer.printf("public static ApiMessageType fromApiKey(short apiKey) {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.buffer.printf("switch (apiKey) {%n", new Object[0]);
        this.buffer.incrementIndent();
        for (Map.Entry<Short, ApiData> entry : this.apis.entrySet()) {
            ApiData apiData = entry.getValue();
            String name = apiData.name();
            this.buffer.printf("case %d:%n", entry.getKey());
            this.buffer.incrementIndent();
            this.buffer.printf("return %s;%n", MessageGenerator.toSnakeCase(name).toUpperCase(Locale.ROOT));
            this.buffer.decrementIndent();
        }
        this.buffer.printf("default:%n", new Object[0]);
        this.buffer.incrementIndent();
        this.headerGenerator.addImport("org.apache.kafka.common.errors.UnsupportedVersionException");
        this.buffer.printf("throw new UnsupportedVersionException(\"Unsupported API key \" + apiKey);%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateNewApiMessageMethod(String type) {
        this.headerGenerator.addImport("org.apache.kafka.common.protocol.ApiMessage");
        this.buffer.printf("public ApiMessage new%s() {%n", MessageGenerator.capitalizeFirst(type));
        this.buffer.incrementIndent();
        this.buffer.printf("switch (apiKey) {%n", new Object[0]);
        this.buffer.incrementIndent();
        for (Map.Entry<Short, ApiData> entry : this.apis.entrySet()) {
            this.buffer.printf("case %d:%n", entry.getKey());
            this.buffer.incrementIndent();
            this.buffer.printf("return new %s%sData();%n", entry.getValue().name(), MessageGenerator.capitalizeFirst(type));
            this.buffer.decrementIndent();
        }
        this.buffer.printf("default:%n", new Object[0]);
        this.buffer.incrementIndent();
        this.headerGenerator.addImport("org.apache.kafka.common.errors.UnsupportedVersionException");
        this.buffer.printf("throw new UnsupportedVersionException(\"Unsupported %s API key \" + apiKey);%n", type);
        this.buffer.decrementIndent();
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateAccessor(String name, String type) {
        this.buffer.printf("public %s %s() {%n", type, name);
        this.buffer.incrementIndent();
        this.buffer.printf("return this.%s;%n", name);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    private void generateToString() {
        this.buffer.printf("@Override%n", new Object[0]);
        this.buffer.printf("public String toString() {%n", new Object[0]);
        this.buffer.incrementIndent();
        this.buffer.printf("return this.name();%n", new Object[0]);
        this.buffer.decrementIndent();
        this.buffer.printf("}%n", new Object[0]);
    }

    public void write(BufferedWriter writer) throws IOException {
        this.headerGenerator.buffer().write(writer);
        this.buffer.write(writer);
    }

    private static final class ApiData {
        short apiKey;
        MessageSpec requestSpec;
        MessageSpec responseSpec;

        ApiData(short apiKey) {
            this.apiKey = apiKey;
        }

        String name() {
            if (this.requestSpec != null) {
                return MessageGenerator.stripSuffix(this.requestSpec.name(), "Request");
            }
            if (this.responseSpec != null) {
                return MessageGenerator.stripSuffix(this.responseSpec.name(), "Response");
            }
            throw new RuntimeException("Neither requestSpec nor responseSpec is defined for API key " + this.apiKey);
        }

        String requestSchema() {
            if (this.requestSpec == null) {
                return "null";
            }
            return String.format("%sData.SCHEMAS", this.requestSpec.name());
        }

        String responseSchema() {
            if (this.responseSpec == null) {
                return "null";
            }
            return String.format("%sData.SCHEMAS", this.responseSpec.name());
        }
    }
}

