/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.message.EntityType;
import org.apache.kafka.message.FieldType;
import org.apache.kafka.message.MessageGenerator;
import org.apache.kafka.message.StructSpec;
import org.apache.kafka.message.Versions;

public final class FieldSpec {
    private final String name;
    private final Versions versions;
    private final List<FieldSpec> fields;
    private final FieldType type;
    private final boolean mapKey;
    private final Versions nullableVersions;
    private final String fieldDefault;
    private final boolean ignorable;
    private final EntityType entityType;
    private final String about;

    @JsonCreator
    public FieldSpec(@JsonProperty(value="name") String name, @JsonProperty(value="versions") String versions, @JsonProperty(value="fields") List<FieldSpec> fields, @JsonProperty(value="type") String type, @JsonProperty(value="mapKey") boolean mapKey, @JsonProperty(value="nullableVersions") String nullableVersions, @JsonProperty(value="default") String fieldDefault, @JsonProperty(value="ignorable") boolean ignorable, @JsonProperty(value="entityType") EntityType entityType, @JsonProperty(value="about") String about) {
        this.name = Objects.requireNonNull(name);
        this.versions = Versions.parse(versions, null);
        if (this.versions == null) {
            throw new RuntimeException("You must specify the version of the " + name + " structure.");
        }
        this.fields = Collections.unmodifiableList(fields == null ? Collections.emptyList() : new ArrayList<FieldSpec>(fields));
        this.type = FieldType.parse(Objects.requireNonNull(type));
        this.mapKey = mapKey;
        this.nullableVersions = Versions.parse(nullableVersions, Versions.NONE);
        if (!this.nullableVersions.empty() && !this.type.canBeNullable()) {
            throw new RuntimeException("Type " + this.type + " cannot be nullable.");
        }
        this.fieldDefault = fieldDefault == null ? "" : fieldDefault;
        this.ignorable = ignorable;
        this.entityType = entityType == null ? EntityType.UNKNOWN : entityType;
        this.entityType.verifyTypeMatches(name, this.type);
        String string = this.about = about == null ? "" : about;
        if (!this.fields().isEmpty() && !this.type.isArray()) {
            throw new RuntimeException("Non-array field " + name + " cannot have fields");
        }
    }

    public StructSpec toStruct() {
        if (!this.type.isArray() && this.type.isStruct()) {
            throw new RuntimeException("Field " + this.name + " cannot be treated as a structure.");
        }
        return new StructSpec(this.name, this.versions.toString(), this.fields);
    }

    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    String capitalizedCamelCaseName() {
        return MessageGenerator.capitalizeFirst(this.name);
    }

    String camelCaseName() {
        return MessageGenerator.lowerCaseFirst(this.name);
    }

    String snakeCaseName() {
        return MessageGenerator.toSnakeCase(this.name);
    }

    public Versions versions() {
        return this.versions;
    }

    @JsonProperty(value="versions")
    public String versionsString() {
        return this.versions.toString();
    }

    @JsonProperty(value="fields")
    public List<FieldSpec> fields() {
        return this.fields;
    }

    @JsonProperty(value="type")
    public String typeString() {
        return this.type.toString();
    }

    public FieldType type() {
        return this.type;
    }

    @JsonProperty(value="mapKey")
    public boolean mapKey() {
        return this.mapKey;
    }

    public Versions nullableVersions() {
        return this.nullableVersions;
    }

    @JsonProperty(value="nullableVersions")
    public String nullableVersionsString() {
        return this.nullableVersions.toString();
    }

    @JsonProperty(value="default")
    public String defaultString() {
        return this.fieldDefault;
    }

    @JsonProperty(value="ignorable")
    public boolean ignorable() {
        return this.ignorable;
    }

    @JsonProperty(value="about")
    public String about() {
        return this.about;
    }
}

