/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import java.util.Optional;
import org.apache.kafka.message.MessageGenerator;

public interface FieldType {
    public static final String STRUCT_PREFIX = "[]";

    public static FieldType parse(String string) {
        switch (string = string.trim()) {
            case "bool": {
                return BoolFieldType.INSTANCE;
            }
            case "int8": {
                return Int8FieldType.INSTANCE;
            }
            case "int16": {
                return Int16FieldType.INSTANCE;
            }
            case "int32": {
                return Int32FieldType.INSTANCE;
            }
            case "int64": {
                return Int64FieldType.INSTANCE;
            }
            case "string": {
                return StringFieldType.INSTANCE;
            }
            case "bytes": {
                return BytesFieldType.INSTANCE;
            }
        }
        if (string.startsWith(STRUCT_PREFIX)) {
            String elementTypeString = string.substring(STRUCT_PREFIX.length());
            if (elementTypeString.length() == 0) {
                throw new RuntimeException("Can't parse array type " + string + ".  No element type found.");
            }
            FieldType elementType = FieldType.parse(elementTypeString);
            if (elementType.isArray()) {
                throw new RuntimeException("Can't have an array of arrays.  Use an array of structs containing an array instead.");
            }
            return new ArrayType(elementType);
        }
        if (MessageGenerator.firstIsCapitalized(string)) {
            return new StructType(string);
        }
        throw new RuntimeException("Can't parse type " + string);
    }

    default public boolean isArray() {
        return false;
    }

    default public boolean isStructArray() {
        return false;
    }

    default public boolean isString() {
        return false;
    }

    default public boolean isBytes() {
        return false;
    }

    default public boolean isStruct() {
        return false;
    }

    default public boolean canBeNullable() {
        return false;
    }

    default public Optional<Integer> fixedLength() {
        return Optional.empty();
    }

    public String toString();

    public static final class ArrayType
    implements FieldType {
        private final FieldType elementType;

        ArrayType(FieldType elementType) {
            this.elementType = elementType;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public boolean isStructArray() {
            return this.elementType.isStruct();
        }

        @Override
        public boolean canBeNullable() {
            return true;
        }

        public FieldType elementType() {
            return this.elementType;
        }

        @Override
        public String toString() {
            return FieldType.STRUCT_PREFIX + this.elementType.toString();
        }
    }

    public static final class StructType
    implements FieldType {
        private final String type;

        StructType(String type) {
            this.type = type;
        }

        @Override
        public boolean isStruct() {
            return true;
        }

        @Override
        public String toString() {
            return this.type;
        }
    }

    public static final class BytesFieldType
    implements FieldType {
        static final BytesFieldType INSTANCE = new BytesFieldType();
        private static final String NAME = "bytes";

        @Override
        public boolean isBytes() {
            return true;
        }

        @Override
        public boolean canBeNullable() {
            return true;
        }

        @Override
        public String toString() {
            return NAME;
        }
    }

    public static final class StringFieldType
    implements FieldType {
        static final StringFieldType INSTANCE = new StringFieldType();
        private static final String NAME = "string";

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public boolean canBeNullable() {
            return true;
        }

        @Override
        public String toString() {
            return NAME;
        }
    }

    public static final class Int64FieldType
    implements FieldType {
        static final Int64FieldType INSTANCE = new Int64FieldType();
        private static final String NAME = "int64";

        @Override
        public Optional<Integer> fixedLength() {
            return Optional.of(8);
        }

        @Override
        public String toString() {
            return NAME;
        }
    }

    public static final class Int32FieldType
    implements FieldType {
        static final Int32FieldType INSTANCE = new Int32FieldType();
        private static final String NAME = "int32";

        @Override
        public Optional<Integer> fixedLength() {
            return Optional.of(4);
        }

        @Override
        public String toString() {
            return NAME;
        }
    }

    public static final class Int16FieldType
    implements FieldType {
        static final Int16FieldType INSTANCE = new Int16FieldType();
        private static final String NAME = "int16";

        @Override
        public Optional<Integer> fixedLength() {
            return Optional.of(2);
        }

        @Override
        public String toString() {
            return NAME;
        }
    }

    public static final class Int8FieldType
    implements FieldType {
        static final Int8FieldType INSTANCE = new Int8FieldType();
        private static final String NAME = "int8";

        @Override
        public Optional<Integer> fixedLength() {
            return Optional.of(1);
        }

        @Override
        public String toString() {
            return NAME;
        }
    }

    public static final class BoolFieldType
    implements FieldType {
        static final BoolFieldType INSTANCE = new BoolFieldType();
        private static final String NAME = "bool";

        @Override
        public Optional<Integer> fixedLength() {
            return Optional.of(1);
        }

        @Override
        public String toString() {
            return NAME;
        }
    }
}

