/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Locale;

public final class MessageGenerator {
    static final String JSON_SUFFIX = ".json";
    static final String JSON_GLOB = "*.json";
    static final String JAVA_SUFFIX = ".java";
    static final String API_MESSAGE_TYPE_JAVA = "ApiMessageType.java";
    static final String API_MESSAGE_CLASS = "org.apache.kafka.common.protocol.ApiMessage";
    static final String MESSAGE_CLASS = "org.apache.kafka.common.protocol.Message";
    static final String MESSAGE_UTIL_CLASS = "org.apache.kafka.common.protocol.MessageUtil";
    static final String READABLE_CLASS = "org.apache.kafka.common.protocol.Readable";
    static final String WRITABLE_CLASS = "org.apache.kafka.common.protocol.Writable";
    static final String ARRAYS_CLASS = "java.util.Arrays";
    static final String LIST_CLASS = "java.util.List";
    static final String ARRAYLIST_CLASS = "java.util.ArrayList";
    static final String IMPLICIT_LINKED_HASH_MULTI_COLLECTION_CLASS = "org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection";
    static final String UNSUPPORTED_VERSION_EXCEPTION_CLASS = "org.apache.kafka.common.errors.UnsupportedVersionException";
    static final String ITERATOR_CLASS = "java.util.Iterator";
    static final String TYPE_CLASS = "org.apache.kafka.common.protocol.types.Type";
    static final String FIELD_CLASS = "org.apache.kafka.common.protocol.types.Field";
    static final String SCHEMA_CLASS = "org.apache.kafka.common.protocol.types.Schema";
    static final String ARRAYOF_CLASS = "org.apache.kafka.common.protocol.types.ArrayOf";
    static final String STRUCT_CLASS = "org.apache.kafka.common.protocol.types.Struct";
    static final String BYTES_CLASS = "org.apache.kafka.common.utils.Bytes";
    static final String REQUEST_SUFFIX = "Request";
    static final String RESPONSE_SUFFIX = "Response";
    static final ObjectMapper JSON_SERDE = new ObjectMapper();
    private static final String USAGE = "MessageGenerator: [output Java file] [input JSON file]";

    /*
     * Exception decompiling
     */
    public static void processDirectories(String outputDir, String inputDir) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static String capitalizeFirst(String string) {
        if (string.isEmpty()) {
            return string;
        }
        return string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    static String lowerCaseFirst(String string) {
        if (string.isEmpty()) {
            return string;
        }
        return string.substring(0, 1).toLowerCase(Locale.ENGLISH) + string.substring(1);
    }

    static boolean firstIsCapitalized(String string) {
        if (string.isEmpty()) {
            return false;
        }
        return Character.isUpperCase(string.charAt(0));
    }

    static String toSnakeCase(String string) {
        StringBuilder bld = new StringBuilder();
        boolean prevWasCapitalized = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!prevWasCapitalized) {
                    bld.append('_');
                }
                bld.append(Character.toLowerCase(c));
                prevWasCapitalized = true;
                continue;
            }
            bld.append(c);
            prevWasCapitalized = false;
        }
        return bld.toString();
    }

    static String stripSuffix(String str, String suffix) {
        if (str.endsWith(suffix)) {
            return str.substring(0, str.length() - suffix.length());
        }
        throw new RuntimeException("String " + str + " does not end with the expected suffix " + suffix);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println(USAGE);
            System.exit(0);
        } else if (args.length != 2) {
            System.out.println(USAGE);
            System.exit(1);
        }
        MessageGenerator.processDirectories(args[0], args[1]);
    }

    static {
        JSON_SERDE.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        JSON_SERDE.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        JSON_SERDE.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        JSON_SERDE.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }
}

