/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.message.FieldSpec;
import org.apache.kafka.message.MessageSpecType;
import org.apache.kafka.message.StructSpec;

public final class MessageSpec {
    private final StructSpec struct;
    private final Optional<Short> apiKey;
    private final MessageSpecType type;

    @JsonCreator
    public MessageSpec(@JsonProperty(value="name") String name, @JsonProperty(value="validVersions") String validVersions, @JsonProperty(value="fields") List<FieldSpec> fields, @JsonProperty(value="apiKey") Short apiKey, @JsonProperty(value="type") MessageSpecType type) {
        this.struct = new StructSpec(name, validVersions, fields);
        this.apiKey = apiKey == null ? Optional.empty() : Optional.of(apiKey);
        this.type = Objects.requireNonNull(type);
    }

    public StructSpec struct() {
        return this.struct;
    }

    @JsonProperty(value="name")
    public String name() {
        return this.struct.name();
    }

    @JsonProperty(value="validVersions")
    public String validVersionsString() {
        return this.struct.versionsString();
    }

    @JsonProperty(value="fields")
    public List<FieldSpec> fields() {
        return this.struct.fields();
    }

    @JsonProperty(value="apiKey")
    public Optional<Short> apiKey() {
        return this.apiKey;
    }

    @JsonProperty(value="type")
    public MessageSpecType type() {
        return this.type;
    }

    public String generatedClassName() {
        return this.struct.name() + "Data";
    }
}

