/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.message.FieldSpec;
import org.apache.kafka.message.Versions;

public final class StructSpec {
    private final String name;
    private final Versions versions;
    private final List<FieldSpec> fields;
    private final boolean hasKeys;

    @JsonCreator
    public StructSpec(@JsonProperty(value="name") String name, @JsonProperty(value="versions") String versions, @JsonProperty(value="fields") List<FieldSpec> fields) {
        this.name = Objects.requireNonNull(name);
        this.versions = Versions.parse(versions, null);
        if (this.versions == null) {
            throw new RuntimeException("You must specify the version of the " + name + " structure.");
        }
        this.fields = Collections.unmodifiableList(fields == null ? Collections.emptyList() : new ArrayList<FieldSpec>(fields));
        this.hasKeys = this.fields.stream().anyMatch(f -> f.mapKey());
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    public Versions versions() {
        return this.versions;
    }

    @JsonProperty
    public String versionsString() {
        return this.versions.toString();
    }

    @JsonProperty
    public List<FieldSpec> fields() {
        return this.fields;
    }

    boolean hasKeys() {
        return this.hasKeys;
    }
}

