/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import java.util.Objects;

public final class Versions {
    private final short lowest;
    private final short highest;
    public static final Versions ALL = new Versions(0, Short.MAX_VALUE);
    public static final Versions NONE = new Versions();
    public static final String NONE_STRING = "none";

    public static Versions parse(String input, Versions defaultVersions) {
        if (input == null) {
            return defaultVersions;
        }
        String trimmedInput = input.trim();
        if (trimmedInput.length() == 0) {
            return defaultVersions;
        }
        if (trimmedInput.equals(NONE_STRING)) {
            return NONE;
        }
        if (trimmedInput.endsWith("+")) {
            return new Versions(Short.parseShort(trimmedInput.substring(0, trimmedInput.length() - 1)), Short.MAX_VALUE);
        }
        int dashIndex = trimmedInput.indexOf("-");
        if (dashIndex < 0) {
            short version = Short.parseShort(trimmedInput);
            return new Versions(version, version);
        }
        return new Versions(Short.parseShort(trimmedInput.substring(0, dashIndex)), Short.parseShort(trimmedInput.substring(dashIndex + 1)));
    }

    private Versions() {
        this.lowest = 0;
        this.highest = (short)-1;
    }

    public Versions(short lowest, short highest) {
        if (lowest < 0 || highest < 0) {
            throw new RuntimeException("Invalid version range " + lowest + " to " + highest);
        }
        this.lowest = lowest;
        this.highest = highest;
    }

    public short lowest() {
        return this.lowest;
    }

    public short highest() {
        return this.highest;
    }

    public boolean empty() {
        return this.lowest > this.highest;
    }

    public String toString() {
        if (this.empty()) {
            return NONE_STRING;
        }
        if (this.lowest == this.highest) {
            return String.valueOf(this.lowest);
        }
        if (this.highest == Short.MAX_VALUE) {
            return String.format("%d+", this.lowest);
        }
        return String.format("%d-%d", this.lowest, this.highest);
    }

    public Versions intersect(Versions other) {
        short newHighest;
        short newLowest = this.lowest > other.lowest ? this.lowest : other.lowest;
        short s = newHighest = this.highest < other.highest ? this.highest : other.highest;
        if (newLowest > newHighest) {
            return NONE;
        }
        return new Versions(newLowest, newHighest);
    }

    public boolean contains(short version) {
        return version >= this.lowest && version <= this.highest;
    }

    public boolean contains(Versions other) {
        if (other.empty()) {
            return true;
        }
        return this.lowest <= other.lowest && this.highest >= other.highest;
    }

    public int hashCode() {
        return Objects.hash(this.lowest, this.highest);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Versions)) {
            return false;
        }
        Versions otherVersions = (Versions)other;
        return this.lowest == otherVersions.lowest && this.highest == otherVersions.highest;
    }
}

