/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.packets.TypesWriter;
import java.io.IOException;

public class PacketUserauthRequestPublicKey {
    byte[] payload;
    String userName;
    String serviceName;
    String password;
    byte[] blob;
    byte[] sig;
    boolean haveSig;

    public PacketUserauthRequestPublicKey(String serviceName, String user, byte[] blob, byte[] sig) {
        this.serviceName = serviceName;
        this.userName = user;
        this.blob = blob;
        this.haveSig = true;
        this.sig = sig;
    }

    public PacketUserauthRequestPublicKey(String serviceName, String user, byte[] blob) {
        this.serviceName = serviceName;
        this.userName = user;
        this.blob = blob;
        this.haveSig = false;
    }

    public PacketUserauthRequestPublicKey(byte[] payload, int off, int len) throws IOException {
        this.payload = new byte[len];
        System.arraycopy(payload, off, this.payload, 0, len);
        TypesReader tr = new TypesReader(payload, off, len);
        int packet_type = tr.readByte();
        if (packet_type != 50) {
            throw new IOException("This is not a SSH_MSG_USERAUTH_REQUEST! (" + packet_type + ")");
        }
        throw new IOException("Not implemented!");
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            TypesWriter tw = new TypesWriter();
            tw.writeByte(50);
            tw.writeString(this.userName);
            tw.writeString(this.serviceName);
            tw.writeString("publickey");
            tw.writeBoolean(this.haveSig);
            tw.writeBytes(this.blob);
            if (this.haveSig) {
                tw.writeString(this.sig, 0, this.sig.length);
            }
            this.payload = tw.getBytes();
        }
        return this.payload;
    }
}

