/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.connectors;

import es.bsc.compss.connectors.AbstractConnector;
import es.bsc.compss.connectors.ConnectorException;
import es.bsc.compss.connectors.conn.util.ConnectorProxy;
import es.bsc.compss.connectors.conn.util.Converter;
import es.bsc.compss.types.CloudProvider;
import es.bsc.compss.types.resources.description.CloudImageDescription;
import es.bsc.compss.types.resources.description.CloudMethodResourceDescription;
import es.bsc.compss.util.Classpath;
import es.bsc.conn.Connector;
import es.bsc.conn.types.HardwareDescription;
import es.bsc.conn.types.SoftwareDescription;
import es.bsc.conn.types.VirtualResource;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultNoSSHConnector
extends AbstractConnector {
    private static final String CONNECTORS_REL_PATH = File.separator + "Runtime" + File.separator + "cloud-conn" + File.separator;
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Connectors");
    private static final String WARN_NO_COMPSS_HOME = "WARN: COMPSS_HOME not defined, no default connectors loaded";
    private static final float UNASSIGNED_FLOAT = -1.0f;
    private ConnectorProxy connectorProxy;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DefaultNoSSHConnector(CloudProvider provider, String connectorJarPath, String connectorMainClass, Map<String, String> connectorProperties) throws ConnectorException {
        Connector conn;
        block11: {
            super(provider, connectorProperties);
            LOGGER.info("Creating DefaultNoSSHConnector");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  Detected " + connectorProperties.size() + " Connector properties");
                for (Map.Entry<String, String> prop : connectorProperties.entrySet()) {
                    LOGGER.debug("   > ConnectorProperty: " + prop.getKey() + " - " + prop.getValue());
                }
            }
            conn = null;
            LOGGER.debug(" - Loading " + connectorJarPath);
            try {
                String jarPath = connectorJarPath;
                if (!connectorJarPath.startsWith(File.separator)) {
                    String compssHome = System.getenv("COMPSS_HOME");
                    if (compssHome == null || compssHome.isEmpty()) {
                        LOGGER.warn(WARN_NO_COMPSS_HOME);
                        return;
                    }
                    jarPath = compssHome + CONNECTORS_REL_PATH + connectorJarPath;
                }
                LOGGER.debug(" - Loading from : " + jarPath);
                Classpath.loadJarsInPath((String)jarPath, (Logger)LOGGER);
                LOGGER.debug(" - Using connector " + connectorMainClass);
                Class<?> conClass = Class.forName(connectorMainClass);
                Constructor<?> constructor = conClass.getDeclaredConstructors()[0];
                conn = (Connector)constructor.newInstance(connectorProperties);
                LOGGER.debug("Ending connector handling");
                if (conn != null) break block11;
            }
            catch (Exception e) {
                LOGGER.error("Exception creating connector", (Throwable)e);
                throw new ConnectorException(e);
            }
            LOGGER.fatal("Connector constructor null");
        }
        this.connectorProxy = new ConnectorProxy(conn);
        return;
        finally {
            if (conn == null) {
                LOGGER.fatal("Connector constructor null");
            }
            this.connectorProxy = new ConnectorProxy(conn);
        }
    }

    public boolean isAutomaticScalingEnabled() {
        return this.connectorProxy.isAutomaticScalingEnabled();
    }

    public void destroy(Object id) throws ConnectorException {
        LOGGER.debug("Destroy connectorProxy with id " + id);
        this.connectorProxy.destroy(id);
    }

    public Object create(String name, CloudMethodResourceDescription cmrd) throws ConnectorException {
        LOGGER.debug("Create connectorProxy " + name);
        HardwareDescription hd = Converter.getHardwareDescription((CloudMethodResourceDescription)cmrd);
        SoftwareDescription sd = Converter.getSoftwareDescription((CloudMethodResourceDescription)cmrd);
        return this.connectorProxy.create(name, hd, sd, cmrd.getImage().getProperties());
    }

    public CloudMethodResourceDescription waitUntilCreation(Object id, CloudMethodResourceDescription requested) throws ConnectorException {
        LOGGER.debug("Waiting connectorProxy with id " + id);
        VirtualResource vr = this.connectorProxy.waitUntilCreation(id);
        CloudMethodResourceDescription cmrd = Converter.toCloudMethodResourceDescription((VirtualResource)vr, (CloudMethodResourceDescription)requested);
        LOGGER.debug("Return cloud method resource description " + cmrd.toString());
        return cmrd;
    }

    public float getMachineCostPerTimeSlot(CloudMethodResourceDescription cmrd) {
        return this.connectorProxy.getPriceSlot(Converter.getVirtualResource((Object)"-1", (CloudMethodResourceDescription)cmrd), -1.0f);
    }

    public long getTimeSlot() {
        return this.connectorProxy.getTimeSlot(120000L);
    }

    protected void close() {
        LOGGER.debug("Close connector");
        this.connectorProxy.close();
    }

    public void configureAccess(String ip, String user, String password) throws ConnectorException {
    }

    public void prepareMachine(String ip, CloudImageDescription cid) throws ConnectorException {
    }
}

