/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types;

import org.json.JSONException;
import org.json.JSONObject;

public class Profile {
    protected static final long DEFAULT_EXECUTION_TIME = 100L;
    private long submitTS;
    private long arrivalTS;
    private long fetchedDataTS;
    private long executionStartTS;
    private long executionEndTS;
    private long endNotificationTS;
    private long endTS;
    private long executions;
    private long minTime;
    private long averageTime;
    private long maxTime;

    public Profile() {
        this.executions = 0L;
        this.minTime = Long.MAX_VALUE;
        this.averageTime = 100L;
        this.maxTime = Long.MIN_VALUE;
    }

    public Profile(Profile p) {
        this.executions = p.executions;
        this.minTime = p.minTime;
        this.averageTime = p.averageTime;
        this.maxTime = p.maxTime;
    }

    public Profile(JSONObject json) {
        if (json != null) {
            try {
                this.executions = json.getLong("executions");
            }
            catch (JSONException je) {
                this.executions = 0L;
            }
            try {
                this.minTime = json.getLong("minTime");
            }
            catch (JSONException je) {
                this.minTime = Long.MAX_VALUE;
            }
            try {
                this.averageTime = json.getLong("avgTime");
            }
            catch (JSONException je) {
                this.averageTime = 100L;
            }
            try {
                this.maxTime = json.getLong("maxTime");
            }
            catch (JSONException je) {
                this.maxTime = Long.MIN_VALUE;
            }
        } else {
            this.executions = 0L;
            this.minTime = Long.MAX_VALUE;
            this.averageTime = 100L;
            this.maxTime = Long.MIN_VALUE;
        }
    }

    public final void setSubmissionTime(long ts) {
        this.submitTS = ts;
    }

    public final void setArrivalTime(long ts) {
        this.arrivalTS = ts;
    }

    public final void setDataFetchingTime(long ts) {
        this.fetchedDataTS = ts;
    }

    public final void setExecutionStartTime(long ts) {
        this.executionStartTS = ts;
    }

    public final void setExecutionEndTime(long ts) {
        this.executionEndTS = ts;
    }

    public final void setEndNotificationTime(long ts) {
        this.endNotificationTS = ts;
    }

    public void end(long ts) {
        this.executions = 1L;
        this.endTS = ts;
        this.minTime = this.averageTime = this.endTS - this.submitTS;
        this.maxTime = this.averageTime;
    }

    public long getExecutionCount() {
        return this.executions;
    }

    public long getStartTime() {
        return this.submitTS;
    }

    public long getMinExecutionTime() {
        return this.minTime;
    }

    public long getAverageExecutionTime() {
        return this.averageTime;
    }

    public long getMaxExecutionTime() {
        return this.maxTime;
    }

    public void clearExecutionCount() {
        this.executions = 0L;
    }

    public void setExecutions(long executions) {
        this.executions = executions;
    }

    public void setMinTime(long minTime) {
        this.minTime = minTime;
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
    }

    public void setAvgTime(long averageTime) {
        this.averageTime = averageTime;
    }

    public <P extends Profile> void accumulate(P p) {
        P profile = p;
        long totalExecutions = this.executions + profile.executions;
        if (totalExecutions > 0L) {
            if (this.executions == 0L) {
                this.minTime = profile.minTime;
                this.maxTime = profile.maxTime;
            } else {
                this.minTime = Math.min(this.minTime, profile.minTime);
                this.maxTime = Math.max(this.maxTime, profile.maxTime);
            }
            this.averageTime = (profile.averageTime * profile.executions + this.executions * this.averageTime) / totalExecutions;
            this.executions = totalExecutions;
        }
    }

    public JSONObject toJSONObject() {
        JSONObject jo = new JSONObject();
        jo.put("executions", this.executions);
        jo.put("minTime", this.minTime);
        jo.put("avgTime", this.averageTime);
        jo.put("maxTime", this.maxTime);
        return jo;
    }

    public JSONObject updateJSON(JSONObject jo) {
        long oldExecutions = 0L;
        if (jo.has("executions")) {
            oldExecutions = jo.getLong("executions");
        }
        long oldAvg = 0L;
        if (jo.has("avgTime")) {
            oldAvg = jo.getLong("avgTime");
        }
        jo.put("executions", this.executions);
        jo.put("minTime", this.minTime);
        jo.put("avgTime", this.averageTime);
        jo.put("maxTime", this.maxTime);
        JSONObject difference = new JSONObject();
        difference.put("executions", this.executions - oldExecutions);
        difference.put("minTime", this.minTime);
        difference.put("avgTime", this.averageTime);
        long oldTime = oldAvg * oldExecutions;
        long newTime = this.averageTime * this.executions;
        long newExecutions = this.executions - oldExecutions;
        if (newExecutions > 0L) {
            difference.put("avgTime", (newTime - oldTime) / newExecutions);
        } else {
            difference.put("avgTime", 0);
        }
        return difference;
    }

    public void accumulateJSON(JSONObject jo) {
        long oldExecutions = 0L;
        long oldMin = Long.MAX_VALUE;
        long oldMax = Long.MIN_VALUE;
        long oldAvg = 0L;
        if (jo.has("executions")) {
            oldExecutions = jo.getLong("executions");
        }
        if (jo.has("minTime")) {
            oldMin = jo.getLong("minTime");
        }
        if (jo.has("maxTime")) {
            oldMax = jo.getLong("maxTime");
        }
        if (jo.has("avgTime")) {
            oldAvg = jo.getLong("avgTime");
        }
        jo.put("executions", this.executions + oldExecutions);
        if (this.executions > 0L) {
            jo.put("minTime", Math.min(this.minTime, oldMin));
            jo.put("maxTime", Math.max(this.maxTime, oldMax));
            jo.put("avgTime", (oldAvg * oldExecutions + this.averageTime * this.executions) / (this.executions + oldExecutions));
        }
    }

    public Profile copy() {
        return new Profile(this);
    }

    protected String getContent() {
        return "executions=" + this.executions + " minTime=" + this.minTime + " avgTime=" + this.averageTime + " maxTime=" + this.maxTime;
    }

    public String toString() {
        return "[Profile " + this.getContent() + "]";
    }
}

