/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.DataParams;
import es.bsc.compss.types.data.DataVersion;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;

public abstract class DataInfo<T extends DataParams> {
    private static final int FIRST_FILE_ID = 1;
    private static final int FIRST_VERSION_ID = 1;
    protected static int nextDataId = 1;
    protected final int dataId = nextDataId++;
    protected final T params;
    protected DataVersion currentVersion;
    protected int currentVersionId;
    protected TreeMap<Integer, DataVersion> versions;
    protected int deletionBlocks;
    protected final LinkedList<DataVersion> pendingDeletions;
    protected final LinkedList<Integer> canceledVersions;
    protected boolean deleted;

    public DataInfo(T data) {
        this.params = data;
        this.versions = new TreeMap();
        this.currentVersionId = 1;
        this.currentVersion = new DataVersion(this.dataId, 1, null);
        this.versions.put(this.currentVersionId, this.currentVersion);
        this.deletionBlocks = 0;
        this.pendingDeletions = new LinkedList();
        this.canceledVersions = new LinkedList();
        this.deleted = false;
        ((DataParams)this.params).getApp().addData(this);
    }

    public void deleted(DataInfoProvider dip) {
        ((DataParams)this.params).getApp().removeData(this);
    }

    public final int getDataId() {
        return this.dataId;
    }

    public T getParams() {
        return this.params;
    }

    public Application getGeneratingAppId() {
        return ((DataParams)this.params).getApp();
    }

    public final int getCurrentVersionId() {
        return this.currentVersionId;
    }

    public final DataVersion getCurrentDataVersion() {
        return this.currentVersion;
    }

    public final DataVersion getPreviousDataVersion() {
        return this.versions.get(this.currentVersionId - 1);
    }

    public final void willBeRead() {
        this.currentVersion.versionUsed();
        this.currentVersion.willBeRead();
    }

    public final boolean isToBeRead() {
        return this.currentVersion.hasPendingLectures();
    }

    public final boolean hasBeenCanceled() {
        return this.currentVersion.hasBeenUsed();
    }

    public final boolean versionHasBeenRead(int versionId) {
        DataVersion readVersion = this.versions.get(versionId);
        if (readVersion.hasBeenRead()) {
            Comm.removeData(readVersion.getDataInstanceId().getRenaming(), true);
            this.versions.remove(versionId);
            return this.versions.isEmpty();
        }
        return false;
    }

    public void willBeWritten() {
        ++this.currentVersionId;
        DataVersion validPred = this.currentVersion;
        if (validPred.hasBeenCancelled()) {
            validPred = validPred.getPreviousValidPredecessor();
        }
        DataVersion newVersion = new DataVersion(this.dataId, this.currentVersionId, validPred);
        newVersion.willBeWritten();
        this.versions.put(this.currentVersionId, newVersion);
        this.currentVersion = newVersion;
        this.currentVersion.versionUsed();
    }

    public final boolean versionHasBeenWritten(int versionId) {
        DataVersion writtenVersion = this.versions.get(versionId);
        if (writtenVersion.hasBeenWritten()) {
            Comm.removeData(writtenVersion.getDataInstanceId().getRenaming(), true);
            this.versions.remove(versionId);
            return this.versions.isEmpty();
        }
        return false;
    }

    public final void blockDeletions() {
        ++this.deletionBlocks;
    }

    public final boolean unblockDeletions() {
        --this.deletionBlocks;
        if (this.deletionBlocks == 0) {
            for (DataVersion version : this.pendingDeletions) {
                if (!version.markToDelete()) continue;
                Comm.removeData(version.getDataInstanceId().getRenaming(), true);
                this.versions.remove(version.getDataInstanceId().getVersionId());
            }
            if (this.versions.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public boolean delete(boolean noReuse) {
        this.deleted = true;
        if (this.deletionBlocks > 0) {
            this.pendingDeletions.addAll(this.versions.values());
        } else {
            LinkedList<Integer> removedVersions = new LinkedList<Integer>();
            for (DataVersion version : this.versions.values()) {
                String sourceName = version.getDataInstanceId().getRenaming();
                if (!version.markToDelete()) continue;
                Comm.removeData(sourceName, noReuse);
                removedVersions.add(version.getDataInstanceId().getVersionId());
            }
            Iterator<DataVersion> iterator = removedVersions.iterator();
            while (iterator.hasNext()) {
                int versionId = (Integer)((Object)iterator.next());
                this.versions.remove(versionId);
            }
            if (this.versions.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public abstract int waitForDataReadyToDelete(Semaphore var1);

    public final boolean isCurrentVersionToDelete() {
        return this.currentVersion.isToDelete();
    }

    public final DataVersion getFirstVersion() {
        return this.versions.get(1);
    }

    public final void tryRemoveVersion(Integer versionId) {
        DataVersion readVersion = this.versions.get(versionId);
        if (readVersion != null && readVersion.markToDelete()) {
            Comm.removeData(readVersion.getDataInstanceId().getRenaming(), true);
            this.versions.remove(versionId);
        }
    }

    public final boolean canceledReadVersion(Integer versionId) {
        DataVersion readVersion = this.versions.get(versionId);
        if (!this.deleted && readVersion.isToDelete() && readVersion.hasBeenUsed()) {
            readVersion.unmarkToDelete();
        }
        if (readVersion.hasBeenRead()) {
            Comm.removeData(readVersion.getDataInstanceId().getRenaming(), true);
            this.versions.remove(versionId);
            return this.versions.isEmpty();
        }
        return false;
    }

    public final boolean canceledWriteVersion(Integer versionId) {
        DataVersion version = this.versions.get(versionId);
        version.versionCancelled();
        this.canceledVersions.add(versionId);
        if (versionId == this.currentVersionId) {
            Integer lastVersion = this.currentVersionId;
            while (this.canceledVersions.contains(lastVersion)) {
                this.tryRemoveVersion(lastVersion);
                lastVersion = lastVersion - 1;
            }
            if (lastVersion > 1) {
                this.currentVersionId = lastVersion;
                this.currentVersion = this.versions.get(this.currentVersionId);
                return false;
            }
            if (lastVersion == 1) {
                DataVersion firstVersion = this.getFirstVersion();
                if (firstVersion != null && firstVersion.hasBeenUsed()) {
                    this.currentVersionId = lastVersion;
                    this.currentVersion = firstVersion;
                    return false;
                }
                return true;
            }
            return true;
        }
        return false;
    }
}

