/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataParams;
import es.bsc.compss.types.data.DataVersion;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.listener.SafeCopyListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.LocationType;
import es.bsc.compss.types.data.operation.copy.Copy;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.FileOpsManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileInfo
extends DataInfo<DataParams.FileData> {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");

    public FileInfo(DataParams.FileData file) {
        super(file);
    }

    public DataLocation getOriginalLocation() {
        return ((DataParams.FileData)this.getParams()).getLocation();
    }

    @Override
    public int waitForDataReadyToDelete(Semaphore semWait) {
        int nPermits = 1;
        LOGGER.debug("[FileInfo] Deleting file of data " + this.getDataId());
        DataVersion firstVersion = this.getFirstVersion();
        if (firstVersion != null) {
            LogicalData ld = firstVersion.getDataInstanceId().getData();
            if (ld != null) {
                for (DataLocation loc : ld.getLocations()) {
                    MultiURI uri = loc.getURIInHost(Comm.getAppHost());
                    if (uri == null || !loc.equals(this.getOriginalLocation())) continue;
                    if (loc.getType() != LocationType.SHARED) {
                        nPermits = this.waitForEndingCopies(ld, loc, semWait);
                    } else if (!firstVersion.addSemaphore(semWait)) {
                        LOGGER.debug("[FileInfo] Readers for first version of " + this.getDataId() + " finished. Nothing to do. Releasing semaphore.");
                        semWait.release();
                    }
                    return nPermits;
                }
                LOGGER.debug("[FileInfo] No location in " + this.getDataId() + " equal to original. Nothing to do. Releasing semaphore.");
                semWait.release();
            }
        } else {
            LOGGER.debug("[FileInfo] First version of data " + this.getDataId() + " is null. Nothing to do. Releasing semaphore.");
            semWait.release();
        }
        return nPermits;
    }

    @Override
    public boolean delete(boolean noReuse) {
        LOGGER.debug("[FileInfo] Deleting file of data " + this.getDataId());
        if (!noReuse) {
            DataVersion firstVersion = this.getFirstVersion();
            if (firstVersion != null) {
                LogicalData ld = firstVersion.getDataInstanceId().getData();
                if (ld != null) {
                    for (DataLocation loc : ld.getLocations()) {
                        MultiURI uri = loc.getURIInHost(Comm.getAppHost());
                        if (uri == null || !uri.getPath().equals(this.getOriginalLocation().getURIInHost(Comm.getAppHost()).getPath())) continue;
                        String newPath = Comm.getAppHost().getWorkingDirectory() + File.separator + firstVersion.getDataInstanceId().getRenaming();
                        LOGGER.debug("[FileInfo] Modifying path in location " + loc + " with new path " + newPath);
                        loc.modifyPath(newPath);
                        try {
                            LOGGER.debug("[FileInfo] Moving " + uri.getPath() + " to " + newPath);
                            FileOpsManager.moveSync(new File(uri.getPath()), new File(newPath));
                        }
                        catch (IOException e) {
                            ErrorManager.warn("File " + uri.getPath() + " cannot be moved to " + newPath + "Reason: " + e.getMessage());
                        }
                    }
                }
            } else {
                LOGGER.debug("[FileInfo] First Version is null. Nothing to delete");
            }
        }
        return super.delete(noReuse);
    }

    private int waitForEndingCopies(LogicalData ld, DataLocation loc, Semaphore semWait) {
        Collection<Copy> copiesInProgress = ld.getCopiesInProgress();
        int nPermits = 1;
        if (copiesInProgress != null && !copiesInProgress.isEmpty()) {
            nPermits = copiesInProgress.size();
            for (Copy copy : copiesInProgress) {
                if (!copy.getSourceData().equals(ld)) continue;
                LOGGER.debug("[FileInfo] Waiting for copy of data " + ld.getName() + " to finish...");
                SafeCopyListener currentCopylistener = new SafeCopyListener(semWait);
                copy.addEventListener(currentCopylistener);
                currentCopylistener.addOperation();
                currentCopylistener.enable();
            }
        } else {
            semWait.release();
        }
        return nPermits;
    }
}

