/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.access;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.DataParams;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.access.MainAccess;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessparams.FileAccessParams;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.operation.FileTransferable;
import es.bsc.compss.types.data.operation.OneOpWithSemListener;
import es.bsc.compss.types.uri.SimpleURI;
import java.util.concurrent.Semaphore;

public class FileMainAccess<D extends DataParams.FileData, P extends FileAccessParams<D>>
extends MainAccess<DataLocation, D, P> {
    public static FileMainAccess<DataParams.FileData, FileAccessParams<DataParams.FileData>> constructFMA(Application app, Direction dir, DataLocation loc) {
        FileAccessParams f = FileAccessParams.constructFAP(app, dir, loc);
        return new FileMainAccess<DataParams.FileData, FileAccessParams<DataParams.FileData>>(f);
    }

    protected FileMainAccess(P params) {
        super(params);
    }

    @Override
    public DataLocation getUnavailableValueResponse() {
        return this.createExpectedLocalLocation("null");
    }

    @Override
    public final DataLocation fetch(DataAccessId daId) {
        DataInstanceId tgtDiId;
        if (daId.isWrite()) {
            DataAccessId.WritingDataAccessId wdaId = (DataAccessId.WritingDataAccessId)daId;
            tgtDiId = wdaId.getWrittenDataInstance();
        } else {
            RAccessId rdaId = (RAccessId)daId;
            tgtDiId = rdaId.getReadDataInstance();
        }
        String targetName = tgtDiId.getRenaming();
        String dataDesc = ((FileAccessParams)this.getParameters()).getDataDescription();
        LOGGER.debug("Openning file " + targetName);
        DataLocation tgtLocation = ((FileAccessParams)this.getParameters()).getLocation();
        if (daId.isRead()) {
            String pscoId = tgtDiId.getData().getPscoId();
            tgtLocation = pscoId != null ? this.fetchPSCO(pscoId, targetName) : this.fetchData(daId, targetName);
        }
        if (daId.isWrite()) {
            LOGGER.debug("Access to " + dataDesc + " mode contains W, register new writer");
            String targetPath = Comm.getAppHost().getWorkingDirectory() + targetName;
            tgtLocation = this.createExpectedLocalLocation(targetPath);
            Comm.registerLocation(targetName, tgtLocation);
        }
        if (DEBUG) {
            LOGGER.debug(dataDesc + " located on " + (tgtLocation != null ? tgtLocation.toString() : "null"));
        }
        return tgtLocation;
    }

    private DataLocation fetchPSCO(String pscoId, String targetName) {
        LOGGER.debug("Auto-release");
        DataLocation targetLocation = this.createPSCOLocation(pscoId);
        Comm.registerLocation(targetName, targetLocation);
        LOGGER.debug("Setting target location to " + targetLocation);
        return targetLocation;
    }

    private DataLocation createPSCOLocation(String pscoId) {
        SimpleURI targetURI = new SimpleURI(ProtocolType.PERSISTENT_URI.getSchema() + pscoId);
        return FileMainAccess.createLocalLocation(targetURI);
    }

    protected DataLocation fetchData(DataAccessId daId, String targetName) {
        LogicalData tgtData;
        FileTransferable ft;
        LOGGER.debug("Asking for transfer");
        DataAccessId.ReadingDataAccessId rdaId = (DataAccessId.ReadingDataAccessId)daId;
        LogicalData srcData = rdaId.getReadDataInstance().getData();
        Semaphore sem = new Semaphore(0);
        if (rdaId.isWrite()) {
            ft = this.createExpectedTransferable(daId.isPreserveSourceData());
            tgtData = null;
        } else {
            ft = this.createExpectedTransferable(true);
            tgtData = srcData;
        }
        OneOpWithSemListener listener = new OneOpWithSemListener(sem);
        Comm.getAppHost().getData(srcData, targetName, tgtData, (Transferable)ft, (EventListener)listener);
        sem.acquireUninterruptibly();
        String finalPath = ft.getDataTarget();
        return this.createExpectedLocalLocation(finalPath);
    }

    protected final DataLocation createExpectedLocalLocation(String localPath) {
        SimpleURI targetURI = new SimpleURI(this.expectedProtocol().getSchema() + localPath);
        return FileMainAccess.createLocalLocation(targetURI);
    }

    protected FileTransferable createExpectedTransferable(boolean preserveSource) {
        return new FileTransferable(preserveSource);
    }

    protected ProtocolType expectedProtocol() {
        return ProtocolType.FILE_URI;
    }

    @Override
    public boolean isAccessFinishedOnRegistration() {
        return false;
    }
}

