/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessparams;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.DataParams;
import es.bsc.compss.types.data.DataVersion;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.accessparams.ObjectAccessParams;

public class BindingObjectAccessParams
extends ObjectAccessParams<BindingObject, DataParams.BindingObjectData> {
    private static final long serialVersionUID = 1L;

    public static final BindingObjectAccessParams constructBOAP(Application app, Direction dir, BindingObject bo, int hashCode) {
        return new BindingObjectAccessParams(app, dir, bo, hashCode);
    }

    private BindingObjectAccessParams(Application app, Direction dir, BindingObject bo, int hashCode) {
        super(new DataParams.BindingObjectData(app, hashCode), dir, bo);
    }

    public BindingObject getBindingObject() {
        return (BindingObject)this.getValue();
    }

    @Override
    public void registeredAsFirstVersionForData(DataInfo dInfo) {
        DataVersion dv = dInfo.getCurrentDataVersion();
        if (this.mode != AccessParams.AccessMode.W) {
            DataInstanceId lastDID = dv.getDataInstanceId();
            String renaming = lastDID.getRenaming();
            Comm.registerBindingObject(renaming, this.getBindingObject());
        } else {
            dv.invalidate();
        }
    }

    @Override
    public boolean resultRemainOnMain() {
        return false;
    }
}

