/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessparams;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.DataParams;
import es.bsc.compss.types.data.DataVersion;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;

public class FileAccessParams<D extends DataParams.FileData>
extends AccessParams<D> {
    private static final long serialVersionUID = 1L;

    public static final FileAccessParams constructFAP(Application app, Direction dir, DataLocation loc) {
        DataParams.FileData fd = new DataParams.FileData(app, loc);
        return new FileAccessParams<DataParams.FileData>(fd, dir);
    }

    protected FileAccessParams(D data, Direction dir) {
        super(data, dir);
    }

    public final DataLocation getLocation() {
        return ((DataParams.FileData)this.data).getLocation();
    }

    @Override
    public void checkAccessValidity(DataInfoProvider dip) throws ValueUnawareRuntimeException {
        boolean alreadyAccessed = dip.alreadyAccessed((DataParams)this.getData());
        if (!alreadyAccessed) {
            LOGGER.debug(this.getDataDescription() + " accessed before, returning the same location");
            throw new ValueUnawareRuntimeException();
        }
    }

    @Override
    public void registeredAsFirstVersionForData(DataInfo dInfo) {
        DataVersion dv = dInfo.getCurrentDataVersion();
        if (this.mode != AccessParams.AccessMode.W) {
            DataInstanceId lastDID = dv.getDataInstanceId();
            String renaming = lastDID.getRenaming();
            Comm.registerLocation(renaming, this.getLocation());
        } else {
            dv.invalidate();
        }
    }

    @Override
    public boolean resultRemainOnMain() {
        return false;
    }

    @Override
    public void externalRegister() {
    }

    public String toString() {
        return "[" + this.getApp() + ", " + (Object)((Object)this.mode) + " ," + this.getLocation() + "]";
    }
}

