/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.operation;

import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.operation.DataOperation;
import es.bsc.compss.util.ErrorManager;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OneOpWithSemListener
extends EventListener {
    private static final Logger logger = LogManager.getLogger("es.bsc.compss.Components.TaskDispatcher.FileTransferManager");
    private static final boolean debug = logger.isDebugEnabled();
    private Semaphore sem;

    public OneOpWithSemListener(Semaphore sem) {
        this.sem = sem;
    }

    @Override
    public void notifyEnd(DataOperation fOp) {
        this.sem.release();
    }

    @Override
    public void notifyFailure(DataOperation fOp, Exception e) {
        if (debug) {
            logger.error("THREAD " + Thread.currentThread().getName() + " File Operation failed" + (fOp != null ? " on " + fOp.getName() : "") + ", file role is OPEN_FILE, operation end state is FAILED", (Throwable)e);
        } else {
            logger.error("THREAD " + Thread.currentThread().getName() + " File Operation failed" + (fOp != null ? " on " + fOp.getName() : "") + ", file role is OPEN_FILE, operation end state is FAILED");
        }
        ErrorManager.warn("Open file tranfer " + (fOp != null ? " for " + fOp.getName() : "") + " failed. Check runtime.log for more details.");
        this.sem.release();
    }
}

