/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.data.DataParams;
import es.bsc.compss.types.data.FileInfo;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.util.FileOpsManager;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Semaphore;

public class DeleteFileRequest
extends APRequest {
    private final DataParams.FileData data;
    private final Semaphore sem;
    private boolean noReuse;
    private final boolean applicationDelete;

    public DeleteFileRequest(DataParams.FileData data, Semaphore sem, boolean noReuse, boolean applicationDelete) {
        this.data = data;
        this.sem = sem;
        this.noReuse = noReuse;
        this.applicationDelete = applicationDelete;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        LOGGER.info("[DeleteFileRequest] Notify data delete " + this.data.getDescription() + " to DIP...");
        FileInfo fileInfo = (FileInfo)dip.deleteData(this.data, this.noReuse);
        if (fileInfo == null) {
            String filePath = this.data.getLocation().getURIs().get(0).getPath();
            File f = new File(filePath);
            try {
                FileOpsManager.deleteSync(f);
                LOGGER.info("[DeleteFileRequest] File " + filePath + " deleted.");
            }
            catch (IOException e) {
                LOGGER.error("[DeleteFileRequest] Error on deleting file " + filePath, (Throwable)e);
            }
        } else {
            LOGGER.info("[DeleteFileRequest] Deleting Data in Task Analyser");
            ta.deleteData(fileInfo, this.applicationDelete);
        }
        this.sem.release();
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.DELETE_FILE;
    }
}

