/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataParams;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.exceptions.ShutdownException;
import es.bsc.compss.types.tracing.TraceEvent;

public class DeregisterObject
extends APRequest {
    private final DataParams.ObjectData data;

    public DeregisterObject(DataParams.ObjectData data) {
        this.data = data;
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.DEREGISTER_OBJECT;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) throws ShutdownException {
        DataInfo dInfo = dip.deleteData(this.data, true);
        if (dInfo == null) {
            LOGGER.info("Data " + this.data.getDescription() + " is not used by any task");
        } else {
            LOGGER.info("Data " + this.data.getDescription() + " deleted");
            ta.deleteData(dInfo, false);
        }
    }
}

