/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.data.DataParams;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.tracing.TraceEvent;
import java.util.concurrent.Semaphore;

public class WaitForDataReadyToDeleteRequest
extends APRequest {
    private final DataParams data;
    private final Semaphore sem;
    private final Semaphore semWait;
    private int nPermits;

    public WaitForDataReadyToDeleteRequest(DataParams data, Semaphore sem, Semaphore semWait) {
        this.data = data;
        this.sem = sem;
        this.semWait = semWait;
        this.nPermits = 0;
    }

    public int getNumPermits() {
        return this.nPermits;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        LOGGER.info("[WaitForDataReadyToDelete] Notifying waiting data " + this.data.getDescription() + "to DIP...");
        this.nPermits = dip.waitForDataReadyToDelete(this.data, this.semWait);
        this.sem.release();
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.DELETE_FILE;
    }
}

