/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.td;

import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.types.request.exceptions.ShutdownException;
import es.bsc.compss.types.request.td.TDRequest;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.worker.COMPSsException;

public class ActionUpdate
extends TDRequest {
    private final AllocatableAction action;
    private final Update update;
    private COMPSsException exception;

    public ActionUpdate(AllocatableAction action, Update update) {
        this.action = action;
        this.update = update;
        this.exception = null;
    }

    public void setCOMPSsException(COMPSsException e) {
        this.exception = e;
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.ACTION_UPDATE;
    }

    @Override
    public void process(TaskScheduler ts) throws ShutdownException {
        switch (this.update) {
            case RUNNING: {
                ts.actionRunning(this.action);
                break;
            }
            case COMPLETED: {
                ts.actionCompleted(this.action);
                break;
            }
            case ERROR: {
                ts.errorOnAction(this.action);
                break;
            }
            case EXCEPTION: {
                ts.exceptionOnAction(this.action, this.exception);
            }
        }
    }

    public static enum Update {
        RUNNING,
        ERROR,
        COMPLETED,
        EXCEPTION;

    }
}

