/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.CoreManager;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ActionSet {
    private final List<AllocatableAction> noCore;
    private List<AllocatableAction>[] coreIndexed;
    private int[] counts;
    private int totalActions;

    public ActionSet() {
        int coreCount = CoreManager.getCoreCount();
        this.noCore = new LinkedList<AllocatableAction>();
        this.coreIndexed = new LinkedList[coreCount];
        this.counts = new int[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            this.coreIndexed[coreId] = new LinkedList<AllocatableAction>();
            this.counts[coreId] = 0;
        }
        this.totalActions = 0;
    }

    public void updateCoreCount(int newCoreCount) {
        int oldCoreCount = this.coreIndexed.length;
        if (oldCoreCount < newCoreCount) {
            int coreId;
            LinkedList[] coreIndexed = new LinkedList[newCoreCount];
            int[] counts = new int[newCoreCount];
            for (coreId = 0; coreId < oldCoreCount; ++coreId) {
                coreIndexed[coreId] = this.coreIndexed[coreId];
                counts[coreId] = this.counts[coreId];
            }
            while (coreId < newCoreCount) {
                coreIndexed[coreId] = new LinkedList();
                counts[coreId] = 0;
                ++coreId;
            }
            this.coreIndexed = coreIndexed;
            this.counts = counts;
        }
    }

    public void addAction(AllocatableAction aa) {
        Integer core = aa.getCoreId();
        if (core == null) {
            this.noCore.add(aa);
        } else {
            if (core >= this.coreIndexed.length) {
                this.updateCoreCount(CoreManager.getCoreCount());
            }
            this.coreIndexed[core].add(aa);
            int n = core;
            this.counts[n] = this.counts[n] + 1;
        }
        ++this.totalActions;
    }

    public int getNumberTotalActions() {
        return this.totalActions;
    }

    public int[] getActionCounts() {
        return this.counts;
    }

    public List<AllocatableAction> getActions(Integer coreId) {
        if (coreId == null) {
            return this.noCore;
        }
        return this.coreIndexed[coreId];
    }

    public List<AllocatableAction> getAllActions() {
        LinkedList<AllocatableAction> runnable = new LinkedList<AllocatableAction>();
        runnable.addAll(this.noCore);
        for (int core = 0; core < this.coreIndexed.length; ++core) {
            runnable.addAll(this.coreIndexed[core]);
        }
        return runnable;
    }

    public void removeAction(AllocatableAction action) {
        Integer coreId = action.getCoreId();
        boolean removed = false;
        if (coreId == null) {
            removed = this.noCore.remove(action);
        } else if (coreId < this.coreIndexed.length) {
            removed = this.coreIndexed[coreId].remove(action);
            int n = coreId;
            this.counts[n] = this.counts[n] - 1;
        }
        if (removed) {
            --this.totalActions;
        }
    }

    public <T extends WorkerResourceDescription> List<AllocatableAction> removeAllCompatibleActions(Worker<T> r) {
        LinkedList<AllocatableAction> runnable = new LinkedList<AllocatableAction>();
        Iterator<AllocatableAction> actions = this.noCore.iterator();
        while (actions.hasNext()) {
            AllocatableAction action = actions.next();
            if (!action.isCompatible(r)) continue;
            actions.remove();
            --this.totalActions;
            runnable.add(action);
        }
        List<Integer> executableCores = r.getExecutableCores();
        for (int core : executableCores) {
            runnable.addAll(this.coreIndexed[core]);
            this.totalActions -= this.counts[core];
            this.coreIndexed[core] = new LinkedList<AllocatableAction>();
            this.counts[core] = 0;
        }
        return runnable;
    }

    public List<AllocatableAction> removeAllActions() {
        LinkedList<AllocatableAction> runnable = new LinkedList<AllocatableAction>();
        Iterator<AllocatableAction> actions = this.noCore.iterator();
        while (actions.hasNext()) {
            AllocatableAction action = actions.next();
            actions.remove();
            runnable.add(action);
        }
        for (int core = 0; core < this.coreIndexed.length; ++core) {
            runnable.addAll(this.coreIndexed[core]);
            this.coreIndexed[core] = new LinkedList<AllocatableAction>();
            this.counts[core] = 0;
        }
        this.totalActions = 0;
        return runnable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString() + "\n");
        sb.append("no Core (").append(this.noCore.size()).append(")-> ").append(this.noCore).append("\n");
        for (int coreId = 0; coreId < this.coreIndexed.length; ++coreId) {
            sb.append("Core ").append(coreId).append(" (").append(this.counts[coreId]).append(") -> ").append(this.coreIndexed[coreId]).append("\n");
        }
        return sb.toString();
    }
}

