/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.lookahead;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.lookahead.LookaheadRS;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.ObjectValue;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.ActionSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.json.JSONObject;

public abstract class LookaheadTS
extends TaskScheduler {
    protected final ActionSet unassignedReadyActions = new ActionSet();
    protected Set<AllocatableAction> upgradedActions = new HashSet<AllocatableAction>();
    private final AvailableWorkersSet availableWorkers = new AvailableWorkersSet();

    public <T extends WorkerResourceDescription> void workerLoadUpdate(ResourceScheduler<T> resource) {
        if (resource.canRunSomething()) {
            this.availableWorkers.addWorker(resource);
        }
    }

    protected <T extends WorkerResourceDescription> void workerDetected(ResourceScheduler<T> resource) {
        super.workerDetected(resource);
        if (resource.canRunSomething()) {
            this.availableWorkers.addWorker(resource);
        }
    }

    protected <T extends WorkerResourceDescription> void workerRemoved(ResourceScheduler<T> resource) {
        this.availableWorkers.removeWorker(resource);
        super.workerRemoved(resource);
    }

    public <T extends WorkerResourceDescription> void workerFeaturesUpdate(ResourceScheduler<T> worker, T modification, List<AllocatableAction> unblockedActions, List<AllocatableAction> blockedCandidates) {
        if (worker.canRunSomething()) {
            this.availableWorkers.addWorker(worker);
        }
        LinkedList<AllocatableAction> dataFreeActions = new LinkedList<AllocatableAction>();
        List<AllocatableAction> resourceFreeActions = unblockedActions;
        this.tryToLaunchFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, worker);
    }

    public void customCoreElementsUpdated() {
        for (ResourceScheduler rs : this.getWorkers()) {
            if (!rs.canRunSomething()) continue;
            this.availableWorkers.addWorker(rs);
        }
    }

    public abstract Score generateActionScore(AllocatableAction var1);

    public abstract <T extends WorkerResourceDescription> LookaheadRS<T> generateSchedulerForResource(Worker<T> var1, JSONObject var2, JSONObject var3);

    protected void scheduleAction(AllocatableAction action, Score actionScore) throws BlockedActionException {
        if (!action.hasDataPredecessors() && !action.hasStreamProducers()) {
            Collection<ResourceScheduler<? extends WorkerResourceDescription>> availableCandidates = this.availableWorkers.getAll();
            if (!availableCandidates.isEmpty()) {
                try {
                    action.schedule(availableCandidates, actionScore);
                }
                catch (UnassignedActionException ex) {
                    this.unassignedReadyActions.addAction(action);
                }
            } else {
                if (action.getCompatibleWorkers().isEmpty()) {
                    throw new BlockedActionException();
                }
                this.unassignedReadyActions.addAction(action);
            }
        }
    }

    protected <T extends WorkerResourceDescription> void scheduleAction(AllocatableAction action, ResourceScheduler<T> targetWorker, Score actionScore) throws BlockedActionException, UnassignedActionException {
        if (!action.hasDataPredecessors() && !action.hasStreamProducers()) {
            action.schedule(targetWorker, actionScore);
        }
    }

    public void upgradeAction(AllocatableAction action) {
        if (DEBUG) {
            LOGGER.debug(" Upgrading action " + action);
        }
        this.upgradedActions.add(action);
    }

    public List<AllocatableAction> getUnassignedActions() {
        return this.unassignedReadyActions.getAllActions();
    }

    public final <T extends WorkerResourceDescription> void handleDependencyFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        LOGGER.debug("[ReadyScheduler] Handling dependency free actions.");
        this.tryToLaunchFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, resource);
    }

    protected <T extends WorkerResourceDescription> PriorityQueue<ObjectValue<AllocatableAction>> getCandidateFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, ActionSet unassignedActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        ObjectValue obj;
        Score fullScore;
        Score actionScore;
        PriorityQueue<ObjectValue<AllocatableAction>> executableActions = new PriorityQueue<ObjectValue<AllocatableAction>>();
        for (AllocatableAction freeAction : dataFreeActions) {
            actionScore = this.generateActionScore(freeAction);
            fullScore = freeAction.schedulingScore(resource, actionScore);
            obj = new ObjectValue((Object)freeAction, fullScore);
            executableActions.add((ObjectValue<AllocatableAction>)obj);
        }
        for (AllocatableAction freeAction : resourceFreeActions) {
            obj = new ObjectValue((Object)freeAction, fullScore = freeAction.schedulingScore(resource, actionScore = this.generateActionScore(freeAction)));
            if (executableActions.contains(obj)) continue;
            executableActions.add((ObjectValue<AllocatableAction>)obj);
        }
        for (AllocatableAction freeAction : unassignedActions.removeAllActions()) {
            obj = new ObjectValue((Object)freeAction, fullScore = freeAction.schedulingScore(resource, actionScore = this.generateActionScore(freeAction)));
            if (executableActions.contains(obj)) continue;
            executableActions.add((ObjectValue<AllocatableAction>)obj);
        }
        return executableActions;
    }

    private PriorityQueue<ObjectValue<AllocatableAction>> sortActions(Iterable<AllocatableAction> actions) {
        if (DEBUG) {
            LOGGER.debug("[ReadyScheduler] Managing " + this.upgradedActions.size() + " upgraded actions.");
        }
        PriorityQueue<ObjectValue<AllocatableAction>> sortedActions = new PriorityQueue<ObjectValue<AllocatableAction>>();
        for (AllocatableAction action : actions) {
            Score fullScore = this.generateActionScore(action);
            ObjectValue obj = new ObjectValue((Object)action, fullScore);
            sortedActions.add((ObjectValue<AllocatableAction>)obj);
        }
        return sortedActions;
    }

    private void manageUpgradedActions() {
        if (!this.upgradedActions.isEmpty()) {
            PriorityQueue<ObjectValue<AllocatableAction>> executableActions = this.sortActions(this.upgradedActions);
            while (!executableActions.isEmpty()) {
                ObjectValue<AllocatableAction> obj = executableActions.poll();
                AllocatableAction freeAction = (AllocatableAction)obj.getObject();
                try {
                    this.tryToScheduleAndLaunch(freeAction, obj.getScore(), freeAction.getCompatibleWorkers());
                    this.upgradedActions.remove(freeAction);
                    this.unassignedReadyActions.removeAction(freeAction);
                }
                catch (UnassignedActionException unassignedActionException) {
                }
                catch (BlockedActionException bae) {
                    this.addToBlocked(freeAction);
                }
            }
        }
    }

    private void manageUpgradedActions(ResourceScheduler<?> resource) {
        if (!this.upgradedActions.isEmpty()) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Managing " + this.upgradedActions.size() + " upgraded actions.");
            }
            PriorityQueue<ObjectValue<AllocatableAction>> executableActions = this.sortActions(this.upgradedActions);
            while (!executableActions.isEmpty()) {
                ObjectValue<AllocatableAction> obj = executableActions.poll();
                AllocatableAction freeAction = (AllocatableAction)obj.getObject();
                if (!freeAction.getCompatibleWorkers().contains(resource) || !resource.canRunSomething()) continue;
                try {
                    this.tryToScheduleAndLaunch(freeAction, obj.getScore(), resource);
                    this.upgradedActions.remove(freeAction);
                    this.unassignedReadyActions.removeAction(freeAction);
                }
                catch (UnassignedActionException unassignedActionException) {
                }
                catch (BlockedActionException bae) {
                    this.addToBlocked(freeAction);
                }
            }
        }
    }

    private <T extends WorkerResourceDescription> void tryToLaunchFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        this.manageUpgradedActions(resource);
        PriorityQueue<ObjectValue<AllocatableAction>> executableActions = this.getCandidateFreeActions(dataFreeActions, resourceFreeActions, this.unassignedReadyActions, blockedCandidates, resource);
        AH ah = new AH(blockedCandidates);
        RA ra = new RA();
        this.tryToScheduleActions(executableActions, ra, ah);
    }

    protected void tryToScheduleActions(PriorityQueue<ObjectValue<AllocatableAction>> executableActions, ResourcePool rp, ActionHandler handler) {
        AllocatableAction freeAction;
        ObjectValue<AllocatableAction> obj;
        Set<AllocatableAction> oldUpgradedActions = this.upgradedActions;
        while (!executableActions.isEmpty() && rp.checkAvailability()) {
            obj = executableActions.poll();
            freeAction = (AllocatableAction)obj.getObject();
            Score actionScore = obj.getScore();
            this.upgradedActions = new HashSet<AllocatableAction>();
            LOGGER.debug("[ReadyScheduler] Trying to launch action " + freeAction);
            try {
                this.tryToScheduleAndLaunch(freeAction, actionScore, rp.getAll());
                if (this.upgradedActions.isEmpty()) continue;
                this.manageUpgradedActions();
                oldUpgradedActions.addAll(this.upgradedActions);
            }
            catch (UnassignedActionException e) {
                handler.unassigned(freeAction);
            }
            catch (BlockedActionException e) {
                handler.blocked(freeAction);
            }
        }
        while (!executableActions.isEmpty()) {
            obj = executableActions.poll();
            freeAction = (AllocatableAction)obj.getObject();
            handler.unassigned(freeAction);
        }
        this.upgradedActions = oldUpgradedActions;
    }

    private void tryToScheduleAndLaunch(AllocatableAction action, Score actionScore, ResourceScheduler<?> resource) throws UnassignedActionException, BlockedActionException {
        if (action.getCompatibleWorkers().isEmpty()) {
            throw new BlockedActionException();
        }
        action.schedule(resource, actionScore);
        this.tryToLaunch(action);
        ResourceScheduler assignedResource = action.getAssignedResource();
        if (!assignedResource.canRunSomething()) {
            this.availableWorkers.removeWorker(assignedResource);
        }
    }

    private void tryToScheduleAndLaunch(AllocatableAction action, Score actionScore, Collection<ResourceScheduler<?>> resources) throws UnassignedActionException, BlockedActionException {
        if (action.getCompatibleWorkers().isEmpty()) {
            throw new BlockedActionException();
        }
        action.schedule(resources, actionScore);
        this.tryToLaunch(action);
        ResourceScheduler assignedResource = action.getAssignedResource();
        if (!assignedResource.canRunSomething()) {
            this.availableWorkers.removeWorker(assignedResource);
        }
    }

    private static class AvailableWorkersSet {
        private final HashSet<ResourceScheduler<? extends WorkerResourceDescription>> availableWorkers = new HashSet();

        public Collection<ResourceScheduler<? extends WorkerResourceDescription>> getAll() {
            Iterator<ResourceScheduler<? extends WorkerResourceDescription>> iterator = this.availableWorkers.iterator();
            while (iterator.hasNext()) {
                ResourceScheduler<? extends WorkerResourceDescription> rs = iterator.next();
                if (rs.canRunSomething()) continue;
                iterator.remove();
            }
            return this.availableWorkers;
        }

        public <T extends WorkerResourceDescription> void addWorker(ResourceScheduler<T> resource) {
            if (resource.canRunSomething()) {
                this.availableWorkers.add(resource);
            }
        }

        private <T extends WorkerResourceDescription> void removeWorker(ResourceScheduler<T> resource) {
            this.availableWorkers.remove(resource);
        }

        private boolean isEmpty() {
            return this.availableWorkers.isEmpty();
        }
    }

    private class AH
    implements ActionHandler {
        private final List<AllocatableAction> blocked;

        public AH(List<AllocatableAction> blocked) {
            this.blocked = blocked;
        }

        @Override
        public void unassigned(AllocatableAction action) {
            LookaheadTS.this.unassignedReadyActions.addAction(action);
        }

        @Override
        public void blocked(AllocatableAction action) {
            this.blocked.add(action);
        }
    }

    protected static interface ActionHandler {
        public void unassigned(AllocatableAction var1);

        public void blocked(AllocatableAction var1);
    }

    private class RA
    implements ResourcePool {
        private RA() {
        }

        @Override
        public boolean checkAvailability() {
            return !LookaheadTS.this.availableWorkers.isEmpty();
        }

        @Override
        public Collection<ResourceScheduler<? extends WorkerResourceDescription>> getAll() {
            return LookaheadTS.this.availableWorkers.getAll();
        }
    }

    protected static interface ResourcePool {
        public boolean checkAvailability();

        public Collection<ResourceScheduler<? extends WorkerResourceDescription>> getAll();
    }
}

