/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.lookahead;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.lookahead.LookaheadTS;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.ObjectValue;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.ActionSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;

public abstract class SuccessorsTS
extends LookaheadTS {
    @Override
    public <T extends WorkerResourceDescription> PriorityQueue<ObjectValue<AllocatableAction>> getCandidateFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, ActionSet unassignedActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        LOGGER.debug("[DataScheduler] Treating dependency free actions");
        PriorityQueue<ObjectValue<AllocatableAction>> executableActions = new PriorityQueue<ObjectValue<AllocatableAction>>();
        for (AllocatableAction action : dataFreeActions) {
            Score actionScore = this.generateActionScore(action);
            Score fullScore = action.schedulingScore(resource, actionScore);
            ObjectValue obj = new ObjectValue((Object)action, fullScore);
            executableActions.add((ObjectValue<AllocatableAction>)obj);
        }
        dataFreeActions.clear();
        AH ah = new AH(dataFreeActions, blockedCandidates);
        RA ra = new RA(resource);
        this.tryToScheduleActions(executableActions, ra, ah);
        return super.getCandidateFreeActions(dataFreeActions, resourceFreeActions, unassignedActions, blockedCandidates, resource);
    }

    private static class AH
    implements LookaheadTS.ActionHandler {
        private final List<AllocatableAction> unassigned;
        private final List<AllocatableAction> blocked;

        public AH(List<AllocatableAction> unassigned, List<AllocatableAction> blocked) {
            this.unassigned = unassigned;
            this.blocked = blocked;
        }

        @Override
        public void unassigned(AllocatableAction action) {
            this.unassigned.add(action);
        }

        @Override
        public void blocked(AllocatableAction action) {
            this.blocked.add(action);
        }
    }

    private static class RA
    implements LookaheadTS.ResourcePool {
        final ResourceScheduler<? extends WorkerResourceDescription> resource;

        public RA(ResourceScheduler<? extends WorkerResourceDescription> resource) {
            this.resource = resource;
        }

        @Override
        public boolean checkAvailability() {
            return this.resource.canRunSomething();
        }

        @Override
        public Collection<ResourceScheduler<? extends WorkerResourceDescription>> getAll() {
            ArrayList<ResourceScheduler<? extends WorkerResourceDescription>> list = new ArrayList<ResourceScheduler<? extends WorkerResourceDescription>>(1);
            list.add(this.resource);
            return list;
        }
    }
}

