/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.lookahead.mt;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.ObjectValue;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Future;
import org.json.JSONObject;

public abstract class LookaheadRS<T extends WorkerResourceDescription>
extends ResourceScheduler<T> {
    protected final Set<ObjectValue<AllocatableAction>> unassignedActions = new TreeSet<ObjectValue<AllocatableAction>>();
    protected final Map<AllocatableAction, ObjectValue<AllocatableAction>> addedActions = new HashMap<AllocatableAction, ObjectValue<AllocatableAction>>();
    private Future<?> token = null;

    public LookaheadRS(Worker<T> w, JSONObject resJSON, JSONObject implJSON) {
        super(w, resJSON, implJSON);
    }

    public Set<ObjectValue<AllocatableAction>> getUnassignedActions() {
        return this.unassignedActions;
    }

    public Map<AllocatableAction, ObjectValue<AllocatableAction>> getAddedActions() {
        return this.addedActions;
    }

    public Future<?> getToken() {
        return this.token;
    }

    public void setToken(Future<?> token) {
        this.token = token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAction(AllocatableAction action, Score actionScore) {
        Score fullScore = action.schedulingScore((ResourceScheduler)this, actionScore);
        ObjectValue obj = new ObjectValue((Object)action, fullScore);
        boolean added = false;
        Set<ObjectValue<AllocatableAction>> set = this.unassignedActions;
        synchronized (set) {
            added = this.unassignedActions.add((ObjectValue<AllocatableAction>)obj);
        }
        if (added) {
            this.addedActions.put(action, (ObjectValue<AllocatableAction>)obj);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAction(AllocatableAction action) {
        ObjectValue<AllocatableAction> obj = this.addedActions.remove(action);
        boolean removed = false;
        if (obj != null) {
            Set<ObjectValue<AllocatableAction>> set = this.unassignedActions;
            synchronized (set) {
                removed = this.unassignedActions.remove(obj);
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAction(AllocatableAction action, Score actionScore) {
        ObjectValue obj = this.addedActions.remove(action);
        if (obj != null) {
            boolean removed = false;
            Set<ObjectValue<AllocatableAction>> set = this.unassignedActions;
            synchronized (set) {
                removed = this.unassignedActions.remove(obj);
            }
            if (removed) {
                Score fullScore = action.schedulingScore((ResourceScheduler)this, actionScore);
                obj = new ObjectValue((Object)action, fullScore);
                boolean added = false;
                Set<ObjectValue<AllocatableAction>> set2 = this.unassignedActions;
                synchronized (set2) {
                    added = this.unassignedActions.add((ObjectValue<AllocatableAction>)obj);
                }
                if (added) {
                    this.addedActions.put(action, (ObjectValue<AllocatableAction>)obj);
                }
            }
        }
    }

    public abstract Score generateBlockedScore(AllocatableAction var1);

    public abstract Score generateResourceScore(AllocatableAction var1, TaskDescription var2, Score var3);

    public abstract Score generateImplementationScore(AllocatableAction var1, TaskDescription var2, Implementation var3, Score var4);

    public abstract String toString();

    public final void clear() {
        this.unassignedActions.clear();
        this.addedActions.clear();
        this.token = null;
        super.clear();
    }
}

