/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.lookahead.mt;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.lookahead.mt.LookaheadRS;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.ObjectValue;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.ErrorManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class LookaheadTS
extends TaskScheduler {
    private final ThreadPoolExecutor schedulerExecutor;
    protected final HashSet<ResourceScheduler<? extends WorkerResourceDescription>> availableWorkers = new HashSet();
    protected Set<AllocatableAction> upgradedActions;

    public LookaheadTS() {
        this.schedulerExecutor = new ThreadPoolExecutor(15, 40, 180L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.schedulerExecutor.allowCoreThreadTimeOut(true);
        this.upgradedActions = new HashSet<AllocatableAction>();
    }

    public void customSchedulerShutdown() {
        this.schedulerExecutor.shutdown();
    }

    public <T extends WorkerResourceDescription> void workerLoadUpdate(ResourceScheduler<T> resource) {
        LOGGER.debug("[ReadyScheduler] Update load on worker " + resource.getName() + ". Nothing to do.");
        if (resource.canRunSomething()) {
            this.availableWorkers.add(resource);
        }
    }

    protected <T extends WorkerResourceDescription> void workerDetected(ResourceScheduler<T> resource) {
        super.workerDetected(resource);
        if (this.getWorkers().size() > 0) {
            LookaheadRS rs = (LookaheadRS)resource;
            for (AllocatableAction action : this.getUnassignedActions()) {
                Score actionScore = this.generateActionScore(action);
                rs.addAction(action, actionScore);
            }
        }
        this.availableWorkers.add(resource);
    }

    protected <T extends WorkerResourceDescription> void workerRemoved(ResourceScheduler<T> resource) {
        this.availableWorkers.remove(resource);
        LookaheadRS rs = (LookaheadRS)resource;
        if (this.availableWorkers.isEmpty()) {
            for (ObjectValue<AllocatableAction> actionValue : rs.getUnassignedActions()) {
                AllocatableAction action = (AllocatableAction)actionValue.getObject();
                this.addToBlocked(action);
            }
        }
        rs.clear();
        super.workerRemoved(resource);
    }

    public <T extends WorkerResourceDescription> void workerFeaturesUpdate(ResourceScheduler<T> worker, T modification, List<AllocatableAction> unblockedActions, List<AllocatableAction> blockedCandidates) {
        LinkedList<AllocatableAction> dataFreeActions = new LinkedList<AllocatableAction>();
        List<AllocatableAction> resourceFreeActions = unblockedActions;
        this.purgeFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, worker);
        this.tryToLaunchFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, worker);
    }

    public abstract Score generateActionScore(AllocatableAction var1);

    protected void scheduleAction(AllocatableAction action, Score actionScore) throws BlockedActionException {
        if (!action.hasDataPredecessors() && !action.hasStreamProducers()) {
            try {
                if (action.getCompatibleWorkers().isEmpty()) {
                    throw new BlockedActionException();
                }
                if (!this.availableWorkers.isEmpty()) {
                    action.schedule(this.getAvailableWorkers(), this.generateActionScore(action));
                    this.removeActionFromSchedulerStructures(action);
                } else {
                    this.addActionToSchedulerStructures(action);
                }
            }
            catch (UnassignedActionException ex) {
                this.addActionToSchedulerStructures(action);
            }
        }
    }

    protected <T extends WorkerResourceDescription> void scheduleAction(AllocatableAction action, ResourceScheduler<T> targetWorker, Score actionScore) throws BlockedActionException, UnassignedActionException {
        if (!action.hasDataPredecessors() && !action.hasStreamProducers()) {
            action.schedule(targetWorker, actionScore);
            this.removeActionFromSchedulerStructures(action);
        }
    }

    public Collection<AllocatableAction> getUnassignedActions() {
        HashSet<AllocatableAction> unassigned = new HashSet<AllocatableAction>();
        for (LookaheadRS resource : this.getWorkers()) {
            Future<?> resourceToken = resource.getToken();
            if (resourceToken != null) {
                try {
                    resourceToken.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.fatal("Unexpected thread interruption", (Throwable)e);
                    ErrorManager.fatal((String)"Unexpected thread interruption", (Exception)e);
                }
            }
            for (ObjectValue<AllocatableAction> actionObject : resource.getUnassignedActions()) {
                unassigned.add((AllocatableAction)actionObject.getObject());
            }
        }
        return unassigned;
    }

    public final <T extends WorkerResourceDescription> void handleDependencyFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        if (DEBUG) {
            LOGGER.debug("[ReadyScheduler] Handling dependency free actions.");
        }
        this.manageUpgradedActions(resource);
        if (resource.canRunSomething()) {
            this.availableWorkers.add(resource);
        }
        this.purgeFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, resource);
        this.tryToLaunchFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, resource);
    }

    public <T extends WorkerResourceDescription> void purgeFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
    }

    private void manageUpgradedActions(ResourceScheduler<?> resource) {
        if (!this.upgradedActions.isEmpty()) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Managing " + this.upgradedActions.size() + " upgraded actions.");
            }
            PriorityQueue<ObjectValue> executableActions = new PriorityQueue<ObjectValue>();
            for (AllocatableAction action : this.upgradedActions) {
                Score fullScore = action.schedulingScore(resource, this.generateActionScore(action));
                ObjectValue obj = new ObjectValue((Object)action, fullScore);
                executableActions.add(obj);
            }
            while (!executableActions.isEmpty() && resource.canRunSomething()) {
                ObjectValue obj = (ObjectValue)executableActions.poll();
                AllocatableAction freeAction = (AllocatableAction)obj.getObject();
                if (!freeAction.getCompatibleWorkers().contains(resource)) continue;
                try {
                    freeAction.schedule(resource, obj.getScore());
                    this.tryToLaunch(freeAction);
                    this.upgradedActions.remove(freeAction);
                    this.removeActionFromSchedulerStructures(freeAction);
                }
                catch (UnassignedActionException unassignedActionException) {}
            }
            if (!resource.canRunSomething()) {
                this.availableWorkers.remove(resource);
            }
        }
    }

    private void updateActionToSchedulerStructures(AllocatableAction action) {
        if (!this.getWorkers().isEmpty()) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Updating action to scheduler structures " + action);
            }
            if (action.isTargetResourceEnforced()) {
                LookaheadRS resource = (LookaheadRS)action.getEnforcedTargetResource();
                Score actionScore = this.generateActionScore(action);
                resource.updateAction(action, actionScore);
            } else {
                this.updateActionInAllResources(action);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Cannot add action " + action + " because there are not available resources");
            }
            this.addToBlocked(action);
        }
    }

    private void addActionToSchedulerStructures(AllocatableAction action) {
        if (!this.getWorkers().isEmpty()) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Add action to scheduler structures " + action);
            }
            Score actionScore = this.generateActionScore(action);
            if (action.isTargetResourceEnforced()) {
                LookaheadRS resource = (LookaheadRS)action.getEnforcedTargetResource();
                resource.addAction(action, actionScore);
            } else {
                this.addActionInAllResources(actionScore, action);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Cannot add action " + action + " because there are not available resources");
            }
            this.addToBlocked(action);
        }
    }

    private void addActionInAllResources(Score actionScore, AllocatableAction action) {
        Iterator iter = this.getWorkers().iterator();
        if (iter.hasNext()) {
            LookaheadRS resource = (LookaheadRS)((Object)iter.next());
            if (!resource.addAction(action, actionScore)) {
                if (DEBUG) {
                    LOGGER.debug("[ReadyScheduler] Action already added " + action);
                }
                return;
            }
            while (iter.hasNext()) {
                resource = (LookaheadRS)((Object)iter.next());
                Future<?> lastToken = resource.getToken();
                resource.setToken(this.schedulerExecutor.submit(new AddRunnable(resource, actionScore, action, lastToken)));
            }
        } else if (DEBUG) {
            LOGGER.debug("[ReadyScheduler] No resources to addAction");
        }
    }

    private void updateActionInAllResources(AllocatableAction action) {
        for (LookaheadRS resource : this.getWorkers()) {
            Future<?> lastToken = resource.getToken();
            resource.setToken(this.schedulerExecutor.submit(new UpdateRunnable(resource, action, lastToken)));
        }
    }

    private void removeActionFromSchedulerStructures(AllocatableAction action) {
        if (!this.getWorkers().isEmpty()) {
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Remove action from scheduler structures " + action);
            }
            if (action.isTargetResourceEnforced()) {
                LookaheadRS resource = (LookaheadRS)action.getEnforcedTargetResource();
                resource.removeAction(action);
            } else {
                this.removeActionFromAllResources(action);
            }
        }
    }

    private void removeActionFromAllResources(AllocatableAction action) {
        Iterator iter = this.getWorkers().iterator();
        if (iter.hasNext()) {
            LookaheadRS resource = (LookaheadRS)((Object)iter.next());
            if (!resource.removeAction(action)) {
                if (DEBUG) {
                    LOGGER.debug("[ReadyScheduler] Action already added " + action);
                }
                return;
            }
            while (iter.hasNext()) {
                resource = (LookaheadRS)((Object)iter.next());
                Future<?> lastToken = resource.getToken();
                resource.setToken(this.schedulerExecutor.submit(new RemoveRunnable(resource, action, lastToken)));
            }
        } else if (DEBUG) {
            LOGGER.debug("[ReadyScheduler] No resources to addAction");
        }
    }

    protected <T extends WorkerResourceDescription> void tryToLaunchFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> rs) {
        LookaheadRS resource = (LookaheadRS)rs;
        if (DEBUG) {
            LOGGER.debug("[ReadyScheduler] Try to launch free actions on resource " + resource.getName());
        }
        for (AllocatableAction freeAction : dataFreeActions) {
            if (freeAction.getCompatibleWorkers().isEmpty()) {
                blockedCandidates.add(freeAction);
                continue;
            }
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler] Introducing data free action " + freeAction + " into the scheduler.");
            }
            this.addActionToSchedulerStructures(freeAction);
        }
        Future<?> lastToken = resource.getToken();
        if (lastToken != null) {
            try {
                lastToken.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.fatal("Unexpected thread interruption", (Throwable)e);
                ErrorManager.fatal((String)"Unexpected thread interruption", (Exception)e);
            }
        }
        Semaphore sem = new Semaphore(0);
        resource.setToken(this.schedulerExecutor.submit(new WaitSchedulingRunnable(resource, sem)));
        Set<ObjectValue<AllocatableAction>> unassignedActions = resource.getUnassignedActions();
        if (unassignedActions != null) {
            HashSet<ObjectValue<AllocatableAction>> objectValueToErase = new HashSet<ObjectValue<AllocatableAction>>();
            Iterator<ObjectValue<AllocatableAction>> executableActionsIterator = unassignedActions.iterator();
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler]  ***** Trying to schedule " + unassignedActions.size() + " unassigned actions to " + this.availableWorkers.size() + " workers");
            }
            Collection<ResourceScheduler<? extends WorkerResourceDescription>> candidateResources = this.getAvailableWorkers();
            while (executableActionsIterator.hasNext() && !candidateResources.isEmpty()) {
                ObjectValue<AllocatableAction> obj = executableActionsIterator.next();
                AllocatableAction allocatableAction = (AllocatableAction)obj.getObject();
                if (DEBUG) {
                    LOGGER.debug("[ReadyScheduler] -- Trying to schedule " + allocatableAction);
                }
                try {
                    allocatableAction.schedule(candidateResources, this.generateActionScore(allocatableAction));
                    this.tryToLaunch(allocatableAction);
                    ResourceScheduler assignedResource = allocatableAction.getAssignedResource();
                    if (DEBUG) {
                        LOGGER.debug("[ReadyScheduler] -- Action " + allocatableAction + " successfully scheduled and launched in " + assignedResource.getName());
                    }
                    objectValueToErase.add(obj);
                    if (assignedResource.canRunSomething()) continue;
                    this.availableWorkers.remove(assignedResource);
                }
                catch (UnassignedActionException e) {
                    if (!DEBUG) continue;
                    LOGGER.debug("[ReadyScheduler] -- Action " + allocatableAction + " could not be assigned to any of the available resources");
                }
            }
            sem.release();
            if (DEBUG) {
                LOGGER.debug("[ReadyScheduler]  ***** Unassigned actions scheduling finished. Removing " + objectValueToErase.size() + " actions from scheduler structures.");
            }
            for (ObjectValue objectValue : objectValueToErase) {
                AllocatableAction action = (AllocatableAction)objectValue.getObject();
                this.removeActionFromSchedulerStructures(action);
            }
        }
        if (DEBUG) {
            LOGGER.debug("[ReadyScheduler] Try to launch free actions on resource " + resource.getName() + " finished.");
        }
    }

    public void upgradeAction(AllocatableAction action) {
        if (DEBUG) {
            LOGGER.debug(" Upgrading action " + action);
        }
        this.upgradedActions.add(action);
        this.updateActionToSchedulerStructures(action);
    }

    protected Collection<ResourceScheduler<? extends WorkerResourceDescription>> getAvailableWorkers() {
        Iterator<ResourceScheduler<? extends WorkerResourceDescription>> iterator = this.availableWorkers.iterator();
        while (iterator.hasNext()) {
            ResourceScheduler<? extends WorkerResourceDescription> rs = iterator.next();
            if (rs.canRunSomething()) continue;
            iterator.remove();
        }
        return this.availableWorkers;
    }

    private class UpdateRunnable
    implements Runnable {
        private LookaheadRS<?> resource;
        private AllocatableAction action;
        private Future<?> token;

        public UpdateRunnable(LookaheadRS<?> resource, AllocatableAction action, Future<?> token) {
            this.resource = resource;
            this.action = action;
            this.token = token;
        }

        @Override
        public void run() {
            if (this.token != null) {
                try {
                    this.token.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.fatal("Unexpected thread interruption", (Throwable)e);
                    ErrorManager.fatal((String)"Unexpected thread interruption", (Exception)e);
                    Thread.currentThread().interrupt();
                }
            }
            Score actionScore = LookaheadTS.this.generateActionScore(this.action);
            this.resource.updateAction(this.action, actionScore);
        }
    }

    private class AddRunnable
    implements Runnable {
        private LookaheadRS<?> resource;
        private AllocatableAction action;
        private Future<?> token;
        private Score actionScore;

        public AddRunnable(LookaheadRS<?> scheduler, Score actionScore, AllocatableAction action, Future<?> token) {
            this.resource = scheduler;
            this.actionScore = actionScore;
            this.action = action;
            this.token = token;
        }

        @Override
        public void run() {
            if (this.token != null) {
                try {
                    this.token.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.fatal("Unexpected thread interruption", (Throwable)e);
                    ErrorManager.fatal((String)"Unexpected thread interruption", (Exception)e);
                    Thread.currentThread().interrupt();
                }
            }
            this.resource.addAction(this.action, this.actionScore);
        }
    }

    private class WaitSchedulingRunnable
    implements Runnable {
        private ResourceScheduler<?> resource;
        private Semaphore sem;

        public WaitSchedulingRunnable(ResourceScheduler<?> resource, Semaphore sem) {
            this.resource = resource;
            this.sem = sem;
        }

        @Override
        public void run() {
            try {
                this.sem.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class RemoveRunnable
    implements Runnable {
        private LookaheadRS<?> resource;
        private AllocatableAction action;
        private Future<?> token;

        public RemoveRunnable(LookaheadRS<?> scheduler, AllocatableAction action, Future<?> token) {
            this.resource = scheduler;
            this.action = action;
            this.token = token;
        }

        @Override
        public void run() {
            if (this.token != null) {
                try {
                    this.token.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.fatal("Unexpected thread interruption", (Throwable)e);
                    ErrorManager.fatal((String)"Unexpected thread interruption", (Exception)e);
                    Thread.currentThread().interrupt();
                }
            }
            this.resource.removeAction(this.action);
        }
    }
}

