/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.lookahead.mt;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.lookahead.mt.LookaheadTS;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.ObjectValue;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.List;
import java.util.PriorityQueue;

public abstract class SuccessorsTS
extends LookaheadTS {
    @Override
    public final <T extends WorkerResourceDescription> void purgeFreeActions(List<AllocatableAction> dataFreeActions, List<AllocatableAction> resourceFreeActions, List<AllocatableAction> blockedCandidates, ResourceScheduler<T> resource) {
        AllocatableAction freeAction;
        ObjectValue obj;
        PriorityQueue<ObjectValue> executableActions = new PriorityQueue<ObjectValue>();
        for (AllocatableAction action : dataFreeActions) {
            Score actionScore = this.generateActionScore(action);
            Score fullScore = action.schedulingScore(resource, actionScore);
            ObjectValue obj2 = new ObjectValue((Object)action, fullScore);
            executableActions.add(obj2);
        }
        dataFreeActions.clear();
        while (!executableActions.isEmpty() && !this.availableWorkers.isEmpty()) {
            obj = (ObjectValue)executableActions.poll();
            freeAction = (AllocatableAction)obj.getObject();
            try {
                if (freeAction.getCompatibleWorkers().isEmpty()) {
                    blockedCandidates.add(freeAction);
                }
                freeAction.schedule(this.getAvailableWorkers(), this.generateActionScore(freeAction));
                this.tryToLaunch(freeAction);
            }
            catch (UnassignedActionException e) {
                dataFreeActions.add(freeAction);
            }
        }
        while (!executableActions.isEmpty()) {
            obj = (ObjectValue)executableActions.poll();
            freeAction = (AllocatableAction)obj.getObject();
            dataFreeActions.add(freeAction);
        }
        super.purgeFreeActions(dataFreeActions, resourceFreeActions, blockedCandidates, resource);
    }
}

