/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util.serializers;

import es.bsc.compss.types.exceptions.NonInstantiableException;
import es.bsc.compss.util.serializers.BinarySerializer;
import es.bsc.compss.util.serializers.PyBindingSerializer;
import es.bsc.compss.util.serializers.XMLSerializer;
import java.io.IOException;
import java.io.NotSerializableException;

public class Serializer {
    private Serializer() {
        throw new NonInstantiableException("Serializer");
    }

    public static void serialize(Object o, String file) throws IOException {
        try {
            BinarySerializer.serialize(o, file);
        }
        catch (NotSerializableException e) {
            XMLSerializer.serialize(o, file);
        }
    }

    public static void serialize(Object o, String file, Format[] priorities) throws IOException {
        block5: for (Format serializer : priorities) {
            switch (serializer) {
                case PYBINDING: {
                    PyBindingSerializer.serialize(o, file);
                    break block5;
                }
                case BINARY: {
                    BinarySerializer.serialize(o, file);
                    break block5;
                }
                case XML: {
                    XMLSerializer.serialize(o, file);
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
        }
    }

    public static byte[] serialize(Object o) throws IOException {
        try {
            return BinarySerializer.serialize(o);
        }
        catch (NotSerializableException e) {
            return XMLSerializer.serialize(o);
        }
    }

    public static Object deserialize(String file) throws IOException, ClassNotFoundException {
        try {
            return BinarySerializer.deserialize(file);
        }
        catch (Exception e) {
            return XMLSerializer.deserialize(file);
        }
    }

    public static Object deserialize(String file, Format[] priorities) throws IOException, ClassNotFoundException {
        for (Format serializer : priorities) {
            try {
                switch (serializer) {
                    case PYBINDING: {
                        return PyBindingSerializer.deserialize(file);
                    }
                    case BINARY: {
                        return BinarySerializer.deserialize(file);
                    }
                    case XML: {
                        return XMLSerializer.deserialize(file);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw new IOException();
    }

    public static Object deserialize(byte[] data) throws IOException, ClassNotFoundException {
        try {
            return BinarySerializer.deserialize(data);
        }
        catch (Exception e) {
            return XMLSerializer.deserialize(data);
        }
    }

    public static enum Format {
        JSON,
        XML,
        BINARY,
        PYBINDING;

    }
}

