/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.distrostreamlib.api.objects;

import es.bsc.distrostreamlib.api.impl.DistroStreamImpl;
import es.bsc.distrostreamlib.api.objects.ODSConsumer;
import es.bsc.distrostreamlib.api.objects.ODSPublisher;
import es.bsc.distrostreamlib.client.DistroStreamClient;
import es.bsc.distrostreamlib.exceptions.BackendException;
import es.bsc.distrostreamlib.exceptions.RegistrationException;
import es.bsc.distrostreamlib.requests.BootstrapServerRequest;
import es.bsc.distrostreamlib.types.ConsumerMode;
import es.bsc.distrostreamlib.types.StreamType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ObjectDistroStream<T>
extends DistroStreamImpl<T> {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.distroStreamLib.stream.ObjectDistroStream");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private String topicName;
    private transient String bootstrapServer;
    private transient ODSPublisher<T> publisher;
    private transient ODSConsumer<T> consumer;

    public ObjectDistroStream() {
    }

    public ObjectDistroStream(ConsumerMode mode) throws RegistrationException {
        super(null, StreamType.OBJECT, mode, new LinkedList<String>());
        this.topicName = "regular-messages-" + this.id;
        this.bootstrapServer = null;
        this.publisher = null;
        this.consumer = null;
    }

    public ObjectDistroStream(String alias, ConsumerMode mode) throws RegistrationException {
        super(alias, StreamType.OBJECT, mode, new LinkedList<String>());
        this.topicName = this.alias;
        this.bootstrapServer = null;
        this.publisher = null;
        this.consumer = null;
    }

    @Override
    public final void publish(T message) throws BackendException {
        LOGGER.info("Publishing new Object message...");
        this.registerPublisher();
        this.publisher.publish(this.topicName, message);
        LOGGER.info("Published new Object message");
    }

    @Override
    public final void publish(List<T> messages) throws BackendException {
        LOGGER.info("Publishing new List of Object messages");
        this.registerPublisher();
        for (T msg : messages) {
            this.publisher.publish(this.topicName, msg);
        }
        LOGGER.info("Published new List of Object messages");
    }

    @Override
    public final List<T> poll() throws BackendException {
        LOGGER.info("Polling new stream entries...");
        this.registerConsumer();
        return this.consumer.pollMessages(200L);
    }

    @Override
    public final List<T> poll(long timeout) throws BackendException {
        LOGGER.info("Polling new stream entries with timeout ( " + timeout + ")...");
        this.registerConsumer();
        return this.consumer.pollMessages(timeout);
    }

    private void registerPublisher() throws BackendException {
        if (this.publisher == null) {
            if (this.bootstrapServer == null) {
                this.bootstrapServer = this.requestBoostrapServerInformation();
            }
            LOGGER.info("Creating internal producer...");
            this.publisher = new ODSPublisher(this.bootstrapServer);
        }
    }

    private void registerConsumer() throws BackendException {
        if (this.consumer == null) {
            if (this.bootstrapServer == null) {
                this.bootstrapServer = this.requestBoostrapServerInformation();
            }
            LOGGER.info("Creating internal consumer...");
            this.consumer = new ODSConsumer(this.bootstrapServer, this.topicName, this.mode);
        }
    }

    private String requestBoostrapServerInformation() throws BackendException {
        LOGGER.info("Requesting bootstrap server...");
        BootstrapServerRequest req = new BootstrapServerRequest();
        DistroStreamClient.request(req);
        req.waitProcessed();
        int error = req.getErrorCode();
        if (error != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("ERROR: Cannot request bootstrap server name and port").append("\n");
            sb.append("  - Error Code: ").append(error).append("\n");
            sb.append("  - Nested Error Message: ").append(req.getErrorMessage()).append("\n");
            throw new BackendException(sb.toString());
        }
        String response = req.getResponseMessage();
        if (DEBUG) {
            LOGGER.debug("Retrieved bootstrap server information: " + response);
        }
        return response;
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        super.readExternal(oi);
        this.topicName = (String)oi.readObject();
        this.bootstrapServer = null;
        this.publisher = null;
        this.consumer = null;
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        super.writeExternal(oo);
        oo.writeObject(this.topicName);
    }
}

