/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.rest.basic.auth.extension;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.regex.Pattern;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import org.apache.kafka.common.config.ConfigException;

public class JaasBasicAuthFilter
implements ContainerRequestFilter {
    private static final String CONNECT_LOGIN_MODULE = "KafkaConnect";
    static final String AUTHORIZATION = "Authorization";
    private static final Pattern TASK_REQUEST_PATTERN = Pattern.compile("/?connectors/([^/]+)/tasks/?");

    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            if (!requestContext.getMethod().equals("POST") || !TASK_REQUEST_PATTERN.matcher(requestContext.getUriInfo().getPath()).matches()) {
                LoginContext loginContext = new LoginContext(CONNECT_LOGIN_MODULE, new BasicAuthCallBackHandler(requestContext.getHeaderString(AUTHORIZATION)));
                loginContext.login();
            }
        }
        catch (LoginException | ConfigException e) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"User cannot access the resource.").build());
        }
    }

    public static class BasicAuthCallBackHandler
    implements CallbackHandler {
        private static final String BASIC = "basic";
        private static final char COLON = ':';
        private static final char SPACE = ' ';
        private String username;
        private String password;

        public BasicAuthCallBackHandler(String credentials) {
            String method;
            int space;
            if (credentials != null && (space = credentials.indexOf(32)) > 0 && BASIC.equalsIgnoreCase(method = credentials.substring(0, space))) {
                credentials = credentials.substring(space + 1);
                credentials = new String(Base64.getDecoder().decode(credentials), StandardCharsets.UTF_8);
                int i = credentials.indexOf(58);
                if (i > 0) {
                    this.username = credentials.substring(0, i);
                    this.password = credentials.substring(i + 1);
                }
            }
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Supports only NameCallback and PasswordCallback");
            }
        }
    }
}

