/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.monitoring.jobmonitor;

import es.bsc.compss.gos.master.GOSJob;
import es.bsc.compss.gos.master.sshutils.SSHChannel;
import es.bsc.compss.types.job.JobEndStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GOSSingleJobManager {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private final GOSJob gosJob;
    private final String id;

    public GOSSingleJobManager(GOSJob job) {
        this.gosJob = job;
        this.id = job.getCompositeID();
    }

    public String getID() {
        return this.id;
    }

    public boolean isChannelEnded() {
        SSHChannel ch = this.gosJob.getChannel();
        if (ch == null) {
            return true;
        }
        if (ch.getExitStatus() != -1) {
            ch.disconnect();
        }
        return ch.isClosed();
    }

    public boolean monitor() {
        if (this.isChannelEnded()) {
            SSHChannel ch = this.gosJob.getChannel();
            if (ch == null) {
                LOGGER.warn("[WARNING] Channel is null in monitoring");
                this.gosJob.notifyFailure(JobEndStatus.SUBMISSION_FAILED);
                return true;
            }
            int status = ch.getExitStatus();
            switch (status) {
                case 0: {
                    this.gosJob.notifySuccess();
                    break;
                }
                case 127: {
                    this.gosJob.notifyFailure(JobEndStatus.SUBMISSION_FAILED);
                    break;
                }
                default: {
                    this.gosJob.notifyFailure(JobEndStatus.EXECUTION_FAILED);
                }
            }
            this.releaseResource();
            return true;
        }
        return false;
    }

    private void releaseResource() {
        if (this.gosJob.getChannel() != null) {
            this.gosJob.getChannel().disconnect();
        }
    }

    public void shutdown() {
        this.releaseResource();
        this.gosJob.notifyFailure(JobEndStatus.EXCEPTION);
    }
}

