/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.sshutils;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import es.bsc.compss.gos.master.sshutils.SSHChannel;
import es.bsc.compss.gos.master.sshutils.SSHHost;
import es.bsc.compss.gos.master.sshutils.SSHSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SSHSessionManager {
    private static final int CHANNELS_PER_SESSION = 2;
    private static final int MAX_EMPTY_SESSIONS = 3;
    private static final int DEFAULT_PORT = 22;
    private final JSch jsch;
    private final SSHHost host;
    private final Map<String, SSHSession> openSessions = new ConcurrentHashMap<String, SSHSession>();
    private final Map<String, SSHSession> incompleteSessions = new ConcurrentHashMap<String, SSHSession>();
    private final Map<String, SSHSession> allSessions = new ConcurrentHashMap<String, SSHSession>();

    public SSHSessionManager(SSHHost host) {
        this.host = host;
        this.jsch = host.jsch;
    }

    private void createSession() throws JSchException {
        Session s = this.jsch.getSession(this.host.getUser(), this.host.getHost(), 22);
        SSHSession t = new SSHSession(this, s, 2);
        t.connect();
        this.openSessions.put(t.id, t);
        this.incompleteSessions.put(t.id, t);
        this.allSessions.put(t.id, t);
    }

    public SSHChannel openChannel(String type, String reason) throws JSchException {
        SSHSession[] list;
        for (SSHSession s : list = this.incompleteSessions.values().toArray(new SSHSession[0])) {
            if (s.canAddChannel()) {
                SSHChannel ch = s.openChannel(type, reason);
                if (!s.canAddChannel()) {
                    this.incompleteSessions.remove(s.id);
                }
                return ch;
            }
            this.incompleteSessions.remove(s.id);
        }
        this.createSession();
        return this.openChannel(type, reason);
    }

    public void releaseAllResources() {
        this.incompleteSessions.clear();
        for (SSHSession s : this.openSessions.values()) {
            s.releaseAllResources();
        }
        this.openSessions.clear();
        for (SSHSession s : this.allSessions.values()) {
            if (!s.isConnected()) continue;
            s.releaseAllResources();
        }
    }

    public void updateOpenSession(SSHSession session) {
        if (session.canAddChannel()) {
            this.incompleteSessions.put(session.id, session);
        }
        this.cleanEmptySessions();
    }

    public void cleanEmptySessions() {
        Object[] objects;
        int nEmptySessions = 0;
        for (Object o : objects = this.openSessions.values().toArray()) {
            SSHSession s = (SSHSession)o;
            if (!s.isEmpty() || ++nEmptySessions <= 3) continue;
            s.releaseAllResources();
            this.openSessions.remove(s.id);
            this.incompleteSessions.remove(s.id);
        }
    }

    public SSHHost getHost() {
        return this.host;
    }

    public Collection<SSHSession> getSessions() {
        return this.openSessions.values();
    }

    public Collection<SSHChannel> getAllChannels() {
        ArrayList<SSHChannel> ret = new ArrayList<SSHChannel>();
        for (SSHSession s : this.openSessions.values()) {
            ret.addAll(s.getChannels());
        }
        return ret;
    }

    public Session recreateSession() throws JSchException {
        return this.jsch.getSession(this.host.getUser(), this.host.getHost(), 22);
    }
}

