/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.util.FileOperations;
import es.bsc.compss.util.Tracer;
import es.bsc.compss.util.serializers.Serializer;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileOpsManager {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    public static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final ExecutorService HIGH_PRIORITY;
    private static final ExecutorService LOW_PRIORITY;
    private static final FileOpListener IGNORE_LISTENER;

    public static void composedOperationAsync(Runnable composition) {
        FileOpsManager.composedOperationAsync(composition, IGNORE_LISTENER);
    }

    public static void composedOperationAsync(Runnable composition, FileOpListener listener) {
        HIGH_PRIORITY.execute(composition);
    }

    public static void copyAsync(File src, File tgt) {
        FileOpsManager.copyAsync(src, tgt, IGNORE_LISTENER);
    }

    public static void copyAsync(final File src, final File tgt, final FileOpListener listener) {
        if (src != null) {
            LOW_PRIORITY.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileOpsManager.copyFile(src, tgt);
                        listener.completed();
                    }
                    catch (IOException ioe) {
                        listener.failed(ioe);
                    }
                }
            });
        }
    }

    public static void copySync(File src, File tgt) throws IOException {
        FileOpsManager.copyFile(src, tgt);
    }

    public static void copyDirAsync(File src, File tgt) {
        FileOpsManager.copyDirAsync(src, tgt, IGNORE_LISTENER);
    }

    public static void copyDirAsync(final File src, final File tgt, final FileOpListener listener) {
        if (src != null) {
            LOW_PRIORITY.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileOpsManager.copyDirectory(src, tgt);
                        listener.completed();
                    }
                    catch (IOException ioe) {
                        listener.failed(ioe);
                    }
                }
            });
        }
    }

    public static void copyDirSync(File src, File tgt) throws IOException {
        FileOpsManager.copyDirectory(src, tgt);
    }

    public static void deleteAsync(File file) {
        FileOpsManager.deleteAsync(file, IGNORE_LISTENER);
    }

    public static void deleteAsync(final File file, final FileOpListener listener) {
        if (file != null) {
            LOW_PRIORITY.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileOpsManager.deleteFile(file);
                        listener.completed();
                    }
                    catch (IOException ioe) {
                        listener.failed(ioe);
                    }
                }
            });
        }
    }

    public static void deleteSync(File file) throws IOException {
        FileOpsManager.deleteFile(file);
    }

    public static void moveAsync(File src, File tgt) {
        FileOpsManager.moveAsync(src, tgt, IGNORE_LISTENER);
    }

    public static void moveAsync(final File src, final File tgt, final FileOpListener listener) {
        if (src != null) {
            LOW_PRIORITY.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileOpsManager.moveFile(src, tgt);
                        listener.completed();
                    }
                    catch (IOException ioe) {
                        listener.failed(ioe);
                    }
                }
            });
        }
    }

    public static void moveSync(File src, File tgt) throws IOException {
        FileOpsManager.moveFile(src, tgt);
    }

    public static void moveDirAsync(File src, File tgt) {
        FileOpsManager.moveDirAsync(src, tgt, IGNORE_LISTENER);
    }

    public static void moveDirAsync(final File src, final File tgt, final FileOpListener listener) {
        if (src != null) {
            LOW_PRIORITY.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileOpsManager.moveDirectory(src, tgt);
                        listener.completed();
                    }
                    catch (IOException ioe) {
                        listener.failed(ioe);
                    }
                }
            });
        }
    }

    public static void moveDirSync(File src, File tgt) throws IOException {
        FileOpsManager.moveDirectory(src, tgt);
    }

    public static void serializeAsync(Object o, String tgt) {
        FileOpsManager.serializeAsync(o, tgt, IGNORE_LISTENER);
    }

    public static void serializeAsync(final Object o, final String tgt, final FileOpListener listener) {
        LOW_PRIORITY.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    FileOpsManager.serialize(o, tgt);
                    listener.completed();
                }
                catch (IOException ioe) {
                    listener.failed(ioe);
                }
            }
        });
    }

    public static void serializeSync(Object o, String tgt) throws IOException {
        FileOpsManager.serialize(o, tgt);
    }

    public static Object deserializeSync(String tgt) throws IOException, ClassNotFoundException {
        return FileOpsManager.deserialize(tgt);
    }

    public static void shutdown() {
        LOW_PRIORITY.shutdown();
        HIGH_PRIORITY.shutdown();
    }

    private static void serialize(Object o, String target) throws IOException {
        if (DEBUG) {
            LOGGER.debug("Serializing object to " + target);
        }
        if (Tracer.isActivated()) {
            Tracer.emitEvent(TraceEvent.LOCAL_SERIALIZE);
        }
        try {
            Serializer.serialize(o, target);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (Tracer.isActivated()) {
                Tracer.emitEventEnd(TraceEvent.LOCAL_SERIALIZE);
            }
        }
    }

    private static Object deserialize(String target) throws IOException, ClassNotFoundException {
        if (DEBUG) {
            LOGGER.debug("Serializing object to " + target);
        }
        if (Tracer.isActivated()) {
            Tracer.emitEvent(TraceEvent.LOCAL_SERIALIZE);
        }
        try {
            Object object = Serializer.deserialize(target);
            return object;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ClassNotFoundException ex) {
            throw ex;
        }
        finally {
            if (Tracer.isActivated()) {
                Tracer.emitEventEnd(TraceEvent.LOCAL_SERIALIZE);
            }
        }
    }

    private static void copyFile(File source, File target) throws IOException {
        if (DEBUG) {
            LOGGER.debug("Copying file " + source.getAbsolutePath() + " to " + target.getAbsolutePath());
        }
        if (Tracer.isActivated()) {
            Tracer.emitEvent(TraceEvent.LOCAL_COPY);
        }
        try {
            FileOperations.copyFile(source, target, LOGGER);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (Tracer.isActivated()) {
                Tracer.emitEventEnd(TraceEvent.LOCAL_COPY);
            }
        }
    }

    private static void copyDirectory(File source, File target) throws IOException {
        if (DEBUG) {
            LOGGER.debug("Copying directory " + source.getAbsolutePath() + " to " + target.getAbsolutePath());
        }
        if (Tracer.isActivated()) {
            Tracer.emitEvent(TraceEvent.LOCAL_COPY);
        }
        try {
            FileUtils.copyDirectory(source, target);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (Tracer.isActivated()) {
                Tracer.emitEventEnd(TraceEvent.LOCAL_COPY);
            }
        }
    }

    private static void deleteFile(File f) throws IOException {
        if (DEBUG) {
            LOGGER.debug("Deleting file " + f.getAbsolutePath());
        }
        if (Tracer.isActivated()) {
            Tracer.emitEvent(TraceEvent.LOCAL_DELETE);
        }
        try {
            FileOperations.deleteFile(f, LOGGER);
        }
        catch (Exception e) {
            LOGGER.error("Cannot delete file " + f.getAbsolutePath(), (Throwable)e);
            throw e;
        }
        finally {
            if (Tracer.isActivated()) {
                Tracer.emitEventEnd(TraceEvent.LOCAL_DELETE);
            }
        }
    }

    private static void moveFile(File source, File target) throws IOException {
        if (DEBUG) {
            LOGGER.debug("Moving file " + source.getAbsolutePath() + " to " + target.getAbsolutePath());
        }
        if (Tracer.isActivated()) {
            Tracer.emitEvent(TraceEvent.LOCAL_MOVE);
        }
        try {
            FileOperations.moveFile(source, target, LOGGER);
        }
        catch (DirectoryNotEmptyException dnee) {
            LOGGER.warn("WARN: Trying to move a directory as a file");
            FileOpsManager.moveDirectory(source, target);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (Tracer.isActivated()) {
                Tracer.emitEventEnd(TraceEvent.LOCAL_MOVE);
            }
        }
    }

    private static void moveDirectory(File source, File target) throws IOException {
        if (DEBUG) {
            LOGGER.debug("Moving directory " + source.getAbsolutePath() + " to " + target.getAbsolutePath());
        }
        if (Tracer.isActivated()) {
            Tracer.emitEvent(TraceEvent.LOCAL_MOVE);
        }
        try {
            FileUtils.moveDirectory(source, target);
        }
        catch (FileExistsException fee) {
            FileOpsManager.deleteFile(target);
            FileUtils.moveDirectory(source, target);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (Tracer.isActivated()) {
                Tracer.emitEventEnd(TraceEvent.LOCAL_MOVE);
            }
        }
    }

    public static void waitForOperationsToEnd() {
        LOGGER.debug("Waiting for all file  operations to end");
        final Semaphore sem = new Semaphore(0);
        LOW_PRIORITY.execute(new Runnable(){

            @Override
            public void run() {
                sem.release();
            }
        });
        HIGH_PRIORITY.execute(new Runnable(){

            @Override
            public void run() {
                sem.release();
            }
        });
        LOGGER.debug("All file  operations ended");
        sem.acquireUninterruptibly(2);
    }

    static {
        if (Tracer.isActivated()) {
            Tracer.enablePThreads(2);
        }
        LOW_PRIORITY = Executors.newSingleThreadExecutor();
        HIGH_PRIORITY = Executors.newFixedThreadPool(1);
        Future<Object> low = LOW_PRIORITY.submit(new Callable<Object>(){

            @Override
            public Object call() {
                Thread.currentThread().setPriority(1);
                Thread.currentThread().setName("Low priority FS");
                if (Tracer.isActivated()) {
                    Tracer.disablePThreads(1);
                    Tracer.emitEvent(TraceEvent.LOW_FILE_SYS_THREAD_ID);
                    Tracer.emitEvent(TraceEvent.INIT_FS);
                    Tracer.emitEventEnd(TraceEvent.INIT_FS);
                }
                return new Object();
            }
        });
        Future<Object> high = HIGH_PRIORITY.submit(new Callable<Object>(){

            @Override
            public Object call() {
                Thread.currentThread().setName("High priority FS");
                if (Tracer.isActivated()) {
                    Tracer.disablePThreads(1);
                    Tracer.emitEvent(TraceEvent.HIGH_FILE_SYS_THREAD_ID);
                    Tracer.emitEvent(TraceEvent.INIT_FS);
                    Tracer.emitEventEnd(TraceEvent.INIT_FS);
                }
                return new Object();
            }
        });
        try {
            low.get();
            high.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        IGNORE_LISTENER = new FileOpListener(){

            @Override
            public void completed() {
            }

            @Override
            public void failed(IOException e) {
            }
        };
    }

    public static interface FileOpListener {
        public void completed();

        public void failed(IOException var1);
    }
}

