/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.distrostreamlib.server.types;

import es.bsc.distrostreamlib.types.ConsumerMode;
import es.bsc.distrostreamlib.types.StreamType;
import java.util.List;

public class StreamInfo {
    private final String id;
    private final String alias;
    private final StreamType streamType;
    private final ConsumerMode accessMode;
    private final List<String> internalStreamInfo;
    private long pollTimestamp;
    private int numWriters;
    private boolean isClosed;

    public StreamInfo(String id, String alias, StreamType streamType, ConsumerMode accessMode, List<String> internalStreamInfo) {
        this.id = id;
        this.alias = alias;
        this.streamType = streamType;
        this.accessMode = accessMode;
        this.internalStreamInfo = internalStreamInfo;
        this.pollTimestamp = -1L;
        this.numWriters = 0;
        this.isClosed = false;
    }

    public String getId() {
        return this.id;
    }

    public String getAlias() {
        return this.alias;
    }

    public StreamType getStreamType() {
        return this.streamType;
    }

    public ConsumerMode getAccessMode() {
        return this.accessMode;
    }

    public List<String> getInternalStreamInfo() {
        return this.internalStreamInfo;
    }

    public void addInternalStreamInfo(String msg) {
        this.internalStreamInfo.add(msg);
    }

    public void clearInternalStreamInfo() {
        this.internalStreamInfo.clear();
    }

    public long getLastPollTimestamp() {
        return this.pollTimestamp;
    }

    public void setPollTimestamp() {
        this.pollTimestamp = System.currentTimeMillis();
    }

    public void setPollTimestamp(long timestamp) {
        this.pollTimestamp = timestamp;
    }

    public void addWriter() {
        ++this.numWriters;
    }

    public void removeWriter() {
        --this.numWriters;
    }

    public boolean hasWriters() {
        return this.numWriters > 0;
    }

    public boolean isStreamClosed() {
        return this.isClosed;
    }

    public void markAsClosed() {
        this.isClosed = true;
    }
}

