/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.annotation.adapters;

import javax.xml.bind.annotation.adapters.XmlAdapter;

public final class NormalizedStringAdapter
extends XmlAdapter<String, String> {
    @Override
    public String unmarshal(String text) {
        int i;
        if (text == null) {
            return null;
        }
        for (i = text.length() - 1; i >= 0 && !NormalizedStringAdapter.isWhiteSpaceExceptSpace(text.charAt(i)); --i) {
        }
        if (i < 0) {
            return text;
        }
        char[] buf2 = text.toCharArray();
        buf2[i--] = 32;
        while (i >= 0) {
            if (NormalizedStringAdapter.isWhiteSpaceExceptSpace(buf2[i])) {
                buf2[i] = 32;
            }
            --i;
        }
        return new String(buf2);
    }

    @Override
    public String marshal(String s) {
        return s;
    }

    protected static boolean isWhiteSpaceExceptSpace(char ch) {
        if (ch >= ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r';
    }
}

