/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.CloseableIterator;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
public class RecordBatchIterationBenchmark {
    private final Random random = new Random(0L);
    private final int batchCount = 5000;
    private final int maxBatchSize = 10;
    @Param(value={"LZ4", "SNAPPY", "NONE"})
    private CompressionType compressionType = CompressionType.NONE;
    @Param(value={"1", "2"})
    private byte messageVersion = (byte)2;
    @Param(value={"100", "1000", "10000", "100000"})
    private int messageSize = 100;
    @Param(value={"RANDOM", "ONES"})
    private Bytes bytes = Bytes.RANDOM;
    private final int startingOffset = 42;
    private ByteBuffer singleBatchBuffer;
    private ByteBuffer[] batchBuffers;
    private int[] batchSizes;
    private BufferSupplier bufferSupplier;

    @Setup
    public void init() {
        this.bufferSupplier = BufferSupplier.create();
        this.singleBatchBuffer = this.createBatch(1);
        this.batchBuffers = new ByteBuffer[5000];
        this.batchSizes = new int[5000];
        for (int i = 0; i < 5000; ++i) {
            int size = this.random.nextInt(10) + 1;
            this.batchBuffers[i] = this.createBatch(size);
            this.batchSizes[i] = size;
        }
    }

    private ByteBuffer createBatch(int batchSize) {
        byte[] value = new byte[this.messageSize];
        ByteBuffer buf = ByteBuffer.allocate(AbstractRecords.estimateSizeInBytesUpperBound((byte)this.messageVersion, (CompressionType)this.compressionType, (byte[])new byte[0], (byte[])value, (Header[])Record.EMPTY_HEADERS) * batchSize);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)this.messageVersion, (CompressionType)this.compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)42L);
        for (int i = 0; i < batchSize; ++i) {
            switch (this.bytes) {
                case ONES: {
                    Arrays.fill(value, (byte)1);
                    break;
                }
                case RANDOM: {
                    this.random.nextBytes(value);
                }
            }
            builder.append(0L, null, value);
        }
        return builder.build().buffer();
    }

    @Benchmark
    public void measureIteratorForBatchWithSingleMessage(Blackhole bh) throws IOException {
        for (RecordBatch batch : MemoryRecords.readableRecords((ByteBuffer)this.singleBatchBuffer.duplicate()).batches()) {
            CloseableIterator iterator = batch.streamingIterator(this.bufferSupplier);
            try {
                while (iterator.hasNext()) {
                    bh.consume(iterator.next());
                }
            }
            finally {
                if (iterator == null) continue;
                iterator.close();
            }
        }
    }

    @OperationsPerInvocation(value=5000)
    @Benchmark
    public void measureStreamingIteratorForVariableBatchSize(Blackhole bh) throws IOException {
        for (int i = 0; i < 5000; ++i) {
            for (RecordBatch batch : MemoryRecords.readableRecords((ByteBuffer)this.batchBuffers[i].duplicate()).batches()) {
                CloseableIterator iterator = batch.streamingIterator(this.bufferSupplier);
                try {
                    while (iterator.hasNext()) {
                        bh.consume(iterator.next());
                    }
                }
                finally {
                    if (iterator == null) continue;
                    iterator.close();
                }
            }
        }
    }

    public static enum Bytes {
        RANDOM,
        ONES;

    }
}

