/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.sftpTrilead;

import com.trilead.ssh2.SFTPv3FileAttributes;
import com.trilead.ssh2.SFTPv3FileHandle;
import java.io.IOException;
import java.util.Map;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.cpi.FileOutputStreamCpi;
import org.gridlab.gat.io.cpi.sftpTrilead.SftpTrileadConnection;
import org.gridlab.gat.io.cpi.sftpTrilead.SftpTrileadFileAdaptor;
import org.gridlab.gat.io.cpi.sftpTrilead.SftpTrileadHostVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpTrileadFileOutputStreamAdaptor
extends FileOutputStreamCpi {
    protected static Logger logger = LoggerFactory.getLogger(SftpTrileadFileOutputStreamAdaptor.class);
    private final SftpTrileadConnection connection;
    private final SFTPv3FileHandle handle;
    private long currpos = 0L;
    private boolean closed = false;

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = FileOutputStreamCpi.getSupportedCapabilities();
        capabilities.put("close", true);
        capabilities.put("flush", true);
        capabilities.put("write", true);
        return capabilities;
    }

    public static String getDescription() {
        return "The SftpTrilead FileOutputStream Adaptor implements the FileOutputStream object using the SFTP support of the trilead ssh library. Trilead ssh is an open source full java ssh library. On the server side, the 'scp' program must be in the PATH. Connections with a remote ssh server can be made by using the username + password, username + keyfile, or with only a username, depending on the client and server settings.";
    }

    public static Preferences getSupportedPreferences() {
        Preferences preferences = FileOutputStreamCpi.getSupportedPreferences();
        preferences.put("sftptrilead.strictHostKeyChecking", (Object)"false");
        preferences.put("sftptrilead.noHostKeyChecking", (Object)"true");
        preferences.put("sftptrilead.cipher.client2server", (Object)"<sftp default>");
        preferences.put("sftptrilead.cipher.server2client", (Object)"<sftp default>");
        preferences.put("sftptrilead.tcp.nodelay", (Object)"true");
        preferences.put("sftptrilead.connect.timeout", (Object)"5000");
        preferences.put("sftptrilead.kex.timeout", (Object)"5000");
        return preferences;
    }

    public static String[] getSupportedSchemes() {
        return new String[]{"sftptrilead", "sftp", "file"};
    }

    public SftpTrileadFileOutputStreamAdaptor(GATContext gatContext, URI location, Boolean append) throws GATObjectCreationException {
        super(gatContext, location, append);
        if (location.isCompatible("file") && location.refersToLocalHost()) {
            throw new GATObjectCreationException("this adaptor cannot write local files");
        }
        Preferences p = gatContext.getPreferences();
        boolean noHostKeyChecking = ((String)p.get("sftptrilead.noHostKeyChecking", (Object)"true")).equalsIgnoreCase("true");
        boolean strictHostKeyChecking = ((String)p.get("sftptrilead.strictHostKeyChecking", (Object)"false")).equalsIgnoreCase("true");
        String client2serverCipherString = (String)p.get("sftptrilead.cipher.client2server");
        String[] client2serverCiphers = client2serverCipherString == null ? null : client2serverCipherString.split(",");
        String server2clientCipherString = (String)p.get("sftptrilead.cipher.server2client");
        String[] server2clientCiphers = server2clientCipherString == null ? null : server2clientCipherString.split(",");
        boolean tcpNoDelay = ((String)p.get("sftptrilead.tcp.nodelay", (Object)"true")).equalsIgnoreCase("true");
        SftpTrileadHostVerifier verifier = new SftpTrileadHostVerifier(false, strictHostKeyChecking, noHostKeyChecking);
        try {
            this.connection = SftpTrileadFileAdaptor.getConnection(gatContext, location, verifier, client2serverCiphers, server2clientCiphers, tcpNoDelay);
        }
        catch (GATInvocationException e) {
            logger.debug("Could not create connection", (Throwable)e);
            throw new GATObjectCreationException("Could not create connection", (Throwable)e);
        }
        SFTPv3FileAttributes attributes = null;
        try {
            attributes = this.connection.sftpClient.stat(location.getPath());
        }
        catch (Throwable e) {
            logger.debug("Could not get file attributes", e);
        }
        try {
            if (append.booleanValue() && attributes != null) {
                this.handle = this.connection.sftpClient.openFileRW(location.getPath());
                this.currpos = attributes.size;
            } else {
                this.handle = this.connection.sftpClient.createFileTruncate(location.getPath());
            }
        }
        catch (IOException e) {
            logger.debug("Could not open file", (Throwable)e);
            try {
                SftpTrileadFileAdaptor.closeConnection(this.connection, gatContext.getPreferences());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new GATObjectCreationException("Could not open file", (Throwable)e);
        }
    }

    public void close() throws GATInvocationException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.connection.sftpClient.closeFile(this.handle);
            }
            catch (Throwable e1) {
                logger.debug("sftpClient.closeFile: ", e1);
            }
            try {
                SftpTrileadFileAdaptor.closeConnection(this.connection, this.gatContext.getPreferences());
            }
            catch (Throwable e) {
                logger.debug("SftpTrileadFileAdaptor.closeConnection: ", e);
            }
        }
    }

    public void flush() throws GATInvocationException {
    }

    public void write(byte[] b, int offset, int len) throws GATInvocationException {
        if (this.closed) {
            throw new GATInvocationException("SftpTrileadFileOutputStreamAdaptor: file already closed");
        }
        try {
            while (len > 0) {
                int sz = len > 32768 ? 32768 : len;
                this.connection.sftpClient.write(this.handle, this.currpos, b, offset, sz);
                len -= sz;
                offset += sz;
                this.currpos += (long)sz;
            }
        }
        catch (IOException e) {
            throw new GATInvocationException("SftpTrileadFileOutputStream", (Throwable)e);
        }
    }

    public void write(byte[] arg0) throws GATInvocationException {
        this.write(arg0, 0, arg0.length);
    }

    public void write(int arg0) throws GATInvocationException {
        byte[] b = new byte[]{(byte)arg0};
        this.write(b, 0, 1);
    }
}

