/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.agent.comm;

import es.bsc.compss.agent.comm.CommAgent;
import es.bsc.compss.agent.comm.CommAgentAdaptor;
import es.bsc.compss.agent.comm.CommAgentURI;
import es.bsc.compss.agent.comm.messages.types.CommParam;
import es.bsc.compss.agent.comm.messages.types.CommParamCollection;
import es.bsc.compss.agent.comm.messages.types.CommResult;
import es.bsc.compss.agent.comm.messages.types.CommTask;
import es.bsc.compss.agent.types.RemoteDataInformation;
import es.bsc.compss.agent.types.RemoteDataLocation;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.nio.NIOData;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOResult;
import es.bsc.compss.nio.NIOResultCollection;
import es.bsc.compss.nio.NIOTaskResult;
import es.bsc.compss.nio.NIOUri;
import es.bsc.compss.nio.master.NIOJob;
import es.bsc.compss.types.CoreElement;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.definition.MethodDefinition;
import es.bsc.compss.types.implementations.definition.MultiNodeDefinition;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.CollectiveParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.util.CoreManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class CommAgentJob
extends NIOJob {
    private CommAgent ownAgent;

    public CommAgentJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener, List<Integer> predecessors, Integer numSuccessors) {
        super(taskId, taskParams, impl, res, slaveWorkersNodeNames, listener, predecessors, numSuccessors);
    }

    public void taskFinished(boolean successful, NIOTaskResult ntr, Exception e, CommAgent ownAgent) {
        this.ownAgent = ownAgent;
        super.taskFinished(successful, ntr, e);
    }

    @Override
    public CommTask prepareJob() {
        AbstractMethodImplementation absMethodImpl = (AbstractMethodImplementation)this.impl;
        switch (absMethodImpl.getMethodType()) {
            case METHOD: {
                MethodDefinition methodImpl = (MethodDefinition)absMethodImpl.getDefinition();
                String methodName = methodImpl.getAlternativeMethodName();
                if (methodName != null && !methodName.isEmpty()) break;
                methodImpl.setAlternativeMethodName(this.taskParams.getName());
                break;
            }
            case MULTI_NODE: {
                MultiNodeDefinition multiNodeImpl = (MultiNodeDefinition)absMethodImpl.getDefinition();
                String multiNodeMethodName = multiNodeImpl.getMethodName();
                if (multiNodeMethodName != null && !multiNodeMethodName.isEmpty()) break;
                multiNodeImpl.setMethodName(this.taskParams.getName());
                break;
            }
        }
        LinkedList<NIOParam> params = this.addParams();
        int numParams = params.size() - this.taskParams.getNumReturns();
        CoreElement ce = CoreManager.getCore((int)this.impl.getCoreId());
        String ceSignature = ce.getSignature();
        CommTask nt = new CommTask(this.getLang(), DEBUG, ceSignature, absMethodImpl, this.taskParams.getParallelismSource(), this.taskParams.hasTargetObject(), this.taskParams.getNumReturns(), params, numParams, absMethodImpl.getRequirements(), this.slaveWorkersNodeNames, this.taskId, this.impl.getTaskType(), this.jobId, this.history, this.transferId, this.getOnFailure(), this.getTimeOut(), CommAgentAdaptor.LOCAL_RESOURCE);
        return nt;
    }

    private LinkedList<NIOParam> addParams() {
        LinkedList<NIOParam> params = new LinkedList<NIOParam>();
        for (Parameter param : this.taskParams.getParameters()) {
            CommParam commParam = CommAgentJob.createCommParamFromParameter(param);
            params.add(commParam);
        }
        return params;
    }

    private static CommParam createCommParamFromParameter(Parameter param) {
        CommParam commParam;
        switch (param.getType()) {
            case FILE_T: 
            case OBJECT_T: 
            case PSCO_T: 
            case STREAM_T: 
            case EXTERNAL_STREAM_T: 
            case EXTERNAL_PSCO_T: 
            case BINDING_OBJECT_T: {
                commParam = CommAgentJob.buildCommParamFromDependencyParameter((DependencyParameter)param);
                break;
            }
            case COLLECTION_T: {
                CommParam tmpCp = CommAgentJob.buildCommParamFromDependencyParameter((DependencyParameter)param);
                commParam = CommAgentJob.buildCommCollectionParamFromCommParam(tmpCp, param);
                break;
            }
            case DICT_COLLECTION_T: {
                throw new UnsupportedOperationException();
            }
            default: {
                commParam = CommAgentJob.buildCommParamFromBasicParameter((BasicTypeParameter)param);
            }
        }
        return commParam;
    }

    private static CommParam buildCommParamFromBasicParameter(BasicTypeParameter param) {
        DataType type = param.getType();
        Direction dir = param.getDirection();
        StdIOStream stdIOStream = param.getStream();
        String prefix = param.getPrefix();
        String name = param.getName();
        String pyType = param.getContentType();
        double weight = param.getWeight();
        boolean keepRename = param.isKeepRename();
        CommParam commParam = new CommParam(null, type, dir, stdIOStream, prefix, name, pyType, weight, keepRename, null);
        commParam.setValue(param.getValue());
        return commParam;
    }

    private static CommParam buildCommParamFromDependencyParameter(DependencyParameter dPar) {
        String dataMgmtId;
        String renaming = null;
        DataAccessId dAccId = dPar.getDataAccessId();
        if (dAccId instanceof RWAccessId) {
            RWAccessId rwaId = (RWAccessId)dAccId;
            renaming = rwaId.getReadDataInstance().getRenaming();
            dataMgmtId = rwaId.getWrittenDataInstance().getRenaming();
        } else if (dAccId instanceof RAccessId) {
            RAccessId raId = (RAccessId)dAccId;
            dataMgmtId = renaming = raId.getReadDataInstance().getRenaming();
        } else {
            WAccessId waId = (WAccessId)dAccId;
            dataMgmtId = waId.getWrittenDataInstance().getRenaming();
        }
        LogicalData sourceDataLD = null;
        String pscoId = null;
        if (renaming != null) {
            sourceDataLD = Comm.getData((String)renaming);
            pscoId = sourceDataLD.getPscoId();
        }
        if (pscoId != null) {
            if (dPar.getType().equals((Object)DataType.OBJECT_T)) {
                dPar.setType(DataType.PSCO_T);
            } else if (dPar.getType().equals((Object)DataType.FILE_T)) {
                dPar.setType(DataType.EXTERNAL_PSCO_T);
            }
        }
        DataType type = dPar.getType();
        Direction dir = dPar.getDirection();
        StdIOStream stdIOStream = dPar.getStream();
        String prefix = dPar.getPrefix();
        String name = dPar.getName();
        String pyType = dPar.getContentType();
        double weight = dPar.getWeight();
        boolean keepRename = dPar.isKeepRename();
        CommParam commParam = new CommParam(dataMgmtId, type, dir, stdIOStream, prefix, name, pyType, weight, keepRename, dPar.getOriginalName());
        commParam.setValue(dPar.getOriginalName());
        NIOData sourceData = (NIOData)dPar.getDataSource();
        if (sourceData != null) {
            RemoteDataInformation remoteData = new RemoteDataInformation(renaming);
            for (NIOUri uri : sourceData.getSources()) {
                CommAgentURI caURI;
                if (uri instanceof CommAgentURI) {
                    caURI = (CommAgentURI)uri;
                    remoteData.addSource(new RemoteDataLocation(caURI.getAgent(), uri.getPath()));
                    continue;
                }
                caURI = new CommAgentURI(uri);
                remoteData.addSource(new RemoteDataLocation(caURI.getAgent(), uri.getPath()));
            }
            commParam.setRemoteData(remoteData);
        }
        return commParam;
    }

    private static CommParam buildCommCollectionParamFromCommParam(CommParam commPar, Parameter param) {
        CommParamCollection npc = new CommParamCollection(commPar);
        CollectiveParameter collParam = (CollectiveParameter)param;
        for (Parameter subParam : collParam.getElements()) {
            npc.addParameter(CommAgentJob.createCommParamFromParameter(subParam));
        }
        return npc;
    }

    @Override
    protected void registerResult(Parameter param, NIOResult result) {
        if (!param.isPotentialDependency()) {
            return;
        }
        DependencyParameter dp = (DependencyParameter)param;
        String rename = this.getOutputRename((Parameter)dp);
        if (dp.isCollective()) {
            CollectiveParameter colParam = (CollectiveParameter)param;
            NIOResultCollection colResult = (NIOResultCollection)result;
            List<NIOResult> taskResults = colResult.getElements();
            List taskParams = colParam.getElements();
            Iterator taskParamsItr = taskParams.iterator();
            Iterator<NIOResult> taskResultItr = taskResults.iterator();
            while (taskParamsItr.hasNext()) {
                Parameter elemParam = (Parameter)taskParamsItr.next();
                NIOResult elemResult = taskResultItr.next();
                this.registerResult(elemParam, elemResult);
            }
        } else if (rename != null) {
            CommResult commResult = (CommResult)result;
            Collection<RemoteDataLocation> dataLocations = commResult.getLocations();
            for (RemoteDataLocation location : dataLocations) {
                if (location == null) continue;
                Resource w = this.ownAgent.getNodeFromLocation(location);
                if (w == null) {
                    w = this.worker;
                }
                LOGGER.debug("Registering result " + rename + " comming from worker " + w.getName());
                this.registerResultLocation(location.getPath(), rename, w);
            }
            this.notifyResultAvailability(dp, rename);
        }
    }
}

