/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.internals.CacheFunction;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;

class FilteredCacheIterator
implements PeekingKeyValueIterator<Bytes, LRUCacheEntry> {
    private final PeekingKeyValueIterator<Bytes, LRUCacheEntry> cacheIterator;
    private final HasNextCondition hasNextCondition;
    private final PeekingKeyValueIterator<Bytes, LRUCacheEntry> wrappedIterator;

    FilteredCacheIterator(final PeekingKeyValueIterator<Bytes, LRUCacheEntry> cacheIterator, HasNextCondition hasNextCondition, final CacheFunction cacheFunction) {
        this.cacheIterator = cacheIterator;
        this.hasNextCondition = hasNextCondition;
        this.wrappedIterator = new PeekingKeyValueIterator<Bytes, LRUCacheEntry>(){

            @Override
            public KeyValue<Bytes, LRUCacheEntry> peekNext() {
                return this.cachedPair(cacheIterator.peekNext());
            }

            @Override
            public void close() {
                cacheIterator.close();
            }

            @Override
            public Bytes peekNextKey() {
                return cacheFunction.key((Bytes)cacheIterator.peekNextKey());
            }

            @Override
            public boolean hasNext() {
                return cacheIterator.hasNext();
            }

            @Override
            public KeyValue<Bytes, LRUCacheEntry> next() {
                return this.cachedPair((KeyValue)cacheIterator.next());
            }

            private KeyValue<Bytes, LRUCacheEntry> cachedPair(KeyValue<Bytes, LRUCacheEntry> next) {
                return KeyValue.pair(cacheFunction.key((Bytes)next.key), (LRUCacheEntry)next.value);
            }

            @Override
            public void remove() {
                cacheIterator.remove();
            }
        };
    }

    @Override
    public void close() {
    }

    @Override
    public Bytes peekNextKey() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (Bytes)this.cacheIterator.peekNextKey();
    }

    @Override
    public boolean hasNext() {
        return this.hasNextCondition.hasNext(this.wrappedIterator);
    }

    @Override
    public KeyValue<Bytes, LRUCacheEntry> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (KeyValue)this.cacheIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public KeyValue<Bytes, LRUCacheEntry> peekNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.cacheIterator.peekNext();
    }
}

