/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.WindowKeySchema;

class WindowStoreIteratorWrapper {
    private final KeyValueIterator<Bytes, byte[]> bytesIterator;
    private final long windowSize;

    WindowStoreIteratorWrapper(KeyValueIterator<Bytes, byte[]> bytesIterator, long windowSize) {
        this.bytesIterator = bytesIterator;
        this.windowSize = windowSize;
    }

    public WindowStoreIterator<byte[]> valuesIterator() {
        return new WrappedWindowStoreIterator(this.bytesIterator);
    }

    public KeyValueIterator<Windowed<Bytes>, byte[]> keyValueIterator() {
        return new WrappedKeyValueIterator(this.bytesIterator, this.windowSize);
    }

    private static class WrappedKeyValueIterator
    implements KeyValueIterator<Windowed<Bytes>, byte[]> {
        final KeyValueIterator<Bytes, byte[]> bytesIterator;
        final long windowSize;

        WrappedKeyValueIterator(KeyValueIterator<Bytes, byte[]> bytesIterator, long windowSize) {
            this.bytesIterator = bytesIterator;
            this.windowSize = windowSize;
        }

        @Override
        public Windowed<Bytes> peekNextKey() {
            byte[] nextKey = this.bytesIterator.peekNextKey().get();
            return WindowKeySchema.fromStoreBytesKey(nextKey, this.windowSize);
        }

        @Override
        public boolean hasNext() {
            return this.bytesIterator.hasNext();
        }

        @Override
        public KeyValue<Windowed<Bytes>, byte[]> next() {
            KeyValue next = (KeyValue)this.bytesIterator.next();
            return KeyValue.pair(WindowKeySchema.fromStoreBytesKey(((Bytes)next.key).get(), this.windowSize), (byte[])next.value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported in " + this.getClass().getName());
        }

        @Override
        public void close() {
            this.bytesIterator.close();
        }
    }

    private static class WrappedWindowStoreIterator
    implements WindowStoreIterator<byte[]> {
        final KeyValueIterator<Bytes, byte[]> bytesIterator;

        WrappedWindowStoreIterator(KeyValueIterator<Bytes, byte[]> bytesIterator) {
            this.bytesIterator = bytesIterator;
        }

        @Override
        public Long peekNextKey() {
            return WindowKeySchema.extractStoreTimestamp(this.bytesIterator.peekNextKey().get());
        }

        @Override
        public boolean hasNext() {
            return this.bytesIterator.hasNext();
        }

        @Override
        public KeyValue<Long, byte[]> next() {
            KeyValue next = (KeyValue)this.bytesIterator.next();
            long timestamp = WindowKeySchema.extractStoreTimestamp(((Bytes)next.key).get());
            return KeyValue.pair(timestamp, (byte[])next.value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported in " + this.getClass().getName());
        }

        @Override
        public void close() {
            this.bytesIterator.close();
        }
    }
}

