/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import kafka.coordinator.transaction.TxnKey;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.message.UncompressedCodec$;
import kafka.server.FetchDataInfo;
import kafka.server.ReplicaManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t\u0005w!B\u001a5\u0011\u0003Yd!B\u001f5\u0011\u0003q\u0004\"B#\u0002\t\u00031\u0005bB$\u0002\u0005\u0004%\t\u0001\u0013\u0005\u0007\u0019\u0006\u0001\u000b\u0011B%\t\u000f5\u000b!\u0019!C\u0001\u0011\"1a*\u0001Q\u0001\n%CqaT\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004Q\u0003\u0001\u0006I!\u0013\u0005\b#\u0006\u0011\r\u0011\"\u0001I\u0011\u0019\u0011\u0016\u0001)A\u0005\u0013\u001a!Q\b\u000e\u0001T\u0011!Q6B!A!\u0002\u0013I\u0005\u0002C.\f\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011\t\\!\u0011!Q\u0001\n\rD\u0001BZ\u0006\u0003\u0002\u0003\u0006Ia\u001a\u0005\t[.\u0011\t\u0011)A\u0005]\"A\u0011o\u0003B\u0001B\u0003%!\u000fC\u0003F\u0017\u0011\u0005a0\u0002\u0004\u0002\u000e-\u0001\u0011q\u0002\u0005\n\u0003\u0013Z!\u0019!C\u0005\u0003\u0017B\u0001\"!\u001a\fA\u0003%\u0011Q\n\u0005\n\u0003OZ!\u0019!C\u0005\u0003SB\u0001\"a\u001e\fA\u0003%\u00111\u000e\u0005\n\u0003sZ!\u0019!C\u0005\u0003wB\u0001\"a%\fA\u0003%\u0011Q\u0010\u0005\n\u0003+[!\u0019!C\u0005\u0003wB\u0001\"a&\fA\u0003%\u0011Q\u0010\u0005\n\u00033[!\u0019!C\u0005\u00037C\u0001\"!+\fA\u0003%\u0011Q\u0014\u0005\t\u0003W[!\u0019!C\u0005\u0011\"9\u0011QV\u0006!\u0002\u0013I\u0005\u0002CAX\u0017\u0011\u0005A'!-\t\u0011\u0005m6\u0002\"\u00015\u0003{Cq!a3\f\t\u0003\ti\rC\u0004\u0002h.!\t!!;\t\u000f\u0005-8\u0002\"\u0001\u0002n\"9!\u0011C\u0006\u0005\u0002\tM\u0001b\u0002B\u000f\u0017\u0011%!q\u0004\u0005\b\u0005SYA\u0011\u0001B\u0016\u0011\u001d\u00119d\u0003C\u0001\u0005sAqAa\u0011\f\t\u0003\u0011)\u0005\u0003\u0004\u0003J-!I\u0001\u0013\u0005\b\u0005\u0017ZA\u0011\u0002B'\u0011!\u0011\u0019g\u0003C\u0001i\t\u0015\u0004b\u0002B9\u0017\u0011\u0005!1\u000f\u0005\b\u0005\u0003[A\u0011\u0001BB\u0011\u001d\u0011Ii\u0003C\u0005\u0003SDqAa#\f\t\u0003\u0011i\tC\u0005\u0003(.\t\n\u0011\"\u0001\u0003*\"9!qX\u0006\u0005\u0002\u0005%\u0018a\u0006+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0015\t)d'A\u0006ue\u0006t7/Y2uS>t'BA\u001c9\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003e\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002=\u00035\tAGA\fUe\u0006t7/Y2uS>t7\u000b^1uK6\u000bg.Y4feN\u0011\u0011a\u0010\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Y\u0014a\b#fM\u0006,H\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\u001cX*\u0019=US6,w.\u001e;NgV\t\u0011\n\u0005\u0002A\u0015&\u00111*\u0011\u0002\u0004\u0013:$\u0018\u0001\t#fM\u0006,H\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\u001cX*\u0019=US6,w.\u001e;Ng\u0002\n!\u0005R3gCVdG\u000f\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ#ya&\u0014\u0018\r^5p]6\u001b\u0018a\t#fM\u0006,H\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\fG.\u00133FqBL'/\u0019;j_:l5\u000fI\u0001+\t\u00164\u0017-\u001e7u\u0003\n|'\u000f\u001e+j[\u0016$w*\u001e;Ue\u0006t7/Y2uS>t7/\u00138uKJ4\u0018\r\\'t\u0003-\"UMZ1vYR\f%m\u001c:u)&lW\rZ(viR\u0013\u0018M\\:bGRLwN\\:J]R,'O^1m\u001bN\u0004\u0013A\f#fM\u0006,H\u000e\u001e*f[>4X-\u0012=qSJ,G\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:J]R,'O^1m\u001bN\fq\u0006R3gCVdGOU3n_Z,W\t\u001f9je\u0016$GK]1og\u0006\u001cG/[8oC2LEm]%oi\u0016\u0014h/\u00197Ng\u0002\u001a2aC U!\t)\u0006,D\u0001W\u0015\t9\u0006(A\u0003vi&d7/\u0003\u0002Z-\n9Aj\\4hS:<\u0017\u0001\u00032s_.,'/\u00133\u0002\u0011i\\7\t\\5f]R\u0004\"!\u00181\u000e\u0003yS!a\u0018\u001d\u0002\u0005i\\\u0017BA1_\u00055Y\u0015MZ6b5.\u001cE.[3oi\u0006I1o\u00195fIVdWM\u001d\t\u0003+\u0012L!!\u001a,\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0003Q.l\u0011!\u001b\u0006\u0003Ub\naa]3sm\u0016\u0014\u0018B\u00017j\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\faaY8oM&<\u0007C\u0001\u001fp\u0013\t\u0001HGA\tUe\u0006t7/Y2uS>t7i\u001c8gS\u001e\fA\u0001^5nKB\u00111\u000f`\u0007\u0002i*\u0011q+\u001e\u0006\u0003m^\faaY8n[>t'BA\u001dy\u0015\tI(0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002w\u0006\u0019qN]4\n\u0005u$(\u0001\u0002+j[\u0016$Rb`A\u0001\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0001C\u0001\u001f\f\u0011\u0015Q&\u00031\u0001J\u0011\u0015Y&\u00031\u0001]\u0011\u0015\u0011'\u00031\u0001d\u0011\u00151'\u00031\u0001h\u0011\u0015i'\u00031\u0001o\u0011\u0015\t(\u00031\u0001s\u0005Y\u0019VM\u001c3Uq:l\u0015M]6feN\u001c\u0015\r\u001c7cC\u000e\\\u0007C\u0004!\u0002\u0012\u0005U\u0011*a\u000b\u00028\u0005u\u00121I\u0005\u0004\u0003'\t%!\u0003$v]\u000e$\u0018n\u001c86!\u0011\t9\"!\n\u000f\t\u0005e\u0011\u0011\u0005\t\u0004\u00037\tUBAA\u000f\u0015\r\tyBO\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\r\u0012)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\tIC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003G\t\u0005\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005ER/\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t)$a\f\u0003#Q\u0013\u0018M\\:bGRLwN\u001c*fgVdG\u000fE\u0002=\u0003sI1!a\u000f5\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b!\ra\u0014qH\u0005\u0004\u0003\u0003\"$A\u0005+y]R\u0013\u0018M\\:ji6+G/\u00193bi\u0006\u00042\u0001QA#\u0013\r\t9%\u0011\u0002\u0005+:LG/\u0001\u0007tQV$H/\u001b8h\t><h.\u0006\u0002\u0002NA!\u0011qJA1\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013AB1u_6L7M\u0003\u0003\u0002X\u0005e\u0013AC2p]\u000e,(O]3oi*!\u00111LA/\u0003\u0011)H/\u001b7\u000b\u0005\u0005}\u0013\u0001\u00026bm\u0006LA!a\u0019\u0002R\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\fQb\u001d5viRLgn\u001a#po:\u0004\u0013!C:uCR,Gj\\2l+\t\tY\u0007\u0005\u0003\u0002n\u0005MTBAA8\u0015\u0011\t\t(!\u0016\u0002\u000b1|7m[:\n\t\u0005U\u0014q\u000e\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\u0006Q1\u000f^1uK2{7m\u001b\u0011\u0002#1|\u0017\rZ5oOB\u000b'\u000f^5uS>t7/\u0006\u0002\u0002~A1\u0011qPAE\u0003\u001bk!!!!\u000b\t\u0005\r\u0015QQ\u0001\b[V$\u0018M\u00197f\u0015\r\t9)Q\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAF\u0003\u0003\u00131aU3u!\ra\u0014qR\u0005\u0004\u0003##$A\t+sC:\u001c\u0018m\u0019;j_:\u0004\u0016M\u001d;ji&|g.\u00118e\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.\u0001\nm_\u0006$\u0017N\\4QCJ$\u0018\u000e^5p]N\u0004\u0013!\u00057fCZLgn\u001a)beRLG/[8og\u0006\u0011B.Z1wS:<\u0007+\u0019:uSRLwN\\:!\u0003a!(/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003;\u0003r!a \u0002 &\u000b\u0019+\u0003\u0003\u0002\"\u0006\u0005%aA'baB\u0019A(!*\n\u0007\u0005\u001dFGA\u000bUq:lU\r^1eCR\f7)Y2iK\u0016sGO]=\u00023Q\u0014\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1DC\u000eDW\rI\u0001\u001fiJ\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]R\fq\u0004\u001e:b]N\f7\r^5p]R{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;!\u0003M\tG\r\u001a'pC\u0012Lgn\u001a)beRLG/[8o)\u0019\t\u0019%a-\u00028\"1\u0011Q\u0017\u0011A\u0002%\u000b1\u0002]1si&$\u0018n\u001c8JI\"1\u0011\u0011\u0018\u0011A\u0002%\u000b\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\u0002\u001bM$\u0018\r^3SK\u0006$Gj\\2l+\t\ty\f\u0005\u0003\u0002B\u0006\u001dWBAAb\u0015\u0011\t)-a\u001c\u0002-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.LA!!3\u0002D\nA!+Z1e\u0019>\u001c7.\u0001\u000buS6,GmT;u)J\fgn]1di&|gn\u001d\u000b\u0003\u0003\u001f\u0004b!!5\u0002\\\u0006\u0005h\u0002BAj\u0003/tA!a\u0007\u0002V&\t!)C\u0002\u0002Z\u0006\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002^\u0006}'\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005e\u0017\tE\u0002=\u0003GL1!!:5\u0005\u0005\"&/\u00198tC\u000e$\u0018n\u001c8bY&#\u0017I\u001c3Qe>$WoY3s\u0013\u0012,\u0005o\\2i\u0003})g.\u00192mKR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0005\u0010]5sCRLwN\u001c\u000b\u0003\u0003\u0007\n1cZ3u)J\fgn]1di&|gn\u0015;bi\u0016$B!a<\u0003\u000eAA\u0011\u0011[Ay\u0003k\u0014\t!\u0003\u0003\u0002t\u0006}'AB#ji\",'\u000f\u0005\u0003\u0002x\u0006uXBAA}\u0015\r\tY0^\u0001\taJ|Go\\2pY&!\u0011q`A}\u0005\u0019)%O]8sgB)\u0001Ia\u0001\u0003\b%\u0019!QA!\u0003\r=\u0003H/[8o!\ra$\u0011B\u0005\u0004\u0005\u0017!$AH\"p_J$\u0017N\\1u_J,\u0005o\\2i\u0003:$G\u000b\u001f8NKR\fG-\u0019;b\u0011\u001d\u0011y\u0001\na\u0001\u0003+\tq\u0002\u001e:b]N\f7\r^5p]\u0006d\u0017\nZ\u0001\u001faV$HK]1og\u0006\u001cG/[8o'R\fG/Z%g\u001d>$X\t_5tiN$bA!\u0006\u0003\u0018\te\u0001\u0003CAi\u0003c\f)Pa\u0002\t\u000f\t=Q\u00051\u0001\u0002\u0016!9!1D\u0013A\u0002\u0005]\u0012a\u0003;y]6+G/\u00193bi\u0006\fadZ3u\u0003:$W*Y=cK\u0006#G\r\u0016:b]N\f7\r^5p]N#\u0018\r^3\u0015\r\u0005=(\u0011\u0005B\u0012\u0011\u001d\u0011yA\na\u0001\u0003+AqA!\n'\u0001\u0004\u00119#A\u000bde\u0016\fG/\u001a3Uq:lU\r^1eCR\fw\n\u001d;\u0011\u000b\u0001\u0013\u0019!a\u000e\u00029Y\fG.\u001b3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;NgR!!Q\u0006B\u001a!\r\u0001%qF\u0005\u0004\u0005c\t%a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0005k9\u0003\u0019A%\u0002\u0019QDh\u000eV5nK>,H/T:\u0002/Q\u0014\u0018M\\:bGRLwN\u001c+pa&\u001c7i\u001c8gS\u001e\u001cXC\u0001B\u001e!\u0011\u0011iDa\u0010\u000e\u0005\u0005e\u0013\u0002\u0002B!\u00033\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u00031\u0001\u0018M\u001d;ji&|gNR8s)\rI%q\t\u0005\b\u0005\u001fI\u0003\u0019AA\u000b\u0003\u0005:W\r\u001e+sC:\u001c\u0018m\u0019;j_:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u\u0003]aw.\u00193Ue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\u0006\u0004\u0003P\tU#\u0011\r\t\b+\nE\u0013QCA\u001c\u0013\r\u0011\u0019F\u0016\u0002\u0005!>|G\u000eC\u0004\u0003X-\u0002\rA!\u0017\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!!1\fB/\u001b\u0005)\u0018b\u0001B0k\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BBA]W\u0001\u0007\u0011*\u0001\u000fbI\u0012du.\u00193fIR\u0013\u0018M\\:bGRLwN\\:U_\u000e\u000b7\r[3\u0015\u0011\u0005\r#q\rB6\u0005[BaA!\u001b-\u0001\u0004I\u0015!\u0005;y]R{\u0007/[2QCJ$\u0018\u000e^5p]\"1\u0011\u0011\u0018\u0017A\u0002%CqAa\u001c-\u0001\u0004\u0011y%\u0001\u000enKR\fG-\u0019;b!\u0016\u0014HK]1og\u0006\u001cG/[8oC2LE-\u0001\u0013m_\u0006$GK]1og\u0006\u001cG/[8og\u001a{'\u000f\u0016=o)>\u0004\u0018n\u0019)beRLG/[8o)!\t\u0019E!\u001e\u0003x\te\u0004BBA[[\u0001\u0007\u0011\n\u0003\u0004\u0002:6\u0002\r!\u0013\u0005\b\u0005wj\u0003\u0019\u0001B?\u00039\u0019XM\u001c3Uq:l\u0015M]6feN\u00042Aa \u0014\u001b\u0005Y\u0011A\n:f[>4X\r\u0016:b]N\f7\r^5p]N4uN\u001d+y]R{\u0007/[2QCJ$\u0018\u000e^5p]R1\u00111\tBC\u0005\u000fCa!!./\u0001\u0004I\u0005BBA]]\u0001\u0007\u0011*\u0001\u0018wC2LG-\u0019;f)J\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]RL5o\u0015;bE2,\u0017AF1qa\u0016tG\r\u0016:b]N\f7\r^5p]R{Gj\\4\u0015\u0019\u0005\r#q\u0012BI\u0005'\u00139J!)\t\u000f\t=\u0001\u00071\u0001\u0002\u0016!1\u0011\u0011\u0018\u0019A\u0002%CqA!&1\u0001\u0004\ti$A\u0006oK^lU\r^1eCR\f\u0007b\u0002BMa\u0001\u0007!1T\u0001\u0011e\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004r\u0001\u0011BO\u0003k\f\u0019%C\u0002\u0003 \u0006\u0013\u0011BR;oGRLwN\\\u0019\t\u0013\t\r\u0006\u0007%AA\u0002\t\u0015\u0016\u0001\u0004:fiJLxJ\\#se>\u0014\bc\u0002!\u0003\u001e\u0006U(QF\u0001!CB\u0004XM\u001c3Ue\u0006t7/Y2uS>tGk\u001c'pO\u0012\"WMZ1vYR$S'\u0006\u0002\u0003,*\"!Q\u0015BWW\t\u0011y\u000b\u0005\u0003\u00032\nmVB\u0001BZ\u0015\u0011\u0011)La.\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B]\u0003\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tu&1\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001C:ikR$wn\u001e8")
public class TransactionStateManager
implements Logging {
    private final KafkaZkClient zkClient;
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TransactionConfig config;
    private final Time time;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final Set<TransactionPartitionAndLeaderEpoch> leavingPartitions;
    private final scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private final int transactionTopicPartitionCount;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int DefaultRemoveExpiredTransactionalIdsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
    }

    public static int DefaultAbortTimedOutTransactionsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
    }

    public static int DefaultTransactionalIdExpirationMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
    }

    public static int DefaultTransactionsMaxTimeoutMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TransactionStateManager transactionStateManager = this;
        synchronized (transactionStateManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ReentrantReadWriteLock stateLock() {
        return this.stateLock;
    }

    private Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    private Set<TransactionPartitionAndLeaderEpoch> leavingPartitions() {
        return this.leavingPartitions;
    }

    private scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.leavingPartitions().remove((Object)partitionAndLeaderEpoch);
            return this.loadingPartitions().add((Object)partitionAndLeaderEpoch);
        });
    }

    public ReentrantReadWriteLock.ReadLock stateReadLock() {
        return this.stateLock().readLock();
    }

    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        long now = this.time.milliseconds();
        return (Iterable)CoreUtils$.MODULE$.inReadLock(this.stateLock(), (Function0 & Serializable & scala.Serializable)() -> (Iterable)((TraversableLike)this.transactionMetadataCache().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$2(this, x0$1)))).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TxnMetadataCacheEntry entry = (TxnMetadataCacheEntry)tuple2._2();
            Iterable iterable = (Iterable)((TraversableLike)entry.metadataPerTransactionalId().filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$5(now, x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String txnId = (String)tuple2._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
                TransactionalIdAndProducerIdEpoch transactionalIdAndProducerIdEpoch = new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                return transactionalIdAndProducerIdEpoch;
            }, Iterable$.MODULE$.canBuildFrom());
            return iterable;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom()));
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long now = $this.time.milliseconds();
            CoreUtils$.MODULE$.inReadLock(this.stateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                scala.collection.immutable.Map transactionalIdByPartition = ((TraversableLike)this.transactionMetadataCache().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TxnMetadataCacheEntry entry = (TxnMetadataCacheEntry)tuple2._2();
                    Iterable iterable = (Iterable)((TraversableLike)((TraversableLike)entry.metadataPerTransactionalId().filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$enableTransactionalIdExpiration$4(x0$2)))).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$enableTransactionalIdExpiration$5(this, now, x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                        Tuple2 tuple2 = x0$4;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String transactionalId = (String)tuple2._1();
                        TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
                        TxnTransitMetadata txnMetadataTransition = (TxnTransitMetadata)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> txnMetadata.prepareDead());
                        TransactionalIdCoordinatorEpochAndMetadata transactionalIdCoordinatorEpochAndMetadata = new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, entry.coordinatorEpoch(), txnMetadataTransition);
                        return transactionalIdCoordinatorEpochAndMetadata;
                    }, Iterable$.MODULE$.canBuildFrom());
                    return iterable;
                }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)transactionalIdCoordinatorEpochAndMetadata -> BoxesRunTime.boxToInteger((int)this.partitionFor(transactionalIdCoordinatorEpochAndMetadata.transactionalId())));
                scala.collection.immutable.Map recordsPerPartition = (scala.collection.immutable.Map)transactionalIdByPartition.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                    Tuple2 tuple2 = x0$5;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    int partition = tuple2._1$mcI$sp();
                    scala.collection.mutable.Iterable transactionalIdCoordinatorEpochAndMetadatas = (scala.collection.mutable.Iterable)tuple2._2();
                    SimpleRecord[] deletes = (SimpleRecord[])((TraversableOnce)transactionalIdCoordinatorEpochAndMetadatas.map((Function1 & Serializable & scala.Serializable)entry -> new SimpleRecord(now, TransactionLog$.MODULE$.keyToBytes(entry.transactionalId()), null), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
                    MemoryRecords records = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])deletes);
                    TopicPartition topicPartition = new TopicPartition("__transaction_state", partition);
                    Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)records);
                    return tuple22;
                }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                $this.replicaManager.appendRecords($this.config.requestTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, false, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responses -> {
                    this.removeFromCacheCallback$1(responses, transactionalIdByPartition);
                    return BoxedUnit.UNIT;
                }, (Option<Lock>)new Some((Object)this.stateLock().readLock()), $this.replicaManager.appendRecords$default$8());
            });
        }, this.config.removeExpiredTransactionalIdsIntervalMs(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.scheduler.schedule$default$5());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)None$.MODULE$);
    }

    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(String transactionalId, TransactionMetadata txnMetadata) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)new Some((Object)txnMetadata)).right().map((Function1 & Serializable & scala.Serializable)x$2 -> (CoordinatorEpochAndTxnMetadata)x$2.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(61).append("Unexpected empty transaction metadata returned while putting ").append(txnMetadata).toString());
        }));
    }

    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        return (Either)CoreUtils$.MODULE$.inReadLock(this.stateLock(), (Function0 & Serializable & scala.Serializable)() -> {
            Left left;
            int partitionId = this.partitionFor(transactionalId);
            if (this.loadingPartitions().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$3)))) {
                left = package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
            } else if (this.leavingPartitions().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$3(partitionId, x$4)))) {
                left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
            } else {
                Left left2;
                Option option = this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)some.value();
                    Option txnMetadata = Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().get(transactionalId)).orElse((Function0 & Serializable & scala.Serializable)() -> createdTxnMetadataOpt.map((Function1 & Serializable & scala.Serializable)createdTxnMetadata -> (TransactionMetadata)Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().putIfNotExists(transactionalId, (TransactionMetadata)createdTxnMetadata)).getOrElse((Function0 & Serializable & scala.Serializable)() -> createdTxnMetadata)));
                    left2 = package$.MODULE$.Right().apply((Object)txnMetadata.map((Function1 & Serializable & scala.Serializable)x$5 -> new CoordinatorEpochAndTxnMetadata(cacheEntry.coordinatorEpoch(), (TransactionMetadata)x$5)));
                } else if (None$.MODULE$.equals(option)) {
                    left2 = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                } else {
                    throw new MatchError((Object)option);
                }
                left = left2;
            }
            return left;
        });
    }

    public boolean validateTransactionTimeoutMs(int txnTimeoutMs) {
        return txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    /*
     * WARNING - void declaration
     */
    public Properties transactionTopicConfigs() {
        void var1_1;
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        props.put(LogConfig$.MODULE$.CompressionTypeProp(), UncompressedCodec$.MODULE$.name());
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)this.config.transactionLogMinInsyncReplicas())).toString());
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.config.transactionLogSegmentBytes())).toString());
        return var1_1;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs((int)transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    private int getTransactionTopicPartitionCount() {
        return BoxesRunTime.unboxToInt((Object)this.zkClient.getTopicPartitionCount("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.config.transactionLogNumPartitions()));
    }

    private Pool<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        long startMs = this.time.milliseconds();
        Pool<String, TransactionMetadata> loadedTransactions = new Pool<String, TransactionMetadata>((Option<Function1<String, TransactionMetadata>>)Pool$.MODULE$.$lessinit$greater$default$1());
        Option<Log> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Attempted to load transaction metadata from ").append(topicPartition).append(", but found no log").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            Log log = (Log)some.value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            LongRef currOffset = LongRef.create((long)log.logStartOffset());
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && !this.shuttingDown().get() && BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.loadingPartitions().exists((Function1 & Serializable & scala.Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition, coordinatorEpoch, idAndEpoch)))))) {
                    MemoryRecords memoryRecords;
                    FetchDataInfo fetchDataInfo = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), (Option<Object>)None$.MODULE$, true, false);
                    Records records = fetchDataInfo.records();
                    if (records instanceof MemoryRecords) {
                        MemoryRecords memoryRecords2;
                        memoryRecords = memoryRecords2 = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        ByteBuffer byteBuffer;
                        FileRecords fileRecords = (FileRecords)records;
                        int sizeInBytes = fileRecords.sizeInBytes();
                        int bytesNeeded = Math.max(this.config.transactionLogLoadBufferSize(), sizeInBytes);
                        if (buffer.capacity() < bytesNeeded) {
                            if (this.config.transactionLogLoadBufferSize() < bytesNeeded) {
                                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Loaded transaction metadata from ").append(topicPartition).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").append(new StringBuilder(58).append("configured transaction.state.log.load.buffer.size (").append($this.config.transactionLogLoadBufferSize()).append(" bytes)").toString()).toString());
                            }
                            buffer = ByteBuffer.allocate(bytesNeeded);
                            byteBuffer = BoxedUnit.UNIT;
                        } else {
                            byteBuffer = buffer.clear();
                        }
                        buffer.clear();
                        fileRecords.readInto(buffer, 0);
                        memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                    } else {
                        throw new MatchError((Object)records);
                    }
                    MemoryRecords memRecords = memoryRecords;
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(memRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                        TransactionStateManager.$anonfun$loadTransactionMetadata$6(loadedTransactions, currOffset, batch);
                        return BoxedUnit.UNIT;
                    });
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Finished loading ").append(loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition).append(" in ").append($this.time.milliseconds() - startMs).append(" milliseconds").toString());
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Error loading transactions from transaction log ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, Pool<String, TransactionMetadata> metadataPerTransactionalId) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, metadataPerTransactionalId);
        Option currentTxnMetadataCacheEntry = this.transactionMetadataCache().put((Object)BoxesRunTime.boxToInteger((int)txnTopicPartition), (Object)txnMetadataCacheEntry);
        if (currentTxnMetadataCacheEntry.isDefined()) {
            int coordinatorEpoch2 = ((TxnMetadataCacheEntry)currentTxnMetadataCacheEntry.get()).coordinatorEpoch();
            Pool<String, TransactionMetadata> metadataPerTxnId = ((TxnMetadataCacheEntry)currentTxnMetadataCacheEntry.get()).metadataPerTransactionalId();
            String errorMsg = new StringBuilder(90).append("The metadata cache for txn partition ").append(txnTopicPartition).append(" has already exist with epoch ").append(coordinatorEpoch2).append(" ").append(new StringBuilder(40).append("and ").append(metadataPerTxnId.size()).append(" entries while trying to add to it; ").toString()).append("this should not happen").toString();
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
    }

    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function5<String, Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        this.validateTransactionTopicPartitionCountIsStable();
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.leavingPartitions().remove((Object)partitionAndLeaderEpoch);
            return this.loadingPartitions().add((Object)partitionAndLeaderEpoch);
        });
        this.scheduler.schedule(new StringBuilder(24).append("load-txns-for-partition-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.loadTransactions$1(topicPartition, coordinatorEpoch, partitionAndLeaderEpoch, sendTxnMarkers), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        this.validateTransactionTopicPartitionCountIsStable();
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.loadingPartitions().remove((Object)partitionAndLeaderEpoch);
            return this.leavingPartitions().add((Object)partitionAndLeaderEpoch);
        });
        this.scheduler.schedule(new StringBuilder(26).append("remove-txns-for-partition-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.removeTransactions$1(partitionAndLeaderEpoch, partitionId, topicPartition), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
        if (this.transactionTopicPartitionCount() != curTransactionTopicPartitionCount) {
            throw new KafkaException(new StringBuilder(60).append("Transaction topic number of partitions has changed from ").append(this.transactionTopicPartitionCount()).append(" to ").append(curTransactionTopicPartitionCount).toString());
        }
    }

    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError) {
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata);
        long timestamp = this.time.milliseconds();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)});
        TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        scala.collection.immutable.Map recordsPerPartition = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records)}));
        CoreUtils$.MODULE$.inReadLock(this.stateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            boolean bl = false;
            Right right = null;
            Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.getTransactionState(transactionalId);
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                BoxedUnit boxedUnit2 = (BoxedUnit)responseCallback.apply((Object)err);
                return;
            }
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                Option option = (Option)right.value();
                if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit3 = (BoxedUnit)responseCallback.apply((Object)Errors.NOT_COORDINATOR);
                    return;
                }
            }
            if (!bl) throw new MatchError(either);
            Option option = (Option)right.value();
            if (!(option instanceof Some)) throw new MatchError(either);
            Some some = (Some)option;
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
            TransactionMetadata metadata = epochAndMetadata.transactionMetadata();
            boolean append = BoxesRunTime.unboxToBoolean(metadata.inLock((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                boolean bl;
                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch) {
                    responseCallback.apply((Object)Errors.NOT_COORDINATOR);
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }));
            if (append) {
                $this.replicaManager.appendRecords(newMetadata.txnTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, false, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responseStatus -> {
                    this.updateCacheCallback$1(responseStatus, topicPartition, transactionalId, newMetadata, coordinatorEpoch, retryOnError, responseCallback);
                    return BoxedUnit.UNIT;
                }, (Option<Lock>)new Some((Object)this.stateLock().readLock()), $this.replicaManager.appendRecords$default$8());
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Appending new metadata ").append(newMetadata).append(" for transaction id ").append(transactionalId).append(" with coordinator epoch ").append(coordinatorEpoch).append(" to the local transaction log").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        });
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$6));
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(int txnPartitionId$1, TransactionPartitionAndLeaderEpoch x$1) {
        return x$1.txnPartitionId() == txnPartitionId$1;
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$2(TransactionStateManager $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int txnPartitionId = tuple2._1$mcI$sp();
        boolean bl = !$this.leavingPartitions().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$3(txnPartitionId, x$1)));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$5(long now$1, Tuple2 x0$3) {
        boolean bl;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                bl = false;
            } else {
                TransactionState transactionState = txnMetadata.state();
                boolean bl2 = Ongoing$.MODULE$.equals(transactionState) ? txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$1 : false;
                bl = bl2;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl3 = bl;
        return bl3;
    }

    public static final /* synthetic */ boolean $anonfun$enableTransactionalIdExpiration$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
        TransactionState transactionState = txnMetadata.state();
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState));
        boolean bl2 = bl;
        boolean bl3 = bl2;
        return bl3;
    }

    public static final /* synthetic */ boolean $anonfun$enableTransactionalIdExpiration$5(TransactionStateManager $this, long now$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
        boolean bl = txnMetadata.txnLastUpdateTimestamp() <= now$2 - (long)$this.config.transactionalIdExpirationMs();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$enableTransactionalIdExpiration$11(TransactionStateManager $this, scala.collection.immutable.Map transactionalIdByPartition$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        ProduceResponse.PartitionResponse response = (ProduceResponse.PartitionResponse)tuple2._2();
        BoxedUnit boxedUnit = (BoxedUnit)CoreUtils$.MODULE$.inReadLock($this.stateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Iterable toRemove = (scala.collection.mutable.Iterable)transactionalIdByPartition$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
            $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())).foreach((Function1 & Serializable & scala.Serializable)txnMetadataCacheEntry -> {
                toRemove.foreach((Function1 & Serializable & scala.Serializable)idCoordinatorEpochAndMetadata -> {
                    String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
                    TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
                    return txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                        Object object;
                        if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                            Errors errors = response$1.error;
                            Errors errors2 = Errors.NONE;
                            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                                object = txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                                return object;
                            }
                        }
                        $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Failed to remove expired transactionalId: ").append(transactionalId).append(new StringBuilder(43).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").toString()).append(new StringBuilder(33).append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").toString()).append(new StringBuilder(26).append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").toString()).append(new StringBuilder(48).append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").toString()).append(String.valueOf(BoxesRunTime.boxToInteger((int)idCoordinatorEpochAndMetadata.coordinatorEpoch()))).toString());
                        txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                        object = BoxedUnit.UNIT;
                        return object;
                    });
                });
                return BoxedUnit.UNIT;
            });
        });
    }

    private final void removeFromCacheCallback$1(Map responses, scala.collection.immutable.Map transactionalIdByPartition$1) {
        responses.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TransactionStateManager.$anonfun$enableTransactionalIdExpiration$11(this, transactionalIdByPartition$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$1, TransactionPartitionAndLeaderEpoch x$3) {
        return x$3.txnPartitionId() == partitionId$1;
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$3(int partitionId$1, TransactionPartitionAndLeaderEpoch x$4) {
        return x$4.txnPartitionId() == partitionId$1;
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(topicPartition$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$1, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$1;
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$7(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch$1, Record record) {
        Object object;
        Predef$.MODULE$.require(record.hasKey(), (Function0 & Serializable & scala.Serializable)() -> "Transaction state log's key should not be null");
        TxnKey txnKey = TransactionLog$.MODULE$.readTxnRecordKey(record.key());
        String transactionalId = txnKey.transactionalId();
        if (!record.hasValue()) {
            object = loadedTransactions$1.remove(transactionalId);
        } else {
            TransactionMetadata txnMetadata = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
            object = loadedTransactions$1.put(transactionalId, txnMetadata);
        }
        currOffset$1.elem = batch$1.nextOffset();
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$6(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch) {
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionStateManager.$anonfun$loadTransactionMetadata$7(loadedTransactions$1, currOffset$1, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    private final void loadTransactions$1(TopicPartition topicPartition$3, int coordinatorEpoch$2, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, Function5 sendTxnMarkers$1) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Loading transaction metadata from ").append(topicPartition$3).toString());
        Pool<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$2);
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (!this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) break block0;
                this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$2, loadedTransactions);
                ListBuffer transactionsPendingForCompletion = new ListBuffer();
                loadedTransactions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String transactionalId = (String)tuple2._1();
                    TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._2();
                    Object t = txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                        TransactionState transactionState = txnMetadata.state();
                        Object object = PrepareAbort$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$2, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : (PrepareCommit$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$2, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : BoxedUnit.UNIT);
                        return object;
                    });
                    return t;
                });
                this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
                transactionsPendingForCompletion.foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                    sendTxnMarkers$1.apply((Object)txnTransitMetadata.transactionalId(), (Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                    return BoxedUnit.UNIT;
                });
            }
        });
    }

    private final void removeTransactions$1(TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$3, int partitionId$2, TopicPartition topicPartition$4) {
        CoreUtils$.MODULE$.inWriteLock(this.stateLock(), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            if (this.leavingPartitions().contains((Object)partitionAndLeaderEpoch$3)) {
                Option option = this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$2));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)some.value();
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Removed ").append(txnMetadataCacheEntry.metadataPerTransactionalId().size()).append(" cached transaction metadata for ").append(topicPartition$4).append(" on follower transition").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(206).append("Trying to remove cached transaction metadata for ").append(topicPartition$4).append(" on follower transition but there is no entries remaining; ").append("it is likely that another process for removing the cached entries has just executed earlier before").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
                object = BoxesRunTime.boxToBoolean((boolean)this.leavingPartitions().remove((Object)partitionAndLeaderEpoch$3));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$4, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return new StringBuilder(41).append("Appending ").append(transactionalId$4).append("'s new metadata ").append(newMetadata$1).append(" failed due to ").append(status$1.error.exceptionName()).toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$4, Errors err$1) {
        return new StringBuilder(140).append("Accessing the cached transaction metadata for ").append(transactionalId$4).append(" returns ").append(err$1).append(" error; ").append("aborting transition to the new metadata and setting the error in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$3(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, int coordinatorEpoch$3, String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        if (epochAndMetadata$1.coordinatorEpoch() != coordinatorEpoch$3) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append("The cached coordinator epoch for ").append(transactionalId$4).append(" has changed to ").append(epochAndMetadata$1.coordinatorEpoch()).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append(new StringBuilder(78).append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$4)).append(") while it was ").append(coordinatorEpoch$3).append(" before appending; ").toString()).append(new StringBuilder(70).append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString()).toString());
            responseError$1.elem = Errors.NOT_COORDINATOR;
        } else {
            metadata$1.completeTransitionTo(newMetadata$1);
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Updating ").append(transactionalId$4).append("'s transaction state to ").append(newMetadata$1).append(" with coordinator epoch ").append(coordinatorEpoch$3).append(" for ").append(transactionalId$4).append(" succeeded").toString());
        }
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TransactionStateManager $this, String transactionalId$4, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$3) {
        return new StringBuilder(106).append("The cached coordinator metadata does not exist in the cache anymore for ").append(transactionalId$4).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append(new StringBuilder(78).append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$4)).append(") while it was ").append(coordinatorEpoch$3).append(" before appending; ").toString()).append(new StringBuilder(70).append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString()).toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$7(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, int coordinatorEpoch$3, Function1 retryOnError$1, ObjectRef responseError$1, TransactionMetadata metadata$2, TxnTransitMetadata newMetadata$1) {
        if (epochAndTxnMetadata$1.coordinatorEpoch() == coordinatorEpoch$3) {
            if (BoxesRunTime.unboxToBoolean((Object)retryOnError$1.apply((Object)((Errors)responseError$1.elem)))) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append(new StringBuilder(97).append("not resetting pending state ").append(metadata$2.pendingState()).append(" but just returning the error in the callback to let the caller retry").toString()).toString());
            } else {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append(new StringBuilder(87).append("resetting pending state from ").append(metadata$2.pendingState()).append(", aborting state transition and returning ").append((Errors)responseError$1.elem).append(" in the callback").toString()).toString());
                metadata$2.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
            }
        } else {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append(new StringBuilder(115).append("aborting state transition and returning the error in the callback since the coordinator epoch has changed from ").append(epochAndTxnMetadata$1.coordinatorEpoch()).append(" to ").append(coordinatorEpoch$3).toString()).toString());
        }
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$11(String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return new StringBuilder(190).append("TransactionalId ").append(transactionalId$4).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since metadata is not available in the cache anymore").toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$12(String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return new StringBuilder(72).append("TransactionalId ").append(transactionalId$4).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append(new StringBuilder(101).append("aborting state transition and returning the error in the callback since retrieving metadata returned ").append(error$1).toString()).toString();
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(Map responseStatus, TopicPartition topicPartition$5, String transactionalId$4, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$3, Function1 retryOnError$1, Function1 responseCallback$1) {
        block15: {
            block13: {
                block17: {
                    block16: {
                        block14: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$5)) {
                                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$5})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$5);
                            v0 = status.error;
                            var16_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var16_9) == false : var16_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var17_10 = status.error;
                                var13_11 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var17_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var17_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var17_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var17_10) != false));
                                if (var13_11) {
                                    var10_12 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else {
                                    var12_13 = Errors.NOT_LEADER_FOR_PARTITION.equals(var17_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var17_10) != false;
                                    if (var12_13) {
                                        var10_12 = Errors.NOT_COORDINATOR;
                                    } else {
                                        var11_14 = Errors.MESSAGE_TOO_LARGE.equals(var17_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var17_10) != false;
                                        var10_12 = var11_14 != false ? Errors.UNKNOWN_SERVER_ERROR : var17_10;
                                    }
                                }
                                v1 = var10_12;
                            }
                            responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)responseError.elem;
                            var18_16 = Errors.NONE;
                            if (v2 != null ? v2.equals(var18_16) == false : var18_16 != null) break block13;
                            var19_17 = false;
                            var20_18 = null;
                            var21_19 = this.getTransactionState(transactionalId$4);
                            if (!(var21_19 instanceof Left)) break block14;
                            var22_20 = (Left)var21_19;
                            err = (Errors)var22_20.value();
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$4, (Errors)err));
                            responseError.elem = err;
                            var9_22 = BoxedUnit.UNIT;
                            break block15;
                        }
                        if (!(var21_19 instanceof Right)) break block16;
                        var19_17 = true;
                        var20_18 = (Right)var21_19;
                        var24_25 = (Option)var20_18.value();
                        if (!(var24_25 instanceof Some)) break block16;
                        var25_26 = (Some)var24_25;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)var25_26.value();
                        metadata = epochAndMetadata.transactionMetadata();
                        var9_23 = (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndMetadata, (int)coordinatorEpoch$3, (String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (TransactionMetadata)metadata));
                        break block15;
                    }
                    if (!var19_17 || !None$.MODULE$.equals(var28_29 = (Option)var20_18.value())) break block17;
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$3));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    var9_24 = BoxedUnit.UNIT;
                    break block15;
                }
                throw new MatchError(var21_19);
            }
            var29_30 = false;
            var30_31 = null;
            var31_32 = this.getTransactionState(transactionalId$4);
            if (!(var31_32 instanceof Right)) ** GOTO lbl-1000
            var29_30 = true;
            var30_31 = (Right)var31_32;
            var32_33 = (Option)var30_31.value();
            if (var32_33 instanceof Some) {
                var33_34 = (Some)var32_33;
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)var33_34.value();
                metadata = epochAndTxnMetadata.transactionMetadata();
                var8_37 = (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (int)coordinatorEpoch$3, (Function1)retryOnError$1, (ObjectRef)responseError, (TransactionMetadata)metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var29_30 && None$.MODULE$.equals(var36_40 = (Option)var30_31.value())) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError));
                var8_38 = BoxedUnit.UNIT;
            } else if (var31_32 instanceof Left) {
                var37_41 = (Left)var31_32;
                error = (Errors)var37_41.value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (Errors)error));
                var8_39 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(var31_32);
            }
        }
        responseCallback$1.apply((Object)((Errors)responseError.elem));
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$6) {
        return false;
    }

    public TransactionStateManager(int brokerId, KafkaZkClient zkClient, Scheduler scheduler, ReplicaManager replicaManager, TransactionConfig config, Time time) {
        this.zkClient = zkClient;
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(30).append("[Transaction State Manager ").append(brokerId).append("]: ").toString());
        this.shuttingDown = new AtomicBoolean(false);
        this.stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.leavingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionMetadataCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
    }
}

