/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.IndexOffsetOverflowException;
import kafka.log.AbstractIndex$;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.utils.MappedByteBuffers;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Utils;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0015f!B\u001e=\u0003\u0003\t\u0005\u0002C)\u0001\u0005\u0003\u0007I\u0011\u0001*\t\u0011Y\u0003!\u00111A\u0005\u0002]C\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006Ka\u0015\u0005\tK\u0002\u0011)\u0019!C\u0001M\"A!\u000e\u0001B\u0001B\u0003%q\r\u0003\u0005l\u0001\t\u0015\r\u0011\"\u0001m\u0011!\u0001\bA!A!\u0002\u0013i\u0007\u0002C9\u0001\u0005\u000b\u0007I\u0011\u0001:\t\u0011Y\u0004!\u0011!Q\u0001\nMDQa\u001e\u0001\u0005\u0002aD!\"a\u0007\u0001\u0001\u0004\u0005\r\u0011\"\u0003g\u0011-\ti\u0002\u0001a\u0001\u0002\u0004%I!a\b\t\u0015\u0005\r\u0002\u00011A\u0001B\u0003&q\r\u0003\u0004\u0002(\u00011\t\u0002\u001c\u0005\u0007\u0003S\u0001A\u0011\u00037\t\u0013\u0005-\u0002A1A\u0005\u0012\u00055\u0002\u0002CA\"\u0001\u0001\u0006I!a\f\t\u0013\u0005\u0015\u0003\u00011A\u0005\u0012\u0005\u001d\u0003\"CA+\u0001\u0001\u0007I\u0011CA,\u0011!\tY\u0006\u0001Q!\n\u0005%\u0003bBA0\u0001\u0001\u0006K!\u001c\u0005\t\u0003G\u0002\u0001\u0019!C\tY\"I\u0011Q\r\u0001A\u0002\u0013E\u0011q\r\u0005\b\u0003W\u0002\u0001\u0015)\u0003n\u0011\u0019\ty\u0007\u0001C\u0001e\"1\u0011\u0011\u000f\u0001\u0005\u00021Da!a\u001d\u0001\t\u0003a\u0007BBA;\u0001\u0011\u0005a\rC\u0004\u0002x\u0001!\t!!\u001f\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\"9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005bBAF\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0003\u001f\u0003A\u0011AAE\u0011\u0019\t\t\n\u0001C\u0001Y\"9\u00111\u0013\u0001\u0005\u0002\u0005%\u0005bBAK\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003/\u0003a\u0011AAE\u0011\u001d\tI\n\u0001D\t\u0003\u0013Cq!a'\u0001\r\u0003\ti\nC\u0004\u0002$\u0002!\t!!#\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002(\"9\u00111\u0016\u0001\u0005\u0002\u00055\u0006bBAY\u0001\u0011E\u0011\u0011\u0012\u0005\t\u0003g\u0003A\u0011\u0003\u001f\u0002\n\"9\u0011Q\u0017\u0001\u0005\u0012\u0005]\u0006bBAk\u0001\u0019E\u0011q\u001b\u0005\b\u0003[\u0004A\u0011CAx\u0011\u001d\u0011I\u0002\u0001C\t\u00057AqAa\t\u0001\t\u0013\u0011)\u0003C\u0004\u00034\u0001!IA!\u000e\t\u000f\t}\u0002\u0001\"\u0003\u0003B!9!1\n\u0001\u0005\n\t5sa\u0002B,y!\u0005!\u0011\f\u0004\u0007wqB\tAa\u0017\t\r]4D\u0011\u0001B8\u0011%\u0011\tH\u000eb\u0001\n\u0003\u0012\u0019\b\u0003\u0005\u0003\u0006Z\u0002\u000b\u0011\u0002B;\u0011%\u00119INI\u0001\n\u0003\u0011IIA\u0007BEN$(/Y2u\u0013:$W\r\u001f\u0006\u0003{y\n1\u0001\\8h\u0015\u0005y\u0014!B6bM.\f7\u0001A\u000b\u0005\u0005v\fyaE\u0002\u0001\u0007.\u0003\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\t1\fgn\u001a\u0006\u0002\u0011\u0006!!.\u0019<b\u0013\tQUI\u0001\u0004PE*,7\r\u001e\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\u001e\u000b!![8\n\u0005Ak%!C\"m_N,\u0017M\u00197f\u0003\u00111\u0017\u000e\\3\u0016\u0003M\u0003\"\u0001\u0014+\n\u0005Uk%\u0001\u0002$jY\u0016\f\u0001BZ5mK~#S-\u001d\u000b\u00031z\u0003\"!\u0017/\u000e\u0003iS\u0011aW\u0001\u0006g\u000e\fG.Y\u0005\u0003;j\u0013A!\u00168ji\"9qLAA\u0001\u0002\u0004\u0019\u0016a\u0001=%c\u0005)a-\u001b7fA!\u00121A\u0019\t\u00033\u000eL!\u0001\u001a.\u0003\u0011Y|G.\u0019;jY\u0016\f!BY1tK>3gm]3u+\u00059\u0007CA-i\u0013\tI'L\u0001\u0003M_:<\u0017a\u00032bg\u0016|eMZ:fi\u0002\nA\"\\1y\u0013:$W\r_*ju\u0016,\u0012!\u001c\t\u00033:L!a\u001c.\u0003\u0007%sG/A\u0007nCbLe\u000eZ3y'&TX\rI\u0001\toJLG/\u00192mKV\t1\u000f\u0005\u0002Zi&\u0011QO\u0017\u0002\b\u0005>|G.Z1o\u0003%9(/\u001b;bE2,\u0007%\u0001\u0004=S:LGO\u0010\u000b\ns\u0006M\u0011QCA\f\u00033\u0001RA\u001f\u0001|\u0003\u001bi\u0011\u0001\u0010\t\u0003yvd\u0001\u0001B\u0003\u007f\u0001\t\u0007qPA\u0001L#\u0011\t\t!a\u0002\u0011\u0007e\u000b\u0019!C\u0002\u0002\u0006i\u0013qAT8uQ&tw\rE\u0002Z\u0003\u0013I1!a\u0003[\u0005\r\te.\u001f\t\u0004y\u0006=AABA\t\u0001\t\u0007qPA\u0001W\u0011\u0015\t&\u00021\u0001T\u0011\u0015)'\u00021\u0001h\u0011\u001dY'\u0002%AA\u00025DQ!\u001d\u0006A\u0002M\fqa\u00187f]\u001e$\b.A\u0006`Y\u0016tw\r\u001e5`I\u0015\fHc\u0001-\u0002\"!9q\fDA\u0001\u0002\u00049\u0017\u0001C0mK:<G\u000f\u001b\u0011)\u00055\u0011\u0017!C3oiJL8+\u001b>f\u00031yv/\u0019:n\u000b:$(/[3t\u0003\u0011awnY6\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003\u007fi!!a\r\u000b\t\u0005U\u0012qG\u0001\u0006Y>\u001c7n\u001d\u0006\u0005\u0003s\tY$\u0001\u0006d_:\u001cWO\u001d:f]RT1!!\u0010H\u0003\u0011)H/\u001b7\n\t\u0005\u0005\u00131\u0007\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\u0002\u000b1|7m\u001b\u0011\u0002\t5l\u0017\r]\u000b\u0003\u0003\u0013\u0002B!a\u0013\u0002R5\u0011\u0011Q\n\u0006\u0004\u0003\u001f:\u0015a\u00018j_&!\u00111KA'\u0005Ai\u0015\r\u001d9fI\nKH/\u001a\"vM\u001a,'/\u0001\u0005n[\u0006\u0004x\fJ3r)\rA\u0016\u0011\f\u0005\t?N\t\t\u00111\u0001\u0002J\u0005)Q.\\1qA!\u0012ACY\u0001\f?6\f\u00070\u00128ue&,7\u000f\u000b\u0002\u0016E\u0006Aq,\u001a8ue&,7/\u0001\u0007`K:$(/[3t?\u0012*\u0017\u000fF\u0002Y\u0003SBqaX\f\u0002\u0002\u0003\u0007Q.A\u0005`K:$(/[3tA!\u0012\u0001DY\u0001\u0007SN4U\u000f\u001c7\u0002\u00155\f\u00070\u00128ue&,7/A\u0004f]R\u0014\u0018.Z:\u0002\r1,gn\u001a;i\u0003\u0019\u0011Xm]5{KR\u00191/a\u001f\t\r\u0005uT\u00041\u0001n\u0003\u001dqWm^*ju\u0016\f\u0001B]3oC6,Gk\u001c\u000b\u00041\u0006\r\u0005BBAC=\u0001\u00071+A\u0001g\u0003\u00151G.^:i)\u0005A\u0016A\u00043fY\u0016$X-\u00134Fq&\u001cHo\u001d\u000b\u0002g\u0006yAO]5n)>4\u0016\r\\5e'&TX-A\u0006tSj,\u0017J\u001c\"zi\u0016\u001c\u0018!B2m_N,\u0017\u0001D2m_N,\u0007*\u00198eY\u0016\u0014\u0018aC:b]&$\u0018p\u00115fG.\f\u0001\u0002\u001e:v]\u000e\fG/Z\u0001\u000biJ,hnY1uKR{Gc\u0001-\u0002 \"1\u0011\u0011U\u0014A\u0002\u001d\faa\u001c4gg\u0016$\u0018!\u0002:fg\u0016$\u0018A\u0004:fY\u0006$\u0018N^3PM\u001a\u001cX\r\u001e\u000b\u0004[\u0006%\u0006BBAQS\u0001\u0007q-A\bdC:\f\u0005\u000f]3oI>3gm]3u)\r\u0019\u0018q\u0016\u0005\u0007\u0003CS\u0003\u0019A4\u0002\u001dM\fg-\u001a$pe\u000e,WK\\7ba\u0006Qam\u001c:dKVsW.\u00199\u0002\u00135\f\u0017PY3M_\u000e\\W\u0003BA]\u0003\u007f#B!a/\u0002NR!\u0011QXAb!\ra\u0018q\u0018\u0003\u0007\u0003\u0003l#\u0019A@\u0003\u0003QC\u0001\"!2.\t\u0003\u0007\u0011qY\u0001\u0004MVt\u0007#B-\u0002J\u0006u\u0016bAAf5\nAAHY=oC6,g\bC\u0004\u0002,5\u0002\r!a4\u0011\t\u0005E\u0012\u0011[\u0005\u0005\u0003'\f\u0019D\u0001\u0003M_\u000e\\\u0017A\u00039beN,WI\u001c;ssR1\u0011\u0011\\Ap\u0003S\u00042A_An\u0013\r\ti\u000e\u0010\u0002\u000b\u0013:$W\r_#oiJL\bbBAq]\u0001\u0007\u00111]\u0001\u0007EV4g-\u001a:\u0011\t\u0005-\u0013Q]\u0005\u0005\u0003O\fiE\u0001\u0006CsR,')\u001e4gKJDa!a;/\u0001\u0004i\u0017!\u00018\u000211\f'oZ3ti2{w/\u001a:C_VtGm\u00157pi\u001a{'\u000fF\u0004n\u0003c\f)0!?\t\u000f\u0005Mx\u00061\u0001\u0002d\u0006\u0019\u0011\u000e\u001a=\t\r\u0005]x\u00061\u0001h\u0003\u0019!\u0018M]4fi\"9\u00111`\u0018A\u0002\u0005u\u0018\u0001D:fCJ\u001c\u0007.\u00128uSRL\b\u0003BA\u0000\u0005'qAA!\u0001\u0003\u00109!!1\u0001B\u0007\u001d\u0011\u0011)Aa\u0003\u000e\u0005\t\u001d!b\u0001B\u0005\u0001\u00061AH]8pizJ\u0011aP\u0005\u0003{yJ1A!\u0005=\u0003=Ie\u000eZ3y'\u0016\f'o\u00195UsB,\u0017\u0002\u0002B\u000b\u0005/\u0011\u0011#\u00138eKb\u001cV-\u0019:dQ\u0016sG/\u001b;z\u0015\r\u0011\t\u0002P\u0001\u001ag6\fG\u000e\\3tiV\u0003\b/\u001a:C_VtGm\u00157pi\u001a{'\u000fF\u0004n\u0005;\u0011yB!\t\t\u000f\u0005M\b\u00071\u0001\u0002d\"1\u0011q\u001f\u0019A\u0002\u001dDq!a?1\u0001\u0004\ti0A\tj]\u0012,\u0007p\u00157piJ\u000bgnZ3G_J$\u0002Ba\n\u0003.\t=\"\u0011\u0007\t\u00063\n%R.\\\u0005\u0004\u0005WQ&A\u0002+va2,'\u0007C\u0004\u0002tF\u0002\r!a9\t\r\u0005]\u0018\u00071\u0001h\u0011\u001d\tY0\ra\u0001\u0003{\f\u0011cY8na\u0006\u0014X-\u00138eKb,e\u000e\u001e:z)\u001di'q\u0007B\u001e\u0005{AqA!\u000f3\u0001\u0004\tI.\u0001\u0006j]\u0012,\u00070\u00128uefDa!a>3\u0001\u00049\u0007bBA~e\u0001\u0007\u0011Q`\u0001\u0019e>,h\u000e\u001a#po:$v.\u0012=bGRlU\u000f\u001c;ja2,G#B7\u0003D\t\u001d\u0003B\u0002B#g\u0001\u0007Q.\u0001\u0004ok6\u0014WM\u001d\u0005\u0007\u0005\u0013\u001a\u0004\u0019A7\u0002\r\u0019\f7\r^8s\u0003)!xNU3mCRLg/\u001a\u000b\u0005\u0005\u001f\u0012)\u0006\u0005\u0003Z\u0005#j\u0017b\u0001B*5\n1q\n\u001d;j_:Da!!)5\u0001\u00049\u0017!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007\u0010\u0005\u0002{mM)aG!\u0018\u0003dA\u0019\u0011La\u0018\n\u0007\t\u0005$L\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0005K\u0012Y'\u0004\u0002\u0003h)\u0019!\u0011\u000e \u0002\u000bU$\u0018\u000e\\:\n\t\t5$q\r\u0002\b\u0019><w-\u001b8h)\t\u0011I&\u0001\u0006m_\u001e<WM\u001d(b[\u0016,\"A!\u001e\u0011\t\t]$q\u0010\b\u0005\u0005s\u0012Y\bE\u0002\u0003\u0006iK1A! [\u0003\u0019\u0001&/\u001a3fM&!!\u0011\u0011BB\u0005\u0019\u0019FO]5oO*\u0019!Q\u0010.\u0002\u00171|wmZ3s\u001d\u0006lW\rI\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\r\t-%\u0011\u0015BR+\t\u0011iIK\u0002n\u0005\u001f[#A!%\u0011\t\tM%QT\u0007\u0003\u0005+SAAa&\u0003\u001a\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00057S\u0016AC1o]>$\u0018\r^5p]&!!q\u0014BK\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0006}j\u0012\ra \u0003\u0007\u0003#Q$\u0019A@")
public abstract class AbstractIndex<K, V>
implements Closeable {
    private volatile File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final boolean writable;
    private volatile long _length;
    private final ReentrantLock lock;
    private volatile MappedByteBuffer mmap;
    private volatile int _maxEntries;
    private volatile int _entries;

    public static <K, V> int $lessinit$greater$default$3() {
        return AbstractIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public static String loggerName() {
        return AbstractIndex$.MODULE$.loggerName();
    }

    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$.MODULE$.fatal(function0, function02);
    }

    public static void fatal(Function0<String> function0) {
        AbstractIndex$.MODULE$.fatal(function0);
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$.MODULE$.error(function0, function02);
    }

    public static void error(Function0<String> function0) {
        AbstractIndex$.MODULE$.error(function0);
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$.MODULE$.warn(function0, function02);
    }

    public static void warn(Function0<String> function0) {
        AbstractIndex$.MODULE$.warn(function0);
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$.MODULE$.info(function0, function02);
    }

    public static void info(Function0<String> function0) {
        AbstractIndex$.MODULE$.info(function0);
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$.MODULE$.debug(function0, function02);
    }

    public static void debug(Function0<String> function0) {
        AbstractIndex$.MODULE$.debug(function0);
    }

    public static boolean isTraceEnabled() {
        return AbstractIndex$.MODULE$.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return AbstractIndex$.MODULE$.isDebugEnabled();
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$.MODULE$.trace(function0, function02);
    }

    public static void trace(Function0<String> function0) {
        AbstractIndex$.MODULE$.trace(function0);
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public boolean writable() {
        return this.writable;
    }

    private long _length() {
        return this._length;
    }

    private void _length_$eq(long x$1) {
        this._length = x$1;
    }

    public abstract int entrySize();

    public int _warmEntries() {
        return 8192 / this.entrySize();
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public MappedByteBuffer mmap() {
        return this.mmap;
    }

    public void mmap_$eq(MappedByteBuffer x$1) {
        this.mmap = x$1;
    }

    public int _entries() {
        return this._entries;
    }

    public void _entries_$eq(int x$1) {
        this._entries = x$1;
    }

    public boolean isFull() {
        return this._entries() >= this._maxEntries;
    }

    public int maxEntries() {
        return this._maxEntries;
    }

    public int entries() {
        return this._entries();
    }

    public long length() {
        return this._length();
    }

    public boolean resize(int newSize) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            int roundedNewSize = this.roundDownToExactMultiple(newSize, this.entrySize());
            if (this._length() == (long)roundedNewSize) {
                AbstractIndex$.MODULE$.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Index ").append(this.file().getAbsolutePath()).append(" was not resized because it already has size ").append(roundedNewSize).toString());
                bl = false;
            } else {
                RandomAccessFile raf = new RandomAccessFile(this.file(), "rw");
                try {
                    int position = this.mmap().position();
                    if (OperatingSystem.IS_WINDOWS) {
                        this.safeForceUnmap();
                    }
                    raf.setLength(roundedNewSize);
                    this._length_$eq(roundedNewSize);
                    this.mmap_$eq(raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, roundedNewSize));
                    $this._maxEntries = this.mmap().limit() / this.entrySize();
                    this.mmap().position(position);
                    AbstractIndex$.MODULE$.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Resized ").append(this.file().getAbsolutePath()).append(" to ").append(roundedNewSize).append(", position is ").append(this.mmap().position()).append(" ").append(new StringBuilder(13).append("and limit is ").append(this.mmap().limit()).toString()).toString());
                    bl = true;
                }
                finally {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> raf.close(), AbstractIndex$.MODULE$, CoreUtils$.MODULE$.swallow$default$3());
                }
            }
            return bl;
        }));
    }

    public void renameTo(File f) {
        try {
            Utils.atomicMoveWithFallback((Path)this.file().toPath(), (Path)f.toPath());
        }
        finally {
            this.file_$eq(f);
        }
    }

    public void flush() {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.mmap().force());
    }

    public boolean deleteIfExists() {
        this.closeHandler();
        return Files.deleteIfExists(this.file().toPath());
    }

    public void trimToValidSize() {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.resize(this.entrySize() * this._entries()));
    }

    public int sizeInBytes() {
        return this.entrySize() * this._entries();
    }

    @Override
    public void close() {
        this.trimToValidSize();
        this.closeHandler();
    }

    public void closeHandler() {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.safeForceUnmap());
    }

    public abstract void sanityCheck();

    public abstract void truncate();

    public abstract void truncateTo(long var1);

    public void reset() {
        this.truncate();
        this.resize(this.maxIndexSize());
    }

    public int relativeOffset(long offset) {
        Option<Object> relativeOffset = this.toRelative(offset);
        if (relativeOffset.isEmpty()) {
            throw new IndexOffsetOverflowException(new StringBuilder(32).append("Integer overflow for offset: ").append(offset).append(" (").append(this.file().getAbsoluteFile()).append(")").toString());
        }
        return BoxesRunTime.unboxToInt((Object)relativeOffset.get());
    }

    public boolean canAppendOffset(long offset) {
        return this.toRelative(offset).isDefined();
    }

    public void safeForceUnmap() {
        try {
            this.forceUnmap();
        }
        catch (Throwable t) {
            AbstractIndex$.MODULE$.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Error unmapping index ").append(this.file()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
        }
    }

    public void forceUnmap() {
        try {
            MappedByteBuffers.unmap((String)this.file().getAbsolutePath(), (MappedByteBuffer)this.mmap());
        }
        finally {
            this.mmap_$eq(null);
        }
    }

    public <T> T maybeLock(Lock lock, Function0<T> fun) {
        Object object;
        if (OperatingSystem.IS_WINDOWS) {
            lock.lock();
        }
        try {
            object = fun.apply();
        }
        finally {
            if (OperatingSystem.IS_WINDOWS) {
                lock.unlock();
            }
        }
        return (T)object;
    }

    public abstract IndexEntry parseEntry(ByteBuffer var1, int var2);

    public int largestLowerBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._1$mcI$sp();
    }

    public int smallestUpperBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._2$mcI$sp();
    }

    private Tuple2<Object, Object> indexSlotRangeFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        if (this._entries() == 0) {
            return new Tuple2.mcII.sp(-1, -1);
        }
        int firstHotEntry = Math.max(0, this._entries() - 1 - this._warmEntries());
        if (this.compareIndexEntry(this.parseEntry(idx, firstHotEntry), target, searchEntity) < 0) {
            return this.binarySearch$1(firstHotEntry, this._entries() - 1, idx, target, searchEntity);
        }
        if (this.compareIndexEntry(this.parseEntry(idx, 0), target, searchEntity) > 0) {
            return new Tuple2.mcII.sp(-1, 0);
        }
        return this.binarySearch$1(0, firstHotEntry, idx, target, searchEntity);
    }

    private int compareIndexEntry(IndexEntry indexEntry, long target, Enumeration.Value searchEntity) {
        int n;
        Enumeration.Value value = searchEntity;
        Enumeration.Value value2 = IndexSearchType$.MODULE$.KEY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            n = Predef$.MODULE$.long2Long(indexEntry.indexKey()).compareTo(Predef$.MODULE$.long2Long(target));
        } else {
            Enumeration.Value value4 = IndexSearchType$.MODULE$.VALUE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                n = Predef$.MODULE$.long2Long(indexEntry.indexValue()).compareTo(Predef$.MODULE$.long2Long(target));
            } else {
                throw new MatchError((Object)value);
            }
        }
        return n;
    }

    private int roundDownToExactMultiple(int number, int factor) {
        return factor * (number / factor);
    }

    private Option<Object> toRelative(long offset) {
        long relativeOffset = offset - this.baseOffset();
        return relativeOffset < 0L || relativeOffset > Integer.MAX_VALUE ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)((int)relativeOffset)));
    }

    private final Tuple2 binarySearch$1(int begin, int end, ByteBuffer idx$1, long target$1, Enumeration.Value searchEntity$1) {
        int lo = begin;
        int hi = end;
        while (lo < hi) {
            int mid = (int)package$.MODULE$.ceil((double)hi / 2.0 + (double)lo / 2.0);
            IndexEntry found = this.parseEntry(idx$1, mid);
            int compareResult = this.compareIndexEntry(found, target$1, searchEntity$1);
            if (compareResult > 0) {
                hi = mid - 1;
                continue;
            }
            if (compareResult < 0) {
                lo = mid;
                continue;
            }
            return new Tuple2.mcII.sp(mid, mid);
        }
        return new Tuple2.mcII.sp(lo, lo == this._entries() - 1 ? -1 : lo + 1);
    }

    public AbstractIndex(File file, long baseOffset, int maxIndexSize, boolean writable) {
        MappedByteBuffer mappedByteBuffer;
        this.file = file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        this.writable = writable;
        this.lock = new ReentrantLock();
        boolean newlyCreated = this.file().createNewFile();
        RandomAccessFile raf = writable ? new RandomAccessFile(this.file(), "rw") : new RandomAccessFile(this.file(), "r");
        try {
            if (newlyCreated) {
                if (maxIndexSize < this.entrySize()) {
                    throw new IllegalArgumentException(new StringBuilder(24).append("Invalid max index size: ").append(maxIndexSize).toString());
                }
                raf.setLength(this.roundDownToExactMultiple(maxIndexSize, this.entrySize()));
            }
            this._length_$eq(raf.length());
            MappedByteBuffer idx = writable ? raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this._length()) : raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this._length());
            MappedByteBuffer mappedByteBuffer2 = newlyCreated ? idx.position(0) : idx.position(this.roundDownToExactMultiple(idx.limit(), this.entrySize()));
            mappedByteBuffer = idx;
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> raf.close(), AbstractIndex$.MODULE$, CoreUtils$.MODULE$.swallow$default$3());
        }
        this.mmap = mappedByteBuffer;
        this._maxEntries = this.mmap().limit() / this.entrySize();
        this._entries = this.mmap().position() / this.entrySize();
    }
}

