/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.CreatePartitionsMetadata;
import kafka.server.DelayedCreatePartitions;
import kafka.server.DelayedDeleteTopics;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DeleteTopicMetadata;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.MetadataCache;
import kafka.server.TopicKey;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.ReassignmentInProgressException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rEc\u0001\u0002\u0014(\u00011B\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\u0003\"AA\b\u0001BC\u0002\u0013\u0005a\t\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003H\u0011!!\u0006A!b\u0001\n\u0003)\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011i\u0003!Q1A\u0005\u0002mC\u0001B\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\u0006G\u0002!\t\u0001\u001a\u0005\bU\u0002\u0011\r\u0011\"\u0003l\u0011\u0019\u0011\b\u0001)A\u0005Y\"91\u000f\u0001b\u0001\n\u0013!\bB\u0002=\u0001A\u0003%Q\u000fC\u0004z\u0001\t\u0007I\u0011\u0002>\t\u000f\u0005-\u0001\u0001)A\u0005w\"I\u0011Q\u0002\u0001C\u0002\u0013%\u0011q\u0002\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\u0012!9\u00111\u0004\u0001\u0005\u0002\u0005u\u0001bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003\u0013\u0002A\u0011AA&\u0011\u001d\tI\u000b\u0001C\u0001\u0003WCq!a3\u0001\t\u0003\ti\rC\u0004\u0002\u0000\u0002!\tA!\u0001\t\u000f\t%\u0002\u0001\"\u0001\u0003,!9!1\t\u0001\u0005\n\t\u0015\u0003b\u0002B7\u0001\u0011%!q\u000e\u0005\b\u0005s\u0002A\u0011\u0002B>\u0011\u001d\u0011\t\t\u0001C\u0005\u0005\u0007CqA!#\u0001\t\u0003\u0011Y\tC\u0004\u00036\u0002!IAa.\t\u000f\t]\u0007\u0001\"\u0001\u0003Z\"9!1\u001c\u0001\u0005\n\tu\u0007b\u0002Br\u0001\u0011%!Q\u001d\u0005\b\u0005[\u0004A\u0011\u0002Bx\u0011\u001d\u0011y\u0010\u0001C\u0005\u0007\u0003Aqaa\u0005\u0001\t\u0013\u0019)\u0002C\u0004\u0004B\u0001!Iaa\u0011\u0003\u0019\u0005#W.\u001b8NC:\fw-\u001a:\u000b\u0005!J\u0013AB:feZ,'OC\u0001+\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\u00174sA\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t1\u0011I\\=SK\u001a\u0004\"\u0001N\u001c\u000e\u0003UR!AN\u0015\u0002\u000bU$\u0018\u000e\\:\n\u0005a*$a\u0002'pO\u001eLgn\u001a\t\u0003uuj\u0011a\u000f\u0006\u0003y%\nq!\\3ue&\u001c7/\u0003\u0002?w\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\r\r|gNZ5h+\u0005\t\u0005C\u0001\"D\u001b\u00059\u0013B\u0001#(\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u000f\r|gNZ5hAU\tq\t\u0005\u0002I#6\t\u0011J\u0003\u0002=\u0015*\u00111\nT\u0001\u0007G>lWn\u001c8\u000b\u0005)j%B\u0001(P\u0003\u0019\t\u0007/Y2iK*\t\u0001+A\u0002pe\u001eL!AU%\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u000b\u0002-B\u0011!iV\u0005\u00031\u001e\u0012Q\"T3uC\u0012\fG/Y\"bG\",\u0017AD7fi\u0006$\u0017\r^1DC\u000eDW\rI\u0001\tu.\u001cE.[3oiV\tA\f\u0005\u0002^A6\taL\u0003\u0002`S\u0005\u0011!p[\u0005\u0003Cz\u0013QbS1gW\u0006T6n\u00117jK:$\u0018!\u0003>l\u00072LWM\u001c;!\u0003\u0019a\u0014N\\5u}Q)QMZ4iSB\u0011!\t\u0001\u0005\u0006\u007f%\u0001\r!\u0011\u0005\u0006y%\u0001\ra\u0012\u0005\u0006)&\u0001\rA\u0016\u0005\u00065&\u0001\r\u0001X\u0001\u000fi>\u0004\u0018n\u0019)ve\u001e\fGo\u001c:z+\u0005a\u0007c\u0001\"n_&\u0011an\n\u0002\u001a\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\u0004VO]4bi>\u0014\u0018\u0010\u0005\u0002Ca&\u0011\u0011o\n\u0002\u0011\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\fq\u0002^8qS\u000e\u0004VO]4bi>\u0014\u0018\u0010I\u0001\u000eC\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u0016\u0003U\u0004\"!\u0018<\n\u0005]t&!D!e[&t'l[\"mS\u0016tG/\u0001\bbI6LgNW6DY&,g\u000e\u001e\u0011\u0002#\r\u0014X-\u0019;f)>\u0004\u0018n\u0019)pY&\u001c\u00170F\u0001|!\rqCP`\u0005\u0003{>\u0012aa\u00149uS>t\u0007cA@\u0002\b5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0004q_2L7-\u001f\u0006\u0003Q1KA!!\u0003\u0002\u0002\t\t2I]3bi\u0016$v\u000e]5d!>d\u0017nY=\u0002%\r\u0014X-\u0019;f)>\u0004\u0018n\u0019)pY&\u001c\u0017\u0010I\u0001\u0012C2$XM]\"p]\u001aLw\rU8mS\u000eLXCAA\t!\u0011qC0a\u0005\u0011\u0007}\f)\"\u0003\u0003\u0002\u0018\u0005\u0005!!E!mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5ds\u0006\u0011\u0012\r\u001c;fe\u000e{gNZ5h!>d\u0017nY=!\u0003eA\u0017m\u001d#fY\u0006LX\r\u001a+pa&\u001cw\n]3sCRLwN\\:\u0016\u0005\u0005}\u0001c\u0001\u0018\u0002\"%\u0019\u00111E\u0018\u0003\u000f\t{w\u000e\\3b]\u0006\tCO]=D_6\u0004H.\u001a;f\t\u0016d\u0017-_3e)>\u0004\u0018nY(qKJ\fG/[8ogR!\u0011\u0011FA\u0018!\rq\u00131F\u0005\u0004\u0003[y#\u0001B+oSRDq!!\r\u0014\u0001\u0004\t\u0019$A\u0003u_BL7\r\u0005\u0003\u00026\u0005\rc\u0002BA\u001c\u0003\u007f\u00012!!\u000f0\u001b\t\tYDC\u0002\u0002>-\na\u0001\u0010:p_Rt\u0014bAA!_\u00051\u0001K]3eK\u001aLA!!\u0012\u0002H\t11\u000b\u001e:j]\u001eT1!!\u00110\u00031\u0019'/Z1uKR{\u0007/[2t))\tI#!\u0014\u0002X\u0005m\u0013\u0011\u0013\u0005\b\u0003\u001f\"\u0002\u0019AA)\u0003\u001d!\u0018.\\3pkR\u00042ALA*\u0013\r\t)f\f\u0002\u0004\u0013:$\bbBA-)\u0001\u0007\u0011qD\u0001\rm\u0006d\u0017\u000eZ1uK>sG.\u001f\u0005\b\u0003;\"\u0002\u0019AA0\u0003!!xn\u0011:fCR,\u0007\u0003CA1\u0003O\n\u0019$a\u001b\u000e\u0005\u0005\r$bAA3_\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00141\r\u0002\u0004\u001b\u0006\u0004\b\u0003BA7\u0003\u0017sA!a\u001c\u0002\u0006:!\u0011\u0011OAA\u001d\u0011\t\u0019(a \u000f\t\u0005U\u0014Q\u0010\b\u0005\u0003o\nYH\u0004\u0003\u0002:\u0005e\u0014\"\u0001)\n\u00059{\u0015B\u0001\u0016N\u0013\tYE*C\u0002\u0002\u0004*\u000bq!\\3tg\u0006<W-\u0003\u0003\u0002\b\u0006%\u0015aF\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$H)\u0019;b\u0015\r\t\u0019IS\u0005\u0005\u0003\u001b\u000byI\u0001\bDe\u0016\fG/\u00192mKR{\u0007/[2\u000b\t\u0005\u001d\u0015\u0011\u0012\u0005\b\u0003'#\u0002\u0019AAK\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u0004/\u0003/\u000bY*!\u000b\n\u0007\u0005euFA\u0005Gk:\u001cG/[8ocAA\u0011\u0011MA4\u0003g\ti\n\u0005\u0003\u0002 \u0006\u0015VBAAQ\u0015\r\t\u0019KS\u0001\te\u0016\fX/Z:ug&!\u0011qUAQ\u0005!\t\u0005/[#se>\u0014\u0018\u0001\u00043fY\u0016$X\rV8qS\u000e\u001cH\u0003CA\u0015\u0003[\u000by+!/\t\u000f\u0005=S\u00031\u0001\u0002R!9\u0011\u0011W\u000bA\u0002\u0005M\u0016A\u0002;pa&\u001c7\u000f\u0005\u0004\u0002b\u0005U\u00161G\u0005\u0005\u0003o\u000b\u0019GA\u0002TKRDq!a%\u0016\u0001\u0004\tY\fE\u0004/\u0003/\u000bi,!\u000b\u0011\u0011\u0005\u0005\u0014qMA\u001a\u0003\u007f\u0003B!!1\u0002H6\u0011\u00111\u0019\u0006\u0004\u0003\u000bT\u0015\u0001\u00039s_R|7m\u001c7\n\t\u0005%\u00171\u0019\u0002\u0007\u000bJ\u0014xN]:\u0002!\r\u0014X-\u0019;f!\u0006\u0014H/\u001b;j_:\u001cH\u0003DA\u0015\u0003\u001f\f\t.!;\u0002l\u0006m\bbBA(-\u0001\u0007\u0011\u0011\u000b\u0005\b\u0003'4\u0002\u0019AAk\u00035qWm\u001e)beRLG/[8ogBA\u0011\u0011MA4\u0003g\t9\u000e\u0005\u0003\u0002Z\u0006\rh\u0002BAn\u0003?tA!!\u001d\u0002^&\u0019\u00111\u0015&\n\t\u0005\u0005\u0018\u0011U\u0001\u0018\u0007J,\u0017\r^3QCJ$\u0018\u000e^5p]N\u0014V-];fgRLA!!:\u0002h\n\u0001\u0002+\u0019:uSRLwN\u001c#fi\u0006LGn\u001d\u0006\u0005\u0003C\f\t\u000bC\u0004\u0002ZY\u0001\r!a\b\t\u000f\u00055h\u00031\u0001\u0002p\u0006aA.[:uK:,'OT1nKB!\u0011\u0011_A|\u001b\t\t\u0019PC\u0002\u0002v*\u000bqA\\3uo>\u00148.\u0003\u0003\u0002z\u0006M(\u0001\u0004'jgR,g.\u001a:OC6,\u0007bBA\u007f-\u0001\u0007\u0011QS\u0001\tG\u0006dGNY1dW\u0006yA-Z:de&\u0014WmQ8oM&<7\u000f\u0006\u0004\u0003\u0004\tu!Q\u0005\t\t\u0003C\n9G!\u0002\u0003\u0010A!!q\u0001B\u0006\u001b\t\u0011IA\u0003\u0002@\u0015&!!Q\u0002B\u0005\u00059\u0019uN\u001c4jOJ+7o\\;sG\u0016\u0004BA!\u0005\u0003\u00189!\u0011q\u0014B\n\u0013\u0011\u0011)\"!)\u0002/\u0011+7o\u0019:jE\u0016\u001cuN\u001c4jON\u0014Vm\u001d9p]N,\u0017\u0002\u0002B\r\u00057\u0011aaQ8oM&<'\u0002\u0002B\u000b\u0003CCqAa\b\u0018\u0001\u0004\u0011\t#A\u000bsKN|WO]2f)>\u001cuN\u001c4jO:\u000bW.Z:\u0011\u0011\u0005\u0005\u0014q\rB\u0003\u0005G\u0001BA\f?\u00024\"9!qE\fA\u0002\u0005}\u0011aD5oG2,H-Z*z]>t\u00170\\:\u0002\u0019\u0005dG/\u001a:D_:4\u0017nZ:\u0015\r\t5\"q\u0006B!!!\t\t'a\u001a\u0003\u0006\u0005u\u0005b\u0002B\u00191\u0001\u0007!1G\u0001\bG>tg-[4t!!\t\t'a\u001a\u0003\u0006\tU\u0002\u0003\u0002B\u001c\u0005{qA!a(\u0003:%!!1HAQ\u0003M\tE\u000e^3s\u0007>tg-[4t%\u0016\fX/Z:u\u0013\u0011\u0011IBa\u0010\u000b\t\tm\u0012\u0011\u0015\u0005\b\u00033B\u0002\u0019AA\u0010\u0003E\tG\u000e^3s)>\u0004\u0018nY\"p]\u001aLwm\u001d\u000b\u000b\u0005\u000f\u0012iE!\u0015\u0003T\t\u001d\u0004c\u0002\u0018\u0003J\t\u0015\u0011QT\u0005\u0004\u0005\u0017z#A\u0002+va2,'\u0007C\u0004\u0003Pe\u0001\rA!\u0002\u0002\u0011I,7o\\;sG\u0016Dq!!\u0017\u001a\u0001\u0004\ty\u0002C\u0004\u0003Ve\u0001\rAa\u0016\u0002\u0017\r|gNZ5h!J|\u0007o\u001d\t\u0005\u00053\u0012\u0019'\u0004\u0002\u0003\\)!!Q\fB0\u0003\u0011)H/\u001b7\u000b\u0005\t\u0005\u0014\u0001\u00026bm\u0006LAA!\u001a\u0003\\\tQ\u0001K]8qKJ$\u0018.Z:\t\u000f\t%\u0014\u00041\u0001\u0003l\u0005\u00012m\u001c8gS\u001e,e\u000e\u001e:jKNl\u0015\r\u001d\t\t\u0003C\n9'a\r\u00024\u0005\u0011\u0012\r\u001c;fe\n\u0013xn[3s\u0007>tg-[4t))\u00119E!\u001d\u0003t\tU$q\u000f\u0005\b\u0005\u001fR\u0002\u0019\u0001B\u0003\u0011\u001d\tIF\u0007a\u0001\u0003?AqA!\u0016\u001b\u0001\u0004\u00119\u0006C\u0004\u0003ji\u0001\rAa\u001b\u0002\u0017\u001d,GO\u0011:pW\u0016\u0014\u0018\n\u001a\u000b\u0005\u0005{\u0012y\b\u0005\u0003/y\u0006E\u0003b\u0002B(7\u0001\u0007!QA\u0001\u0015m\u0006d\u0017\u000eZ1uK\u000e{gNZ5h!>d\u0017nY=\u0015\r\u0005%\"Q\u0011BD\u0011\u001d\u0011y\u0005\ba\u0001\u0005\u000bAqA!\u001b\u001d\u0001\u0004\u0011Y'A\fj]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5hgR1!Q\u0006BG\u0005gCqA!\r\u001e\u0001\u0004\u0011y\t\u0005\u0005\u0002b\u0005\u001d$Q\u0001BI!\u0019\u0011\u0019J!(\u0003$:!!Q\u0013BM\u001d\u0011\tIDa&\n\u0003AJ1Aa'0\u0003\u001d\u0001\u0018mY6bO\u0016LAAa(\u0003\"\n!A*[:u\u0015\r\u0011Yj\f\t\u0005\u0005K\u0013y+\u0004\u0002\u0003(*!!\u0011\u0016BV\u0003\u0015\tG-\\5o\u0015\r\u0011i\u000bT\u0001\bG2LWM\u001c;t\u0013\u0011\u0011\tLa*\u0003\u001b\u0005cG/\u001a:D_:4\u0017nZ(q\u0011\u001d\tI&\ba\u0001\u0003?\t\u0011\u0004\u001d:fa\u0006\u0014X-\u00138de\u0016lWM\u001c;bY\u000e{gNZ5hgRA\u0011\u0011\u0006B]\u0005{\u0013y\fC\u0004\u0003<z\u0001\rA!%\u0002\u001d\u0005dG/\u001a:D_:4\u0017nZ(qg\"9!Q\u000b\u0010A\u0002\t]\u0003b\u0002Ba=\u0001\u0007!1Y\u0001\u000bG>tg-[4LKf\u001c\b\u0003CA1\u0003O\n\u0019D!2\u0011\t\t\u001d'\u0011\u001b\b\u0005\u0005\u0013\u0014iM\u0004\u0003\u0002r\t-\u0017BA K\u0013\u0011\u0011yM!\u0003\u0002\u0013\r{gNZ5h\t\u00164\u0017\u0002\u0002Bj\u0005+\u0014\u0011bQ8oM&<7*Z=\u000b\t\t='\u0011B\u0001\tg\",H\u000fZ8x]R\u0011\u0011\u0011F\u0001\u0017e\u0016\u001cx.\u001e:dK:\u000bW.\u001a+p\u0005J|7.\u001a:JIR!\u0011\u0011\u000bBp\u0011\u001d\u0011\t\u000f\ta\u0001\u0003g\tAB]3t_V\u00148-\u001a(b[\u0016\faB\u0019:pW\u0016\u00148+\u001f8p]fl7\u000f\u0006\u0003\u0003h\n%\bC\u0002BJ\u0005;\u000b\u0019\u0004C\u0004\u0003l\u0006\u0002\r!a\r\u0002\t9\fW.Z\u0001\u000bG>tg-[4UsB,GC\u0002By\u0005s\u0014Y\u0010\u0005\u0003\u0003t\nUh\u0002\u0002B\u0004\u0005\u001bLAAa>\u0003V\n!A+\u001f9f\u0011\u001d\u0011YO\ta\u0001\u0003gAqA!@#\u0001\u0004\u00119/\u0001\u0005ts:|g._7t\u00039\u0019wN\u001c4jONKhn\u001c8z[N$\u0002ba\u0001\u0004\f\r51q\u0002\t\u0007\u0005'\u0013ij!\u0002\u0011\t\tE1qA\u0005\u0005\u0007\u0013\u0011YBA\u0007D_:4\u0017nZ*z]>t\u00170\u001c\u0005\b\u0005W\u001c\u0003\u0019AA\u001a\u0011\u001d\u0011ip\ta\u0001\u0005ODqa!\u0005$\u0001\u0004\ty\"A\u0006jgN+gn]5uSZ,\u0017AF2sK\u0006$X\rV8qS\u000e\u001cuN\u001c4jO\u0016sGO]=\u0015\u0011\r]11FB\u001e\u0007\u007f!ba!\u0007\u0004 \r\u0005\u0002\u0003\u0002B\t\u00077IAa!\b\u0003\u001c\tY1i\u001c8gS\u001e,e\u000e\u001e:z\u0011\u001d\u0011Y\u000f\na\u0001\u0003gAqaa\t%\u0001\u0004\u0019)#A\u0003wC2,X\rE\u0002/\u0007OI1a!\u000b0\u0005\r\te.\u001f\u0005\b\u0007[!\u0003\u0019AB\u0018\u0003%awnZ\"p]\u001aLw\r\u0005\u0003\u00042\r]RBAB\u001a\u0015\r\u0019)$K\u0001\u0004Y><\u0017\u0002BB\u001d\u0007g\u0011\u0011\u0002T8h\u0007>tg-[4\t\u000f\ruB\u00051\u0001\u0003X\u0005QAo\u001c9jGB\u0013x\u000e]:\t\u000f\t\u001dB\u00051\u0001\u0002 \u000592M]3bi\u0016\u0014%o\\6fe\u000e{gNZ5h\u000b:$(/\u001f\u000b\u0007\u0007\u000b\u001aYea\u0014\u0015\r\re1qIB%\u0011\u001d\u0011Y/\na\u0001\u0003gAqaa\t&\u0001\u0004\u0019)\u0003C\u0004\u0004N\u0015\u0002\r!a\b\u0002\u001fA,'O\u0011:pW\u0016\u00148i\u001c8gS\u001eDqAa\n&\u0001\u0004\ty\u0002")
public class AdminManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MetadataCache metadataCache;
    private final KafkaZkClient zkClient;
    private final DelayedOperationPurgatory<DelayedOperation> topicPurgatory;
    private final AdminZkClient adminZkClient;
    private final Option<CreateTopicPolicy> createTopicPolicy;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AdminManager adminManager = this;
        synchronized (adminManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private DelayedOperationPurgatory<DelayedOperation> topicPurgatory() {
        return this.topicPurgatory;
    }

    private AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    private Option<CreateTopicPolicy> createTopicPolicy() {
        return this.createTopicPolicy;
    }

    private Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public boolean hasDelayedTopicOperations() {
        return this.topicPurgatory().delayed() != 0;
    }

    public void tryCompleteDelayedTopicOperations(String topic) {
        TopicKey key = new TopicKey(topic);
        int completed = this.topicPurgatory().checkAndComplete(key);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Request key ").append(key.keyLabel()).append(" unblocked ").append(completed).append(" topic requests.").toString());
    }

    public void createTopics(int timeout, boolean validateOnly, Map<String, CreateTopicsRequestData.CreatableTopic> toCreate, Function1<Map<String, ApiError>, BoxedUnit> responseCallback) {
        Seq brokers = (Seq)this.metadataCache().getAliveBrokers().map((Function1 & Serializable & scala.Serializable)b -> new BrokerMetadata(b.id(), b.rack()), Seq$.MODULE$.canBuildFrom());
        Iterable metadata = (Iterable)toCreate.values().map((Function1 & Serializable & scala.Serializable)topic -> {
            CreatePartitionsMetadata createPartitionsMetadata;
            try {
                scala.collection.mutable.HashMap hashMap;
                Properties configs = new Properties();
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)topic.configs()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    CreateTopicsRequestData.CreateableTopicConfig createableTopicConfig = x0$1;
                    Object object = configs.setProperty(createableTopicConfig.name(), createableTopicConfig.value());
                    return object;
                });
                LogConfig$.MODULE$.validate(configs);
                if (!(topic.numPartitions() == -1 && topic.replicationFactor() == -1 || topic.assignments().isEmpty())) {
                    throw new InvalidRequestException("Both numPartitions or replicationFactor and replicasAssignments were set. Both cannot be used at the same time.");
                }
                if (topic.assignments().isEmpty()) {
                    hashMap = AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)brokers, topic.numPartitions(), topic.replicationFactor(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
                } else {
                    scala.collection.mutable.HashMap assignments = new scala.collection.mutable.HashMap();
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)topic.assignments()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        AdminManager.$anonfun$createTopics$4(assignments, x0$2);
                        return BoxedUnit.UNIT;
                    });
                    hashMap = assignments;
                }
                scala.collection.mutable.HashMap assignments = hashMap;
                this.trace((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> AdminManager.$anonfun$createTopics$6(topic, (Map)assignments)));
                Option<CreateTopicPolicy> option = this.createTopicPolicy();
                if (option instanceof Some) {
                    BoxedUnit boxedUnit;
                    HashMap hashMap2;
                    Short replicationFactor;
                    Some some = (Some)option;
                    CreateTopicPolicy policy = (CreateTopicPolicy)some.value();
                    this.adminZkClient().validateTopicCreate(topic.name(), (Map<Object, Seq<Object>>)assignments, configs);
                    Integer numPartitions = topic.numPartitions() == -1 ? null : Predef$.MODULE$.int2Integer(topic.numPartitions());
                    Short s = replicationFactor = topic.replicationFactor() == -1 ? null : Predef$.MODULE$.short2Short(topic.replicationFactor());
                    if (topic.assignments().isEmpty()) {
                        hashMap2 = null;
                    } else {
                        HashMap map = new HashMap();
                        assignments.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                            Tuple2 tuple2 = x0$3;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            int k = tuple2._1$mcI$sp();
                            Seq v = (Seq)tuple2._2();
                            ArrayList list = new ArrayList();
                            v.foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x0$4 -> {
                                int n = x0$4;
                                boolean bl = list.add(n);
                                return bl;
                            });
                            java.util.List list2 = map.put(Predef$.MODULE$.int2Integer(k), list);
                            return list2;
                        });
                        hashMap2 = map;
                    }
                    HashMap javaAssignments = hashMap2;
                    HashMap javaConfigs = new HashMap();
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)topic.configs()).asScala()).foreach((Function1 & Serializable & scala.Serializable)config -> javaConfigs.put(config.name(), config.value()));
                    policy.validate(new CreateTopicPolicy.RequestMetadata(topic.name(), numPartitions, replicationFactor, javaAssignments, javaConfigs));
                    if (!validateOnly) {
                        this.adminZkClient().createTopicWithAssignment(topic.name(), configs, (Map<Object, Seq<Object>>)assignments);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit;
                    if (validateOnly) {
                        this.adminZkClient().validateTopicCreate(topic.name(), (Map<Object, Seq<Object>>)assignments, configs);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.adminZkClient().createTopicWithAssignment(topic.name(), configs, (Map<Object, Seq<Object>>)assignments);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                } else {
                    throw new MatchError(option);
                }
                createPartitionsMetadata = new CreatePartitionsMetadata(topic.name(), (Map<Object, Seq<Object>>)assignments, ApiError.NONE);
            }
            catch (ApiException e) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error processing create topic request ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                createPartitionsMetadata = new CreatePartitionsMetadata(topic.name(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)), ApiError.fromThrowable((Throwable)e));
            }
            catch (ConfigException e) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error processing create topic request ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                createPartitionsMetadata = new CreatePartitionsMetadata(topic.name(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)), ApiError.fromThrowable((Throwable)new InvalidConfigurationException(e.getMessage(), e.getCause())));
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error processing create topic request ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                createPartitionsMetadata = new CreatePartitionsMetadata(topic.name(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)), ApiError.fromThrowable((Throwable)e));
            }
            return createPartitionsMetadata;
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createTopics$16(x$1)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)createTopicMetadata -> createTopicMetadata.error().isSuccess() && !validateOnly ? new Tuple2((Object)createTopicMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2((Object)createTopicMetadata.topic(), (Object)createTopicMetadata.error()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        } else {
            DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedCreateKeys = ((TraversableOnce)toCreate.values().map((Function1 & Serializable & scala.Serializable)topic -> new TopicKey(topic.name()), Iterable$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
        }
    }

    public void deleteTopics(int timeout, Set<String> topics, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        Set metadata = (Set)topics.map((Function1 & Serializable & scala.Serializable)topic -> {
            DeleteTopicMetadata deleteTopicMetadata;
            try {
                this.adminZkClient().deleteTopic((String)topic);
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Error processing delete topic request for topic ").append((String)topic).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.forException((Throwable)e));
            }
            return deleteTopicMetadata;
        }, Set$.MODULE$.canBuildFrom());
        if (timeout <= 0 || !metadata.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$deleteTopics$4(x$2)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)deleteTopicMetadata -> {
                Errors errors = deleteTopicMetadata.error();
                Errors errors2 = Errors.NONE;
                return !(errors != null ? !errors.equals(errors2) : errors2 != null) ? new Tuple2((Object)deleteTopicMetadata.topic(), (Object)Errors.REQUEST_TIMED_OUT) : new Tuple2((Object)deleteTopicMetadata.topic(), (Object)deleteTopicMetadata.error());
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        } else {
            DelayedDeleteTopics delayedDelete = new DelayedDeleteTopics(timeout, (Seq<DeleteTopicMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedDeleteKeys = ((SetLike)topics.map((Function1 & Serializable & scala.Serializable)x$3 -> new TopicKey((String)x$3), Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedDelete, (Seq<Object>)delayedDeleteKeys);
        }
    }

    public void createPartitions(int timeout, Map<String, CreatePartitionsRequest.PartitionDetails> newPartitions, boolean validateOnly, ListenerName listenerName, Function1<Map<String, ApiError>, BoxedUnit> callback) {
        boolean reassignPartitionsInProgress = this.zkClient().reassignPartitionsInProgress();
        Seq<BrokerMetadata> allBrokers = this.adminZkClient().getBrokerMetadatas(this.adminZkClient().getBrokerMetadatas$default$1(), this.adminZkClient().getBrokerMetadatas$default$2());
        Seq allBrokerIds = (Seq)allBrokers.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Seq$.MODULE$.canBuildFrom());
        Iterable metadata = (Iterable)newPartitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CreatePartitionsMetadata createPartitionsMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String topic = (String)tuple2._1();
                CreatePartitionsRequest.PartitionDetails newPartition = (CreatePartitionsRequest.PartitionDetails)tuple2._2();
                try {
                    if (reassignPartitionsInProgress) {
                        throw new ReassignmentInProgressException("A partition reassignment is in progress.");
                    }
                    scala.collection.immutable.Map existingAssignment = (scala.collection.immutable.Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)scala.collection.immutable.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        TopicPartition topicPartition = (TopicPartition)tuple2._1();
                        Seq replicas = (Seq)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (Object)replicas);
                        return tuple22;
                    }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                    if (existingAssignment.isEmpty()) {
                        throw new UnknownTopicOrPartitionException(new StringBuilder(28).append("The topic '").append(topic).append("' does not exist.").toString());
                    }
                    int oldNumPartitions = existingAssignment.size();
                    int newNumPartitions = newPartition.totalCount();
                    int numPartitionsIncrement = newNumPartitions - oldNumPartitions;
                    if (numPartitionsIncrement < 0) {
                        throw new InvalidPartitionsException(new StringBuilder(69).append("Topic currently has ").append(oldNumPartitions).append(" partitions, which is higher than the requested ").append(newNumPartitions).append(".").toString());
                    }
                    if (numPartitionsIncrement == 0) {
                        throw new InvalidPartitionsException(new StringBuilder(30).append("Topic already has ").append(oldNumPartitions).append(" partitions.").toString());
                    }
                    Option reassignment = Option$.MODULE$.apply((Object)newPartition.newAssignments()).map((Function1 & Serializable & scala.Serializable)x$5 -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$5).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$6).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$7)), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)assignments -> {
                        scala.collection.immutable.Set unknownBrokers = (scala.collection.immutable.Set)((TraversableOnce)assignments.flatten((Function1)Predef$.MODULE$.$conforms())).toSet().$minus$minus((GenTraversableOnce)allBrokerIds);
                        if (unknownBrokers.nonEmpty()) {
                            throw new InvalidReplicaAssignmentException(new StringBuilder(42).append("Unknown broker(s) in replica assignment: ").append(unknownBrokers.mkString(", ")).append(".").toString());
                        }
                        if (assignments.size() != numPartitionsIncrement) {
                            throw new InvalidReplicaAssignmentException(new StringBuilder(40).append("Increasing the number of partitions by ").append(numPartitionsIncrement).append(" ").append(new StringBuilder(26).append("but ").append(assignments.size()).append(" assignments provided.").toString()).toString());
                        }
                        return ((TraversableOnce)((TraversableLike)assignments.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                            Tuple2 tuple2 = x0$3;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Buffer replicas = (Buffer)tuple2._1();
                            int index = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(existingAssignment.size() + index))), (Object)replicas);
                            return tuple22;
                        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    });
                    Map<Object, Seq<Object>> updatedReplicaAssignment = this.adminZkClient().addPartitions(topic, (Map<Object, Seq<Object>>)existingAssignment, allBrokers, newPartition.totalCount(), (Option<Map<Object, Seq<Object>>>)reassignment, validateOnly);
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, updatedReplicaAssignment, ApiError.NONE);
                }
                catch (AdminOperationException e) {
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)Map$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
                }
                catch (ApiException e) {
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)Map$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            CreatePartitionsMetadata createPartitionsMetadata2 = createPartitionsMetadata;
            return createPartitionsMetadata2;
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createPartitions$9(x$8)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)createPartitionMetadata -> createPartitionMetadata.error().isSuccess() && !validateOnly ? new Tuple2((Object)createPartitionMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2((Object)createPartitionMetadata.topic(), (Object)createPartitionMetadata.error()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            callback.apply((Object)results);
        } else {
            DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata.toSeq(), this, callback);
            Seq delayedCreateKeys = ((SetLike)newPartitions.keySet().map((Function1 & Serializable & scala.Serializable)x$9 -> new TopicKey((String)x$9), Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
        }
    }

    public Map<ConfigResource, DescribeConfigsResponse.Config> describeConfigs(Map<ConfigResource, Option<Set<String>>> resourceToConfigNames, boolean includeSynonyms) {
        return ((TraversableOnce)resourceToConfigNames.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 != null) {
                ConfigResource resource = (ConfigResource)tuple22._1();
                Option configNames = (Option)tuple22._2();
                try {
                    DescribeConfigsResponse.Config config;
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        DescribeConfigsResponse.Config config2;
                        String topic = resource.name();
                        Topic.validate((String)topic);
                        if (this.metadataCache().contains(topic)) {
                            Properties topicProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
                            LogConfig logConfig = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog(this.config()), topicProps);
                            config2 = AdminManager.createResponseConfig$1((Map)AdminManager.allConfigs$1(logConfig), (Function2 & Serializable & scala.Serializable)(name, value) -> this.createTopicConfigEntry(logConfig, topicProps, includeSynonyms, (String)name, value), configNames);
                        } else {
                            config2 = new DescribeConfigsResponse.Config(new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, null), Collections.emptyList());
                        }
                        config = config2;
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        DescribeConfigsResponse.Config config3;
                        if (resource.name() == null || resource.name().isEmpty()) {
                            config3 = AdminManager.createResponseConfig$1(this.config().dynamicConfig().currentDynamicDefaultConfigs(), (Function2 & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(false, includeSynonyms, (String)name, value), configNames);
                        } else if (this.resourceNameToBrokerId(resource.name()) == this.config().brokerId()) {
                            config3 = AdminManager.createResponseConfig$1((Map)AdminManager.allConfigs$1(this.config()), (Function2 & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(true, includeSynonyms, (String)name, value), configNames);
                        } else {
                            throw new InvalidRequestException(new StringBuilder(67).append("Unexpected broker id, expected ").append(this.config().brokerId()).append(" or empty string, but received ").append(resource).append(".name").toString());
                        }
                        config = config3;
                    } else {
                        throw new InvalidRequestException(new StringBuilder(27).append("Unsupported resource type: ").append(type).toString());
                    }
                    DescribeConfigsResponse.Config resourceConfig = config;
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)resourceConfig);
                }
                catch (Throwable e) {
                    String message = new StringBuilder(55).append("Error processing describe configs request for resource ").append(resource).toString();
                    if (e instanceof ApiException) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    } else {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    }
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)new DescribeConfigsResponse.Config(ApiError.fromThrowable((Throwable)e), Collections.emptyList()));
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple23 = tuple2;
            return tuple23;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<ConfigResource, ApiError> alterConfigs(Map<ConfigResource, AlterConfigsRequest.Config> configs, boolean validateOnly) {
        return ((TraversableOnce)configs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 != null) {
                ConfigResource resource = (ConfigResource)tuple22._1();
                AlterConfigsRequest.Config config = (AlterConfigsRequest.Config)tuple22._2();
                try {
                    Tuple2 tuple23;
                    scala.collection.immutable.Map configEntriesMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.name(), (Object)entry.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    Properties configProps = new Properties();
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1 & Serializable & scala.Serializable)configEntry -> configProps.setProperty(configEntry.name(), configEntry.value()));
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        tuple23 = this.alterTopicConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap);
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        tuple23 = this.alterBrokerConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap);
                    } else {
                        throw new InvalidRequestException(new StringBuilder(76).append("AlterConfigs is only supported for topics and brokers, but resource type is ").append(type).toString());
                    }
                    tuple2 = tuple23;
                }
                catch (Throwable throwable) {
                    Tuple2 tuple24;
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof ConfigException ? true : throwable2 instanceof IllegalArgumentException;
                    if (bl) {
                        String message = new StringBuilder(36).append("Invalid config value for resource ").append(resource).append(": ").append(throwable2.getMessage()).toString();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                        tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.fromThrowable((Throwable)new InvalidRequestException(message, throwable2)));
                    } else if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        String message = new StringBuilder(61).append("Error processing alter configs request for resource ").append(resource).append(", config ").append(config).toString();
                        if (throwable3 instanceof ApiException) {
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                        } else {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                        }
                        tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.fromThrowable((Throwable)throwable3));
                    } else {
                        throw throwable;
                    }
                    tuple2 = tuple24;
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple25 = tuple2;
            return tuple25;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Tuple2<ConfigResource, ApiError> alterTopicConfigs(ConfigResource resource, boolean validateOnly, Properties configProps, Map<String, String> configEntriesMap) {
        block0: {
            String topic = resource.name();
            this.adminZkClient().validateTopicConfig(topic, configProps);
            this.validateConfigPolicy(resource, configEntriesMap);
            if (validateOnly) break block0;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Updating topic ").append(topic).append(" with new configuration ").append((Object)this.config()).toString());
            this.adminZkClient().changeTopicConfig(topic, configProps);
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.NONE);
    }

    private Tuple2<ConfigResource, ApiError> alterBrokerConfigs(ConfigResource resource, boolean validateOnly, Properties configProps, Map<String, String> configEntriesMap) {
        block1: {
            Option<Object> brokerId = this.getBrokerId(resource);
            boolean perBrokerConfig = brokerId.nonEmpty();
            this.config().dynamicConfig().validate(configProps, perBrokerConfig);
            this.validateConfigPolicy(resource, configEntriesMap);
            if (validateOnly) break block1;
            if (perBrokerConfig) {
                this.config().dynamicConfig().reloadUpdatedFilesWithoutConfigChange(configProps);
            }
            this.adminZkClient().changeBrokerConfig(brokerId, this.config().dynamicConfig().toPersistentProps(configProps, perBrokerConfig));
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.NONE);
    }

    private Option<Object> getBrokerId(ConfigResource resource) {
        None$ none$;
        if (resource.name() == null || resource.name().isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            int id = this.resourceNameToBrokerId(resource.name());
            if (id != this.config().brokerId()) {
                throw new InvalidRequestException(new StringBuilder(51).append("Unexpected broker id, expected ").append(this.config().brokerId()).append(", but received ").append(resource).append(".name").toString());
            }
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)id));
        }
        return none$;
    }

    private void validateConfigPolicy(ConfigResource resource, Map<String, String> configEntriesMap) {
        Option<AlterConfigPolicy> option = this.alterConfigPolicy();
        if (option instanceof Some) {
            Some some = (Some)option;
            AlterConfigPolicy policy = (AlterConfigPolicy)some.value();
            policy.validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(resource.type(), resource.name()), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(configEntriesMap).asJava()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public Map<ConfigResource, ApiError> incrementalAlterConfigs(Map<ConfigResource, List<AlterConfigOp>> configs, boolean validateOnly) {
        return ((TraversableOnce)configs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2<ConfigResource, ApiError> tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 != null) {
                ConfigResource resource = (ConfigResource)tuple22._1();
                List alterConfigOps = (List)tuple22._2();
                try {
                    Tuple2<ConfigResource, ApiError> tuple23;
                    scala.collection.immutable.Set duplicateKeys = ((MapLike)alterConfigOps.groupBy((Function1 & Serializable & scala.Serializable)config -> config.configEntry().name()).mapValues((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.size())).filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$incrementalAlterConfigs$4(x$13)))).keys().toSet();
                    if (duplicateKeys.nonEmpty()) {
                        throw new InvalidRequestException(new StringBuilder(37).append("Error due to duplicate config keys : ").append(duplicateKeys.mkString(",")).toString());
                    }
                    scala.collection.immutable.Map configEntriesMap = ((TraversableOnce)alterConfigOps.map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.configEntry().name(), (Object)entry.configEntry().value()), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        Properties configProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), resource.name());
                        this.prepareIncrementalConfigs((List<AlterConfigOp>)alterConfigOps, configProps, LogConfig$.MODULE$.configKeys());
                        tuple23 = this.alterTopicConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap);
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        Option<Object> brokerId = this.getBrokerId(resource);
                        boolean perBrokerConfig = brokerId.nonEmpty();
                        Properties persistentProps = perBrokerConfig ? this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Broker(), brokerId.get().toString()) : this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Broker(), ConfigEntityName$.MODULE$.Default());
                        Properties configProps = this.config().dynamicConfig().fromPersistentProps(persistentProps, perBrokerConfig);
                        this.prepareIncrementalConfigs((List<AlterConfigOp>)alterConfigOps, configProps, KafkaConfig$.MODULE$.configKeys());
                        tuple23 = this.alterBrokerConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap);
                    } else {
                        throw new InvalidRequestException(new StringBuilder(76).append("AlterConfigs is only supported for topics and brokers, but resource type is ").append(type).toString());
                    }
                    tuple2 = tuple23;
                }
                catch (Throwable throwable) {
                    Tuple2<ConfigResource, ApiError> tuple24;
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof ConfigException ? true : throwable2 instanceof IllegalArgumentException;
                    if (bl) {
                        String message = new StringBuilder(36).append("Invalid config value for resource ").append(resource).append(": ").append(throwable2.getMessage()).toString();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                        tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.fromThrowable((Throwable)new InvalidRequestException(message, throwable2)));
                    } else if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        String message = new StringBuilder(61).append("Error processing alter configs request for resource ").append(resource).append(", config ").append(alterConfigOps).toString();
                        if (throwable3 instanceof ApiException) {
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                        } else {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                        }
                        tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.fromThrowable((Throwable)throwable3));
                    } else {
                        throw throwable;
                    }
                    tuple2 = tuple24;
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2<ConfigResource, ApiError> tuple25 = tuple2;
            return tuple25;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private void prepareIncrementalConfigs(List<AlterConfigOp> alterConfigOps, Properties configProps, Map<String, ConfigDef.ConfigKey> configKeys) {
        alterConfigOps.foreach((Function1 & Serializable & scala.Serializable)alterConfigOp -> {
            Object object;
            AlterConfigOp.OpType opType = alterConfigOp.opType();
            if (AlterConfigOp.OpType.SET.equals(opType)) {
                object = configProps.setProperty(alterConfigOp.configEntry().name(), alterConfigOp.configEntry().value());
            } else if (AlterConfigOp.OpType.DELETE.equals(opType)) {
                object = configProps.remove(alterConfigOp.configEntry().name());
            } else if (AlterConfigOp.OpType.APPEND.equals(opType)) {
                List oldValueList;
                if (!AdminManager.listType$1(alterConfigOp.configEntry().name(), configKeys)) {
                    throw new InvalidRequestException(new StringBuilder(51).append("Config value append is not allowed for config key: ").append(alterConfigOp.configEntry().name()).toString());
                }
                List list = oldValueList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configProps.getProperty(alterConfigOp.configEntry().name()).split(","))).toList();
                List newValueList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterConfigOp.configEntry().value().split(","))).toList().$colon$colon$colon(list);
                object = configProps.setProperty(alterConfigOp.configEntry().name(), newValueList.mkString(","));
            } else if (AlterConfigOp.OpType.SUBTRACT.equals(opType)) {
                if (!AdminManager.listType$1(alterConfigOp.configEntry().name(), configKeys)) {
                    throw new InvalidRequestException(new StringBuilder(53).append("Config value subtract is not allowed for config key: ").append(alterConfigOp.configEntry().name()).toString());
                }
                List oldValueList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configProps.getProperty(alterConfigOp.configEntry().name()).split(","))).toList();
                List newValueList = (List)oldValueList.diff((GenSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterConfigOp.configEntry().value().split(","))).toList());
                object = configProps.setProperty(alterConfigOp.configEntry().name(), newValueList.mkString(","));
            } else {
                throw new MatchError((Object)opType);
            }
            return object;
        });
    }

    public void shutdown() {
        this.topicPurgatory().shutdown();
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.createTopicPolicy().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            x$15.close();
            return BoxedUnit.UNIT;
        }), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterConfigPolicy().foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            x$16.close();
            return BoxedUnit.UNIT;
        }), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    private int resourceNameToBrokerId(String resourceName) {
        int n;
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(resourceName)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringBuilder(41).append("Broker id must be an integer, but it is: ").append(resourceName).toString());
        }
        return n;
    }

    private List<String> brokerSynonyms(String name) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
    }

    private ConfigDef.Type configType(String name, List<String> synonyms) {
        ConfigDef.Type configType = this.config().typeOf(name);
        return configType != null ? configType : (ConfigDef.Type)synonyms.iterator().map((Function1 & Serializable & scala.Serializable)x$1 -> this.config().typeOf((String)x$1)).find((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$configType$2(x$17))).orNull(Predef$.MODULE$.$conforms());
    }

    private List<DescribeConfigsResponse.ConfigSynonym> configSynonyms(String name2, List<String> synonyms, boolean isSensitive) {
        DynamicBrokerConfig dynamicConfig = this.config().dynamicConfig();
        Buffer allSynonyms = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map<String, String> map = dynamicConfig.currentDynamicBrokerConfigs();
        synonyms.foreach((Function1 & Serializable & scala.Serializable)name -> {
            AdminManager.maybeAddSynonym$1(map, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        Map<String, String> map2 = dynamicConfig.currentDynamicDefaultConfigs();
        synonyms.foreach((Function1 & Serializable & scala.Serializable)name -> {
            AdminManager.maybeAddSynonym$1(map2, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1 & Serializable & scala.Serializable)name -> {
            AdminManager.maybeAddSynonym$1(dynamicConfig.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1 & Serializable & scala.Serializable)name -> {
            AdminManager.maybeAddSynonym$1(dynamicConfig.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        return ((TraversableOnce)allSynonyms.dropWhile((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$configSynonyms$6(name2, s)))).toList();
    }

    private DescribeConfigsResponse.ConfigEntry createTopicConfigEntry(LogConfig logConfig, Properties topicProps, boolean includeSynonyms, String name, Object value) {
        List list;
        ConfigDef.Type configEntryType;
        ConfigDef.Type type = configEntryType = logConfig.typeOf(name);
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        boolean isSensitive = !(type != null ? !type.equals(type2) : type2 != null);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value, (ConfigDef.Type)configEntryType);
        List list2 = (List)LogConfig$.MODULE$.TopicConfigSynonyms().get((Object)name).map((Function1 & Serializable & scala.Serializable)s -> this.configSynonyms((String)s, this.brokerSynonyms((String)s), isSensitive)).getOrElse((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty());
        if (!topicProps.containsKey(name)) {
            list = list2;
        } else {
            DescribeConfigsResponse.ConfigSynonym configSynonym = new DescribeConfigsResponse.ConfigSynonym(name, valueAsString, DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG);
            list = (List)list2.$plus$colon((Object)configSynonym, List$.MODULE$.canBuildFrom());
        }
        List allSynonyms = list;
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        List synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, false, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava());
    }

    private DescribeConfigsResponse.ConfigEntry createBrokerConfigEntry(boolean perBrokerConfig, boolean includeSynonyms, String name, Object value) {
        String string;
        boolean isSensitive;
        ConfigDef.Type configEntryType;
        List<String> allNames = this.brokerSynonyms(name);
        ConfigDef.Type type = configEntryType = this.configType(name, allNames);
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        boolean bl = !(type == null ? type2 != null : !type.equals(type2)) || configEntryType == null ? true : (isSensitive = false);
        if (isSensitive) {
            string = null;
        } else {
            String string2;
            Object object = value;
            String string3 = object instanceof String ? (string2 = (String)object) : ConfigDef.convertToString((Object)value, (ConfigDef.Type)configEntryType);
            string = string3;
        }
        String valueAsString = string;
        List allSynonyms = (List)this.configSynonyms(name, allNames, isSensitive).filter((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createBrokerConfigEntry$1(perBrokerConfig, x$19)));
        List synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        boolean readOnly = !allNames.exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createBrokerConfigEntry$2(elem)));
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, readOnly, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava());
    }

    public static final /* synthetic */ void $anonfun$createTopics$4(scala.collection.mutable.HashMap assignments$1, CreateTopicsRequestData.CreatableReplicaAssignment x0$2) {
        CreateTopicsRequestData.CreatableReplicaAssignment creatableReplicaAssignment = x0$2;
        assignments$1.update((Object)BoxesRunTime.boxToInteger((int)creatableReplicaAssignment.partitionIndex()), ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(creatableReplicaAssignment.brokerIds()).asScala()).map((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(a)), Buffer$.MODULE$.canBuildFrom()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$createTopics$6(CreateTopicsRequestData.CreatableTopic topic$1, Map assignments$2) {
        return new StringBuilder(28).append("Assignments for topic ").append(topic$1).append(" are ").append(assignments$2).append(" ").toString();
    }

    public static final /* synthetic */ boolean $anonfun$createTopics$16(CreatePartitionsMetadata x$1) {
        return x$1.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$deleteTopics$4(DeleteTopicMetadata x$2) {
        Errors errors = x$2.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createPartitions$9(CreatePartitionsMetadata x$8) {
        return x$8.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$2(Tuple2 x$10) {
        return x$10._2() != null;
    }

    private static final scala.collection.mutable.Map allConfigs$1(AbstractConfig config) {
        return ((scala.collection.mutable.MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.originals()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$2(x$10)))).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.values()).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$3(Option configNames$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String configName = (String)tuple2._1();
        boolean bl = configNames$1.forall((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.contains((Object)configName)));
        return bl;
    }

    private static final DescribeConfigsResponse.Config createResponseConfig$1(Map configs, Function2 createConfigEntry, Option configNames$1) {
        IndexedSeq filteredConfigPairs = ((TraversableOnce)configs.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$3(configNames$1, x0$1)))).toIndexedSeq();
        IndexedSeq configEntries = (IndexedSeq)filteredConfigPairs.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            Object value = tuple2._2();
            DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createConfigEntry.apply((Object)name, value);
            return configEntry;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)configEntries).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$incrementalAlterConfigs$4(Tuple2 x$13) {
        return x$13._2$mcI$sp() > 1;
    }

    private static final boolean listType$1(String configName, Map configKeys) {
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configKeys.apply((Object)configName);
        if (configKey == null) {
            throw new InvalidConfigurationException(new StringBuilder(27).append("Unknown topic config name: ").append(configName).toString());
        }
        ConfigDef.Type type = configKey.type;
        ConfigDef.Type type2 = ConfigDef.Type.LIST;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$configType$2(ConfigDef.Type x$17) {
        return x$17 != null;
    }

    private static final void maybeAddSynonym$1(Map map, DescribeConfigsResponse.ConfigSource source, String name, boolean isSensitive$1, Buffer allSynonyms$1) {
        map.get((Object)name).map((Function1 & Serializable & scala.Serializable)value -> {
            String configValue = isSensitive$1 ? null : value;
            return allSynonyms$1.$plus$eq((Object)new DescribeConfigsResponse.ConfigSynonym(name, configValue, source));
        });
    }

    public static final /* synthetic */ boolean $anonfun$configSynonyms$6(String name$2, DescribeConfigsResponse.ConfigSynonym s) {
        String string = s.name();
        String string2 = name$2;
        return string == null ? string2 != null : !string.equals(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$1(boolean perBrokerConfig$1, DescribeConfigsResponse.ConfigSynonym x$19) {
        if (perBrokerConfig$1) return true;
        DescribeConfigsResponse.ConfigSource configSource = x$19.source();
        DescribeConfigsResponse.ConfigSource configSource2 = DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG;
        if (configSource != null) {
            if (!configSource.equals(configSource2)) return false;
            return true;
        }
        if (configSource2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$2(String elem) {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)elem);
    }

    public AdminManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, KafkaZkClient zkClient) {
        this.config = config;
        this.metrics = metrics;
        this.metadataCache = metadataCache;
        this.zkClient = zkClient;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.logIdent_$eq(new StringBuilder(28).append("[Admin Manager on Broker ").append(config.brokerId()).append("]: ").toString());
        this.topicPurgatory = DelayedOperationPurgatory$.MODULE$.apply("topic", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5());
        this.adminZkClient = new AdminZkClient(zkClient);
        this.createTopicPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class));
        this.alterConfigPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class));
    }
}

