/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.executor.types;

import es.bsc.compss.types.annotations.parameter.DataType;
import java.util.List;

public abstract class ParameterResult {
    private final DataType type;

    public ParameterResult(DataType type) {
        this.type = type;
    }

    public final DataType getType() {
        return this.type;
    }

    public abstract boolean isCollective();

    public static class CollectiveResult
    extends ParameterResult {
        public final List<ParameterResult> elements;

        public CollectiveResult(DataType type, List<ParameterResult> elements) {
            super(type);
            this.elements = elements;
        }

        @Override
        public boolean isCollective() {
            return true;
        }

        public List<ParameterResult> getElements() {
            return this.elements;
        }

        public int size() {
            return this.elements.size();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("(" + this.getType().ordinal() + " [");
            for (ParameterResult r : this.elements) {
                sb.append(r.toString()).append(" ");
            }
            sb.append("])");
            return sb.toString();
        }
    }

    public static class SingleResult
    extends ParameterResult {
        private final String value;

        public SingleResult(DataType type, String value) {
            super(type);
            this.value = value;
        }

        @Override
        public boolean isCollective() {
            return false;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "(" + this.getType().ordinal() + " " + this.value + ")";
        }
    }
}

