/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.monitoring;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.monitoring.Metric;

public class MetricDefinition
implements Serializable {
    public static final int CONTINUOUS = 1;
    public static final int DISCRETE = 2;
    private String metricName;
    private int measurementType;
    private String dataType;
    private String unit;
    private Map<String, Object> parameterDefinitions;
    private Map<String, Object> returnDefinition;

    public MetricDefinition(String metricName, int measurementType, String dataType, String unit, Map<String, Object> parameterDefinitions, Map<String, Object> returnDefinition) {
        this.metricName = metricName;
        this.measurementType = measurementType;
        this.dataType = dataType;
        this.unit = unit;
        if (this.unit == null) {
            this.unit = "none";
        }
        this.parameterDefinitions = parameterDefinitions;
        if (this.parameterDefinitions == null) {
            this.parameterDefinitions = new HashMap<String, Object>();
        }
        this.returnDefinition = returnDefinition;
        if (this.returnDefinition == null) {
            this.returnDefinition = new HashMap<String, Object>();
        }
    }

    public Metric createMetric() throws GATInvocationException {
        return new Metric(this, null);
    }

    public Metric createMetric(Map<String, Object> parameters) {
        return new Metric(this, parameters);
    }

    public Metric createMetric(Map<String, Object> parameters, long frequency) {
        return new Metric(this, parameters, frequency);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MetricDefinition)) {
            return false;
        }
        MetricDefinition other = (MetricDefinition)o;
        return this.metricName.equals(other.metricName) && this.measurementType == other.measurementType && this.dataType.equals(other.dataType) && this.unit.equals(other.unit);
    }

    public String getDataType() {
        return this.dataType;
    }

    public int getMeasurementType() {
        return this.measurementType;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String getUnit() {
        return this.unit;
    }

    public Map<String, Object> getParameterDefinitions() {
        return this.parameterDefinitions;
    }

    public String toString() {
        String res = "MetricDefinition(" + this.metricName + ", type = ";
        res = res + (this.measurementType == 1 ? "CONTINUOUS" : "DISCRETE");
        res = res + ", datatype = " + this.dataType + ", unit = " + this.unit + ", params = " + this.parameterDefinitions + ")";
        return res;
    }

    public Map<String, Object> getReturnDefinition() {
        return this.returnDefinition;
    }
}

