/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.security.sshtrilead;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gridlab.gat.CouldNotInitializeCredentialException;
import org.gridlab.gat.CredentialExpiredException;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.InvalidUsernameOrPasswordException;
import org.gridlab.gat.URI;
import org.gridlab.gat.security.CertificateSecurityContext;
import org.gridlab.gat.security.CredentialSecurityContext;
import org.gridlab.gat.security.PasswordSecurityContext;
import org.gridlab.gat.security.SecurityContext;
import org.gridlab.gat.security.cpi.SecurityContextCreator;
import org.gridlab.gat.security.cpi.SecurityContextUtils;
import org.gridlab.gat.security.sshtrilead.SshTrileadSecurityUtils;

class SshTrileadContextCreator
implements SecurityContextCreator {
    SshTrileadContextCreator() {
    }

    public SecurityContext createDefaultSecurityContext(GATContext gatContext, URI location) throws CouldNotInitializeCredentialException, CredentialExpiredException, InvalidUsernameOrPasswordException {
        Map<String, Object> securityInfo = SshTrileadSecurityUtils.getDefaultUserInfo(gatContext, location);
        CredentialSecurityContext c = new CredentialSecurityContext();
        c.putDataObject("sshtrilead", securityInfo);
        return c;
    }

    public Object createUserData(GATContext gatContext, URI location, SecurityContext inContext) throws CouldNotInitializeCredentialException, CredentialExpiredException, InvalidUsernameOrPasswordException {
        HashMap<String, Object> securityInfo = new HashMap<String, Object>();
        if (inContext instanceof CredentialSecurityContext) {
            return inContext.getDataObject("sshtrilead");
        }
        if (inContext instanceof CertificateSecurityContext) {
            CertificateSecurityContext c = (CertificateSecurityContext)inContext;
            if (c.getUsername() != null) {
                securityInfo.put("username", c.getUsername());
            } else {
                securityInfo.put("username", SecurityContextUtils.getUser((GATContext)gatContext, (SecurityContext)inContext, (URI)location));
            }
            if (c.getPassword() != null) {
                securityInfo.put("password", c.getPassword());
            }
            if (c.getKeyfile() != null && c.getKeyfile().isCompatible("file") && c.getKeyfile().refersToLocalHost()) {
                securityInfo.put("keyfile", new File(c.getKeyfile().getPath()));
            } else {
                securityInfo.put("keyfile", SshTrileadSecurityUtils.getDefaultPrivateKeyfile());
            }
            return securityInfo;
        }
        if (inContext instanceof PasswordSecurityContext) {
            PasswordSecurityContext c = (PasswordSecurityContext)inContext;
            if (c.getUsername() != null) {
                securityInfo.put("username", c.getUsername());
            } else {
                securityInfo.put("username", SecurityContextUtils.getUser((GATContext)gatContext, (SecurityContext)inContext, (URI)location));
            }
            if (c.getPassword() != null) {
                securityInfo.put("password", c.getPassword());
            }
            return securityInfo;
        }
        return null;
    }
}

