/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.signature;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SignatureException;
import java.util.Arrays;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.signature.AbstractSignature;
import net.schmizz.sshj.signature.Signature;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DERSequence;

public class SignatureDSA
extends AbstractSignature {
    public SignatureDSA() {
        super("SHA1withDSA");
    }

    @Override
    public byte[] encode(byte[] sig) {
        int rIndex = 3;
        int rLen = sig[rIndex++] & 0xFF;
        byte[] r = new byte[rLen];
        System.arraycopy(sig, rIndex, r, 0, r.length);
        int sIndex = rIndex + rLen + 1;
        int sLen = sig[sIndex++] & 0xFF;
        byte[] s2 = new byte[sLen];
        System.arraycopy(sig, sIndex, s2, 0, s2.length);
        byte[] result = new byte[40];
        int r_copylen = r.length < 20 ? r.length : 20;
        int s_copylen = s2.length < 20 ? s2.length : 20;
        System.arraycopy(r, r.length - r_copylen, result, 20 - r_copylen, r_copylen);
        System.arraycopy(s2, s2.length - s_copylen, result, 40 - s_copylen, s_copylen);
        return result;
    }

    @Override
    public boolean verify(byte[] sig) {
        try {
            byte[] sigBlob = this.extractSig(sig, "ssh-dss");
            return this.signature.verify(this.asnEncode(sigBlob));
        }
        catch (SignatureException e) {
            throw new SSHRuntimeException(e);
        }
        catch (IOException e) {
            throw new SSHRuntimeException(e);
        }
    }

    private byte[] asnEncode(byte[] sigBlob) throws IOException {
        byte[] r = new BigInteger(1, Arrays.copyOfRange(sigBlob, 0, 20)).toByteArray();
        byte[] s2 = new BigInteger(1, Arrays.copyOfRange(sigBlob, 20, 40)).toByteArray();
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(new ASN1Integer(r));
        vector.add(new ASN1Integer(s2));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream asnOS = new ASN1OutputStream(baos);
        asnOS.writeObject(new DERSequence(vector));
        asnOS.flush();
        return baos.toByteArray();
    }

    public static class Factory
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureDSA();
        }

        @Override
        public String getName() {
            return KeyType.DSA.toString();
        }
    }
}

