/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.kex;

import java.security.GeneralSecurityException;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.transport.digest.Digest;
import net.schmizz.sshj.transport.digest.SHA256;
import net.schmizz.sshj.transport.digest.SHA384;
import net.schmizz.sshj.transport.digest.SHA512;
import net.schmizz.sshj.transport.kex.AbstractDHG;
import net.schmizz.sshj.transport.kex.DHBase;
import net.schmizz.sshj.transport.kex.ECDH;
import net.schmizz.sshj.transport.kex.KeyExchange;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;

public class ECDHNistP
extends AbstractDHG {
    private String curve;

    public ECDHNistP(String curve, Digest digest) {
        super(new ECDH(), digest);
        this.curve = curve;
    }

    @Override
    protected void initDH(DHBase dh) throws GeneralSecurityException {
        dh.init(new ECNamedCurveGenParameterSpec(this.curve), this.trans.getConfig().getRandomFactory());
    }

    public static class Factory256
    implements Factory.Named<KeyExchange> {
        @Override
        public KeyExchange create() {
            return new ECDHNistP("P-256", (Digest)new SHA256());
        }

        @Override
        public String getName() {
            return "ecdh-sha2-nistp256";
        }
    }

    public static class Factory384
    implements Factory.Named<KeyExchange> {
        @Override
        public KeyExchange create() {
            return new ECDHNistP("P-384", (Digest)new SHA384());
        }

        @Override
        public String getName() {
            return "ecdh-sha2-nistp384";
        }
    }

    public static class Factory521
    implements Factory.Named<KeyExchange> {
        @Override
        public KeyExchange create() {
            return new ECDHNistP("P-521", (Digest)new SHA512());
        }

        @Override
        public String getName() {
            return "ecdh-sha2-nistp521";
        }
    }
}

