/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.ec2.compute.strategy.ReviseParsedImage;
import org.jclouds.ec2.domain.Image;
import org.jclouds.logging.Logger;

@Singleton
public class AWSEC2ReviseParsedImage
implements ReviseParsedImage {
    public static final Pattern AMZN_PATTERN = Pattern.compile(".*/(amzn-hvm-|amzn-)?ami-(.*)\\.(i386|x86_64)(-ebs|\\.manifest.xml)?");
    public static final Pattern AMAZON_PATTERN = Pattern.compile("amazon/EC2 ([^ ]+) ([^ ]+).*");
    public static final Pattern AMAZON_WINDOWS_PATTERN = Pattern.compile(".*/(Windows)_Server-([^-]*-[^-]*)-.*-([^-]*)(\\.manifest.xml)?");
    public static final Pattern CENTOS_MARKETPLACE_PATTERN = Pattern.compile(".*/(CentOS) Linux ([^ ]*) (.*)(\\.manifest.xml)?");
    public static final Pattern CANONICAL_PATTERN = Pattern.compile(".*/([^-]*)-([^-]*)-.*-(.*)(\\.manifest.xml)?");
    public static final Pattern RIGHTSCALE_PATTERN = Pattern.compile("[^/]*/([^_]*)_([^_]*)_[^vV]*[vV](.*)(\\.manifest.xml)?");
    public static final Pattern RIGHTIMAGE_PATTERN = Pattern.compile("[^/]*/RightImage[_ ]([^_]*)_([^_]*)_[^vV]*[vV](.*)(\\.manifest.xml)?");
    private final Map<OsFamily, Map<String, String>> osVersionMap;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public AWSEC2ReviseParsedImage(Map<OsFamily, Map<String, String>> osVersionMap) {
        this.osVersionMap = Preconditions.checkNotNull(osVersionMap, "osVersionMap");
    }

    @Override
    public void reviseParsedImage(Image from, ImageBuilder builder, OsFamily family, OperatingSystem.Builder osBuilder) {
        try {
            Matcher matcher = this.getMatcherAndFind(from.getImageLocation());
            if (matcher.pattern() == AMZN_PATTERN) {
                osBuilder.family(OsFamily.AMZN_LINUX);
                osBuilder.version(matcher.group(2));
                builder.version(matcher.group(2));
            } else if (matcher.pattern() == AMAZON_PATTERN) {
                family = OsFamily.fromValue(matcher.group(1));
                osBuilder.family(family);
                osBuilder.version(ComputeServiceUtils.parseVersionOrReturnEmptyString(family, matcher.group(2), this.osVersionMap));
            } else {
                family = OsFamily.fromValue(matcher.group(1));
                osBuilder.family(family);
                osBuilder.version(ComputeServiceUtils.parseVersionOrReturnEmptyString(family, matcher.group(2), this.osVersionMap));
                builder.version(matcher.group(3).replace(".manifest.xml", ""));
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("<< didn't match os(%s)", from.getImageLocation());
        }
        catch (NoSuchElementException e) {
            this.logger.trace("<< didn't match at all(%s)", from.getImageLocation());
        }
    }

    private Matcher getMatcherAndFind(String manifest) {
        for (Pattern pattern : new Pattern[]{AMZN_PATTERN, AMAZON_PATTERN, AMAZON_WINDOWS_PATTERN, CENTOS_MARKETPLACE_PATTERN, CANONICAL_PATTERN, RIGHTIMAGE_PATTERN, RIGHTSCALE_PATTERN}) {
            Matcher matcher = pattern.matcher(manifest);
            if (!matcher.find()) continue;
            return matcher;
        }
        throw new NoSuchElementException(manifest);
    }
}

