/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.aws.ec2.domain.Route;
import org.jclouds.aws.ec2.domain.RouteTable;
import org.jclouds.aws.ec2.domain.RouteTableAssociation;
import org.jclouds.aws.ec2.xml.RouteSetHandler;
import org.jclouds.aws.ec2.xml.RouteTableAssociationSetHandler;
import org.jclouds.ec2.xml.TagSetHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class RouteTableHandler
extends ParseSax.HandlerWithResult<RouteTable> {
    RouteTable.Builder builder = RouteTable.builder();
    private StringBuilder currentText = new StringBuilder();
    private RouteSetHandler routeSetHandler;
    private RouteTableAssociationSetHandler routeTableAssociationSetHandler;
    private TagSetHandler tagSetHandler;
    boolean inRouteSet;
    boolean inRouteTableAssociationSet;
    boolean inTagSet;

    @Inject
    RouteTableHandler(TagSetHandler tagSetHandler, RouteSetHandler routeSetHandler, RouteTableAssociationSetHandler routeTableAssociationSetHandler) {
        this.tagSetHandler = tagSetHandler;
        this.routeSetHandler = routeSetHandler;
        this.routeTableAssociationSetHandler = routeTableAssociationSetHandler;
    }

    @Override
    public RouteTable getResult() {
        try {
            RouteTable routeTable = this.builder.build();
            return routeTable;
        }
        finally {
            this.builder = RouteTable.builder();
        }
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attrs) {
        this.currentText.setLength(0);
        if (SaxUtils.equalsOrSuffix(qName, "routeSet")) {
            this.inRouteSet = true;
        } else if (SaxUtils.equalsOrSuffix(qName, "associationSet")) {
            this.inRouteTableAssociationSet = true;
        } else if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = true;
        }
        if (this.inTagSet) {
            this.tagSetHandler.startElement(uri, name, qName, attrs);
        } else if (this.inRouteTableAssociationSet) {
            this.routeTableAssociationSetHandler.startElement(uri, name, qName, attrs);
        } else if (this.inRouteSet) {
            this.routeSetHandler.startElement(uri, name, qName, attrs);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = false;
            this.builder.tags((Map<String, String>)this.tagSetHandler.getResult());
        } else if (SaxUtils.equalsOrSuffix(qName, "routeSet")) {
            this.inRouteSet = false;
            this.builder.routeSet((List<Route>)this.routeSetHandler.getResult());
        } else if (SaxUtils.equalsOrSuffix(qName, "associationSet")) {
            this.inRouteTableAssociationSet = false;
            this.builder.associationSet((List<RouteTableAssociation>)this.routeTableAssociationSetHandler.getResult());
        } else if (this.inRouteSet) {
            this.routeSetHandler.endElement(uri, name, qName);
        } else if (this.inRouteTableAssociationSet) {
            this.routeTableAssociationSetHandler.endElement(uri, name, qName);
        } else if (this.inTagSet) {
            this.tagSetHandler.endElement(uri, name, qName);
        } else if (SaxUtils.equalsOrSuffix(qName, "vpcId")) {
            this.builder.vpcId(this.currentText.toString());
        } else if (SaxUtils.equalsOrSuffix(qName, "routeTableId")) {
            this.builder.id(this.currentText.toString());
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inRouteSet) {
            this.routeSetHandler.characters(ch, start, length);
        } else if (this.inRouteTableAssociationSet) {
            this.routeTableAssociationSetHandler.characters(ch, start, length);
        } else if (this.inTagSet) {
            this.tagSetHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

