/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azurecompute.arm.AzureComputeApi;
import org.jclouds.azurecompute.arm.compute.functions.AutoValue_VirtualMachineToStatus_StatusAndBackendStatus;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.Status;
import org.jclouds.azurecompute.arm.domain.VirtualMachine;
import org.jclouds.azurecompute.arm.domain.VirtualMachineInstance;
import org.jclouds.azurecompute.arm.domain.VirtualMachineProperties;
import org.jclouds.compute.domain.NodeMetadata;

@Singleton
public class VirtualMachineToStatus
implements Function<VirtualMachine, StatusAndBackendStatus> {
    private static final Function<VirtualMachineProperties.ProvisioningState, NodeMetadata.Status> PROVISIONINGSTATE_TO_NODESTATUS = Functions.forMap(ImmutableMap.builder().put(VirtualMachineProperties.ProvisioningState.ACCEPTED, NodeMetadata.Status.PENDING).put(VirtualMachineProperties.ProvisioningState.READY, NodeMetadata.Status.PENDING).put(VirtualMachineProperties.ProvisioningState.CREATING, NodeMetadata.Status.PENDING).put(VirtualMachineProperties.ProvisioningState.RUNNING, NodeMetadata.Status.PENDING).put(VirtualMachineProperties.ProvisioningState.UPDATING, NodeMetadata.Status.PENDING).put(VirtualMachineProperties.ProvisioningState.DELETED, NodeMetadata.Status.TERMINATED).put(VirtualMachineProperties.ProvisioningState.CANCELED, NodeMetadata.Status.TERMINATED).put(VirtualMachineProperties.ProvisioningState.FAILED, NodeMetadata.Status.ERROR).put(VirtualMachineProperties.ProvisioningState.UNRECOGNIZED, NodeMetadata.Status.UNRECOGNIZED).build(), NodeMetadata.Status.UNRECOGNIZED);
    private static final Function<VirtualMachineInstance.PowerState, NodeMetadata.Status> POWERSTATE_TO_NODESTATUS = Functions.forMap(ImmutableMap.builder().put(VirtualMachineInstance.PowerState.RUNNING, NodeMetadata.Status.RUNNING).put(VirtualMachineInstance.PowerState.STARTING, NodeMetadata.Status.PENDING).put(VirtualMachineInstance.PowerState.STOPPED, NodeMetadata.Status.SUSPENDED).put(VirtualMachineInstance.PowerState.STOPPING, NodeMetadata.Status.PENDING).put(VirtualMachineInstance.PowerState.DEALLOCATED, NodeMetadata.Status.SUSPENDED).put(VirtualMachineInstance.PowerState.DEALLOCATING, NodeMetadata.Status.PENDING).put(VirtualMachineInstance.PowerState.UNKNOWN, NodeMetadata.Status.UNRECOGNIZED).build(), NodeMetadata.Status.UNRECOGNIZED);
    private final AzureComputeApi api;

    @Inject
    VirtualMachineToStatus(AzureComputeApi api) {
        this.api = api;
    }

    @Override
    public StatusAndBackendStatus apply(VirtualMachine virtualMachine) {
        String resourceGroup = IdReference.extractResourceGroup(virtualMachine.id());
        VirtualMachineProperties.ProvisioningState provisioningState = virtualMachine.properties().provisioningState();
        NodeMetadata.Status status = PROVISIONINGSTATE_TO_NODESTATUS.apply(provisioningState);
        String backendStatus = provisioningState.name();
        if (VirtualMachineProperties.ProvisioningState.SUCCEEDED.equals((Object)provisioningState)) {
            VirtualMachineInstance instanceDetails = this.api.getVirtualMachineApi(resourceGroup).getInstanceDetails(virtualMachine.name());
            if (instanceDetails != null && instanceDetails.powerState() != null) {
                status = POWERSTATE_TO_NODESTATUS.apply(instanceDetails.powerState());
                backendStatus = Joiner.on(',').join(Iterables.transform(instanceDetails.statuses(), new Function<Status, String>(){

                    @Override
                    public String apply(Status input) {
                        return input.code();
                    }
                }));
            } else {
                status = NodeMetadata.Status.PENDING;
            }
        }
        return StatusAndBackendStatus.create(status, backendStatus);
    }

    public static abstract class StatusAndBackendStatus {
        public abstract NodeMetadata.Status status();

        public abstract String backendStatus();

        public static StatusAndBackendStatus create(NodeMetadata.Status status, String backendStatus) {
            return new AutoValue_VirtualMachineToStatus_StatusAndBackendStatus(status, backendStatus);
        }
    }
}

